/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.ClassFilter;
import ch.icit.util.ClassFinderException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);

    public static List<Class<?>> getClassesFromPackages(ClassFilter filter, List<String> pkgs, ClassLoader classLoader) throws ClassFinderException {
        ArrayList classes = new ArrayList();
        for (String pkg : pkgs) {
            List<Class<?>> c = ClassFinder.getClassesFromPackage(filter, pkg, classLoader);
            if (c == null) continue;
            classes.addAll(c);
        }
        return classes;
    }

    public static List<Class<?>> getClassesFromPackage(ClassFilter filter, Package pkg, ClassLoader classLoader) throws ClassFinderException {
        return ClassFinder.getClassesFromPackage(filter, pkg.getName(), classLoader);
    }

    public static List<Class<?>> getClassesFromDirectories(ClassFilter filter, List<File> directories, String pkgPrefix, ClassLoader classLoader) throws ClassFinderException {
        ArrayList classes = new ArrayList();
        for (File dir : directories) {
            List<Class<?>> c = ClassFinder.getClassesFromDirectory(filter, dir, pkgPrefix, classLoader);
            if (c == null) continue;
            classes.addAll(c);
        }
        return classes;
    }

    public static List<Class<?>> getClassesFromDirectory(ClassFilter filter, File directory, String pkgPrefix, ClassLoader classLoader) throws ClassFinderException {
        try {
            ArrayList classes = new ArrayList();
            if (!directory.exists()) {
                throw new ClassFinderException("Directory '" + directory + "' does not exist!");
            }
            log.debug("loading classes from directory '" + directory.getAbsolutePath() + "' ...");
            classes.addAll(ClassFinder.findClasses(filter, directory, pkgPrefix, ClassFinder.validateNotNull(classLoader)));
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new ClassFinderException("Failed to load class (" + e.getMessage() + ")", e);
        }
    }

    public static List<Class<?>> getClassesFromUrl(ClassFilter filter, URL url, String pkgPrefix, ClassLoader classLoader) throws ClassFinderException {
        File dir;
        ClassLoader loader = ClassFinder.validateNotNull(classLoader);
        ArrayList classes = new ArrayList();
        try {
            dir = new File(url.toURI());
        }
        catch (IllegalArgumentException ex) {
            dir = new File(url.getFile());
        }
        catch (URISyntaxException e) {
            throw new ClassFinderException("Failed to compute the URI for '" + url + "'", e);
        }
        try {
            if (dir.exists()) {
                log.debug("loading classes from directory '" + dir.getAbsolutePath() + "' ...");
                classes.addAll(ClassFinder.findClasses(filter, dir, pkgPrefix, loader));
            } else {
                log.debug("loading classes from jar file '" + dir.getAbsolutePath() + "' ...");
                JarURLConnection con = (JarURLConnection)url.openConnection();
                JarFile jfile = con.getJarFile();
                String starts = con.getEntryName();
                starts = starts == null ? "" : starts;
                Enumeration<JarEntry> e = jfile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(starts) || !name.endsWith(".class") || name.contains("$")) continue;
                    String classname = name.substring(0, name.length() - 6);
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    classname = classname.replace('/', '.');
                    Class<?> clazz = Class.forName(classname, false, loader);
                    if (filter != null && !filter.isClassValid(clazz)) continue;
                    classes.add(clazz);
                }
            }
        }
        catch (IOException e) {
            throw new ClassFinderException("Failed to read JAR file from the directory '" + dir.getAbsolutePath() + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new ClassFinderException("Failed to load class (" + e.getMessage() + ")", e);
        }
        return classes;
    }

    public static List<Class<?>> getClassesFromPackage(ClassFilter filter, String pkgName, ClassLoader classLoader) throws ClassFinderException {
        Enumeration<URL> urls;
        ClassLoader loader = ClassFinder.validateNotNull(classLoader);
        ArrayList classes = new ArrayList();
        try {
            urls = loader.getResources(pkgName.replace('.', '/'));
        }
        catch (IOException e) {
            throw new ClassFinderException(e);
        }
        if (urls == null || !urls.hasMoreElements()) {
            throw new ClassFinderException("Package '" + pkgName + "' could not be found!");
        }
        while (urls.hasMoreElements()) {
            classes.addAll(ClassFinder.getClassesFromUrl(filter, urls.nextElement(), pkgName, classLoader));
        }
        return classes;
    }

    private static ClassLoader validateNotNull(ClassLoader classLoader) {
        return classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    private static List<Class<?>> findClasses(ClassFilter filter, File directory, String packageName, ClassLoader classLoader) throws ClassNotFoundException {
        File[] files;
        String pkgName = packageName.startsWith(".") ? packageName.substring(1, packageName.length()) : packageName;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(ClassFinder.findClasses(filter, file, (pkgName.equals("") ? "" : pkgName + ".") + fileName, classLoader));
                continue;
            }
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            String className = pkgName + '.' + fileName.substring(0, fileName.length() - 6);
            Class<?> clazz = Class.forName(className, false, classLoader);
            if (filter != null && !filter.isClassValid(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }
}

