/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.FieldAccessMode;
import ch.icit.util.FieldFilter;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DeepObjectTraverser {
    private final FieldFilter fieldFilter;
    private final FieldAccessMode fieldAccessMode;
    private final int maxDepth;
    private Set<Object> processedObjects;

    public DeepObjectTraverser(FieldFilter fieldFilter, FieldAccessMode fieldAccessMode, int maxDepth) {
        this.fieldFilter = fieldFilter;
        this.fieldAccessMode = fieldAccessMode;
        this.maxDepth = maxDepth;
    }

    protected abstract boolean recurse(Field var1, Object var2);

    protected abstract void traverseFieldCallback(Field var1);

    protected abstract void traverseObjectCallback(Step<?> var1);

    public void traverse(Object object) throws InvokerException {
        if (object == null) {
            return;
        }
        this.processedObjects = new HashSet<Object>();
        this.traverseObject(null, null, object, null, StepType.SIMPLE);
    }

    private void traverseObject(Step<?> parent, Field field, Object obj, Integer index, StepType stepType) throws InvokerException {
        Class type;
        if (parent != null && parent.getLevel() + 1 >= this.maxDepth) {
            return;
        }
        Class clazz = type = obj == null ? Object.class : obj.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            this.traverseCollection(new Step((Collection)obj, field, parent, index, stepType));
        } else if (Map.class.isAssignableFrom(type)) {
            this.traverseMap(new Step((Map)obj, field, parent, index, stepType));
        } else {
            this.traverseSimpleObject(new Step(obj, field, parent, index, stepType));
        }
    }

    private void traverseSimpleObject(Step<?> step) throws InvokerException {
        Object obj = step.getObject();
        if (obj == null) {
            return;
        }
        Field field = step.getField();
        if (field != null && !this.recurse(field, obj)) {
            return;
        }
        if (!this.processedObjects.add(obj)) {
            return;
        }
        this.traverseObjectCallback(step);
        this.traverseFields(step);
    }

    private void traverseFields(Step<?> step) throws InvokerException {
        Object obj = step.getObject();
        assert (obj != null);
        boolean useGetter = this.fieldAccessMode.equals((Object)FieldAccessMode.METHOD);
        for (Field field : Invoker.getAllFields(obj.getClass(), this.fieldFilter)) {
            Object value = Invoker.getFieldValue(field, obj, null, useGetter);
            this.traverseFieldCallback(field);
            this.traverseObject(step, field, value, null, StepType.SIMPLE);
        }
    }

    private void traverseCollection(Step<Collection<?>> step) throws InvokerException {
        Collection<?> collection = step.getObject();
        if (collection == null) {
            return;
        }
        Field field = step.getField();
        int i = 0;
        for (Object o : collection) {
            this.traverseObject(step, field, o, i++, StepType.COLLECTION_VALUE);
        }
    }

    private void traverseMap(Step<Map<?, ?>> step) throws InvokerException {
        Map<?, ?> map = step.getObject();
        if (map == null) {
            return;
        }
        Field field = step.getField();
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.traverseObject(step, field, entry, i, StepType.MAP_KEY);
            this.traverseObject(step, field, entry, i, StepType.MAP_VALUE);
            ++i;
        }
    }

    protected class Step<T> {
        private final Step<?> parent;
        private final T object;
        private final Field field;
        private final Integer index;
        private final StepType type;

        private Step(T object, Field field, Step<?> parent, Integer index, StepType type) {
            this.object = object;
            this.field = field;
            this.parent = parent;
            this.index = index;
            this.type = type;
        }

        public Step<?> getParent() {
            return this.parent;
        }

        public T getObject() {
            return this.object;
        }

        public Field getField() {
            return this.field;
        }

        public int getLevel() {
            int level = 0;
            for (Step<?> s = this.parent; s != null; s = s.getParent()) {
                ++level;
            }
            return level;
        }

        protected StringBuilder getHierarchicalFieldname(StringBuilder str) {
            if (this.parent == null) {
                str.append(this.object == null ? null : this.object.getClass().getSimpleName());
            } else {
                this.parent.getHierarchicalFieldname(str);
                assert (this.field != null);
                if (this.index == null) {
                    str.append(".").append(this.field.getName());
                } else {
                    assert (this.field.getName().equals(this.parent.getField().getName()));
                    str.append("[").append(this.index).append("]");
                }
            }
            return str;
        }

        public String toString() {
            String fieldname = this.getHierarchicalFieldname(new StringBuilder()).toString();
            return fieldname + ": " + this.object;
        }

        public Integer getIndex() {
            return this.index;
        }

        public StepType getType() {
            return this.type;
        }
    }

    protected static enum StepType {
        SIMPLE,
        COLLECTION_VALUE,
        MAP_KEY,
        MAP_VALUE;

    }
}

