/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FTPClientExample {
    private static final Logger log = LoggerFactory.getLogger(FTPClientExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws UnknownHostException {
        FTPClient ftp;
        boolean storeFile = false;
        boolean binaryTransfer = false;
        boolean error = false;
        boolean listFiles = false;
        boolean listNames = false;
        boolean hidden = false;
        boolean localActive = false;
        boolean useEpsvWithIPv4 = false;
        boolean feat = false;
        boolean printHash = false;
        boolean mlst = false;
        boolean mlsd = false;
        boolean mdtm = false;
        boolean saveUnparseable = false;
        boolean lenient = false;
        long keepAliveTimeout = -1L;
        int controlKeepAliveReplyTimeout = -1;
        int minParams = 5;
        String protocol = null;
        String doCommand = null;
        Object trustmgr = null;
        String proxyHost = null;
        int proxyPort = 80;
        String proxyUser = null;
        String proxyPassword = null;
        String username = null;
        String password = null;
        String encoding = null;
        String serverTimeZoneId = null;
        String displayTimeZoneId = null;
        String serverType = null;
        String defaultDateFormat = null;
        String recentDateFormat = null;
        int port = 0;
        String server = null;
        String remote = null;
        String local = null;
        if (protocol == null) {
            if (proxyHost != null) {
                System.out.println("Using HTTP proxy server: " + proxyHost);
                ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
            } else {
                ftp = new FTPClient();
            }
        } else {
            String[] prot;
            FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
            ftp = ftps;
            if ("all".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            } else if ("valid".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
            } else if ("none".equals(trustmgr)) {
                ftps.setTrustManager(null);
            }
        }
        if (printHash) {
            ftp.setCopyStreamListener(FTPClientExample.createListener());
        }
        if (keepAliveTimeout >= 0L) {
            ftp.setControlKeepAliveTimeout(keepAliveTimeout);
        }
        if (controlKeepAliveReplyTimeout >= 0) {
            ftp.setControlKeepAliveReplyTimeout(controlKeepAliveReplyTimeout);
        }
        if (encoding != null) {
            ftp.setControlEncoding(encoding);
        }
        ftp.setListHiddenFiles(hidden);
        ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
        FTPClientConfig config = serverType != null ? new FTPClientConfig(serverType) : new FTPClientConfig();
        config.setUnparseableEntries(saveUnparseable);
        if (defaultDateFormat != null) {
            config.setDefaultDateFormatStr(defaultDateFormat);
        }
        if (recentDateFormat != null) {
            config.setRecentDateFormatStr(recentDateFormat);
        }
        ftp.configure(config);
        try {
            if (port > 0) {
                ftp.connect(server, port);
            } else {
                ftp.connect(server);
            }
            System.out.println("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort()));
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            log.error("Could not connect to server", (Throwable)e);
            System.exit(1);
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
                error = true;
            } else {
                System.out.println("Remote system is " + ftp.getSystemType());
                if (binaryTransfer) {
                    ftp.setFileType(2);
                } else {
                    ftp.setFileType(0);
                }
                if (localActive) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                if (storeFile) {
                    FileInputStream input = new FileInputStream(local);
                    ftp.storeFile(remote, (InputStream)input);
                    ((InputStream)input).close();
                } else if (listFiles || mlsd || mdtm || mlst || listNames) {
                    FTPFile f4;
                    int n;
                    if (mlsd) {
                        FTPFile[] input = ftp.mlistDir(remote);
                        int n2 = input.length;
                        for (n = 0; n < n2; ++n) {
                            FTPFile f2 = input[n];
                            System.out.println(f2.getRawListing());
                            System.out.println(f2.toFormattedString(displayTimeZoneId));
                        }
                    }
                    if (mdtm) {
                        FTPFile f3 = ftp.mdtmFile(remote);
                        if (f3 != null) {
                            System.out.println(f3.getRawListing());
                            System.out.println(f3.toFormattedString(displayTimeZoneId));
                        } else {
                            System.out.println("File not found");
                        }
                    }
                    if (mlst && (f4 = ftp.mlistFile(remote)) != null) {
                        System.out.println(f4.toFormattedString(displayTimeZoneId));
                    }
                    if (listNames) {
                        String[] f4 = ftp.listNames(remote);
                        int n3 = f4.length;
                        for (n = 0; n < n3; ++n) {
                            String s = f4[n];
                            System.out.println(s);
                        }
                    }
                    if (listFiles) {
                        if (lenient || serverTimeZoneId != null) {
                            config.setLenientFutureDates(lenient);
                            if (serverTimeZoneId != null) {
                                config.setServerTimeZoneId(serverTimeZoneId);
                            }
                            ftp.configure(config);
                        }
                        for (FTPFile f2 : ftp.listFiles(remote)) {
                            System.out.println(f2.getRawListing());
                            System.out.println(f2.toFormattedString(displayTimeZoneId));
                        }
                    }
                } else if (feat) {
                    if (remote != null) {
                        if (ftp.hasFeature(remote)) {
                            System.out.println("Has feature: " + remote);
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " was not detected");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                        String[] features = ftp.featureValues(remote);
                        if (features != null) {
                            for (String f : features) {
                                System.out.println("FEAT " + remote + "=" + f + ".");
                            }
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " is not present");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                    } else if (!ftp.features()) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else if (doCommand != null) {
                    if (!ftp.doCommand(doCommand, remote)) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else {
                    FileOutputStream output = new FileOutputStream(local);
                    ftp.retrieveFile(remote, (OutputStream)output);
                    ((OutputStream)output).close();
                }
                ftp.noop();
                ftp.logout();
            }
        }
        catch (FTPConnectionClosedException e) {
            error = true;
            log.error("Server closed connection", (Throwable)e);
        }
        catch (IOException e) {
            error = true;
            log.error("Unable to connect to Server", (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException e) {}
            }
        }
        System.exit(error ? 1 : 0);
    }

    private static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal = 0L;

            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }

            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                long megs = totalBytesTransferred / 1000000L;
                for (long l = this.megsTotal; l < megs; ++l) {
                    System.err.print("#");
                }
                this.megsTotal = megs;
            }
        };
    }
}

