/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.CSVWorkbook;
import ch.icit.utils.ExcelCell;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import com.opencsv.CSVReader;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelToolkit {
    public static final String EXCEL_SUFFIX_WITHOUT_POINT = "xlsx";
    public static final String EXCEL_SUFFIX = ".xlsx";
    public static final int MAXIMUM_LENGTH_OF_CELL_CONTENTS = Short.MAX_VALUE;
    private static Logger log = LoggerFactory.getLogger(ExcelToolkit.class);

    public static StyledWorkbook createFastWorkbook() throws ExcelToolkitException {
        return ExcelToolkit.createFastWorkbook(null, 150);
    }

    public static StyledWorkbook createFastWorkbook(String sheetTitle, int window) throws ExcelToolkitException {
        StyledWorkbook wb = ExcelToolkit.createFastWorkBook(window);
        if (sheetTitle != null && !sheetTitle.isEmpty()) {
            ExcelToolkit.insertSheet(wb, sheetTitle);
        }
        return wb;
    }

    private static StyledWorkbook createFastWorkBook(int window) {
        SXSSFWorkbook book = new SXSSFWorkbook(window);
        StyledWorkbook workBook = new StyledWorkbook((Workbook)book);
        return workBook;
    }

    private static StyledWorkbook createXMLWorkBook() {
        XSSFWorkbook book = new XSSFWorkbook();
        StyledWorkbook workBook = new StyledWorkbook((Workbook)book);
        return workBook;
    }

    public static StyledWorkbook createCSVWorkbook() {
        return new CSVWorkbook();
    }

    public static StyledWorkbook createXMLWorkbook(String sheetTitle) throws ExcelToolkitException {
        StyledWorkbook wb = ExcelToolkit.createXMLWorkBook();
        if (sheetTitle != null && !sheetTitle.isEmpty()) {
            ExcelToolkit.insertSheet(wb, sheetTitle);
        }
        return wb;
    }

    private static StyledWorkbook createDefaultWorkBook() {
        XSSFWorkbook book = new XSSFWorkbook();
        StyledWorkbook workBook = new StyledWorkbook((Workbook)book);
        return workBook;
    }

    public static StyledWorkbook createDefaultWorkbook() throws ExcelToolkitException {
        return ExcelToolkit.createDefaultWorkbook(null);
    }

    public static StyledWorkbook createDefaultWorkbook(String sheetTitle) throws ExcelToolkitException {
        StyledWorkbook wb = ExcelToolkit.createXMLWorkBook();
        if (sheetTitle != null && !sheetTitle.isEmpty()) {
            ExcelToolkit.insertSheet(wb, sheetTitle);
        }
        return wb;
    }

    public static Sheet insertSheet(StyledWorkbook book, String sheetTitle) {
        String sn = ExcelToolkit.validateSheetName(sheetTitle);
        Sheet s = book.getWorkbook().createSheet(sn);
        return s;
    }

    public static String validateSheetName(String sheetTitle) {
        String t = sheetTitle.replaceAll("\\?", "X");
        t = t.replaceAll("\\*", "X");
        t = t.replaceAll("\\]", "X");
        t = t.replaceAll("\\[", "X");
        t = t.replaceAll("/", "X");
        if ((t = t.replaceAll(":", "")).length() > 31) {
            t = t.substring(0, 31);
        }
        if (t.length() == 0) {
            t = "Unknown";
        }
        return t;
    }

    public static String validateFile(String path) {
        String t = path.replaceAll("\\?", "X");
        t = t.replaceAll("\\*", "X");
        return t;
    }

    public static List<ExcelRow> readRows(String path) throws ExcelToolkitException {
        return ExcelToolkit.readRows(new File(path));
    }

    public static List<ExcelRow> readRowsWithTitle(File inputStream) throws ExcelToolkitException {
        return ExcelToolkit.readRows(inputStream, 0, true);
    }

    public static List<ExcelRow> readRows(File inputStream) throws ExcelToolkitException {
        return ExcelToolkit.readRows(inputStream, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRowsManually(File file, String separator, List<ExcelRow> rows) {
        StringBuffer b = new StringBuffer();
        for (ExcelRow r : rows) {
            for (int i = 0; i < r.getCells().size(); ++i) {
                Object o = r.getCells().get(i);
                String cellValue = o != null ? o.toString() : "";
                b.append("\"" + cellValue + "\"");
                if (i + 1 >= r.getCells().size()) continue;
                b.append(separator);
            }
            b.append("\n");
        }
        try {
            byte[] ptext = b.toString().getBytes(StandardCharsets.UTF_8);
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(ptext);
            try {
                baos.writeTo(fos);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUnspecifiedCSV(File file, List<ExcelRow> rows) {
        StringBuffer b = new StringBuffer();
        for (ExcelRow r : rows) {
            for (Object o : r.getCells()) {
                b.append(o != null ? o.toString() : "");
            }
            b.append("\n");
        }
        try {
            byte[] ptext = b.toString().getBytes(StandardCharsets.UTF_8);
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(ptext);
            try {
                baos.writeTo(fos);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<ExcelRow> readUnspecifiedCSV(File inputStream) throws ExcelToolkitException {
        try {
            ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputStream), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    ExcelRow row = new ExcelRow();
                    row.addCell(line, new String[0]);
                    rows.add(row);
                }
            }
            return rows;
        }
        catch (Exception e) {
            return new ArrayList<ExcelRow>();
        }
    }

    public static List<ExcelRow> readRowsManually(File inputStream, char separator) throws ExcelToolkitException {
        return ExcelToolkit.readRowsManually(inputStream, separator, '\"');
    }

    public static List<ExcelRow> readRowsManually(File inputStream, char separator, char quote) throws ExcelToolkitException {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        try (CSVReader reader = new CSVReader((Reader)new FileReader(inputStream), separator, quote);){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                ExcelRow r = new ExcelRow();
                for (String n : nextLine) {
                    r.addCell(n, new String[0]);
                }
                rows.add(r);
            }
        }
        catch (IOException e1) {
            throw new ExcelToolkitException("Unable to read csv file", e1);
        }
        return rows;
    }

    private static Object cast(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            Integer i = Integer.valueOf(s);
            return i;
        }
        catch (NumberFormatException i) {
            try {
                Long i2 = Long.valueOf(s);
                return i2;
            }
            catch (NumberFormatException i2) {
                try {
                    Double i3 = Double.valueOf(s);
                    return i3;
                }
                catch (NumberFormatException numberFormatException) {
                    return s;
                }
            }
        }
    }

    public static List<ExcelRow> readRows(File inputStream, int sheetNo) throws ExcelToolkitException {
        return ExcelToolkit.readRows(inputStream, sheetNo, false);
    }

    public static List<ExcelRow> readRows(File inputStream, int sheetNo, boolean withTitle) throws ExcelToolkitException {
        return ExcelToolkit.readRows(inputStream, sheetNo, withTitle, -1);
    }

    public static List<ExcelRow> readRows(File inputStream, int sheetNo, boolean withTitle, int maxCells) throws ExcelToolkitException {
        if (inputStream == null) {
            return new ArrayList<ExcelRow>();
        }
        ArrayList<ExcelRow> tRows = new ArrayList<ExcelRow>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((File)inputStream);
            Sheet sheet = workbook.getSheetAt(sheetNo);
            Iterator rows = sheet.rowIterator();
            int i = 0;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                if (i < 1 && !withTitle) {
                    ++i;
                    continue;
                }
                ExcelRow r = new ExcelRow(row.getLastCellNum());
                if (tRows.isEmpty()) {
                    r.setHeader(true);
                }
                int index = 0;
                for (int j = 0; j < row.getLastCellNum() && (maxCells == -1 || maxCells > j); ++j) {
                    Object cellData = ExcelToolkit.readValue(row.getCell(j));
                    r.getCells().add(index, cellData);
                    ++index;
                }
                tRows.add(r);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExcelToolkitException("", e);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new ExcelToolkitException("", e);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return tRows;
    }

    public static Object readValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateUtil.getJavaDate((double)cell.getNumericCellValue());
                }
                return cell.getNumericCellValue();
            }
            case 3: {
                return "";
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return "";
    }

    public static List<ExcelRow> readRows(Workbook wb, int sheet, int startRow, int endRow) {
        ArrayList<ExcelRow> list = new ArrayList<ExcelRow>();
        for (int i = startRow; i < endRow + 1; ++i) {
            ExcelRow excelRow = new ExcelRow();
            Row row = wb.getSheetAt(sheet).getRow(i);
            for (Cell cell : row) {
                excelRow.getCells().add(ExcelToolkit.readValue(cell));
            }
            list.add(excelRow);
        }
        return list;
    }

    public static ExcelRow readRow(Workbook wb, int sheet, int numRow) {
        return ExcelToolkit.readRow(wb, sheet, numRow, 0, wb.getSheetAt(sheet).getRow(numRow).getLastCellNum());
    }

    public static ExcelRow readRow(Workbook wb, int sheet, int numRow, int startCol, int endCol) {
        ExcelRow excelRow = new ExcelRow();
        Row row = wb.getSheetAt(sheet).getRow(numRow);
        for (Cell cell : row) {
            excelRow.getCells().add(ExcelToolkit.readValue(cell));
        }
        return excelRow;
    }

    public static File writeWorkBook(File file, List<ExcelRow> rows, String sheetName) throws ExcelToolkitException {
        int cr = 0;
        StyledWorkbook wb = ExcelToolkit.createFastWorkbook();
        Sheet s = ExcelToolkit.insertSheet(wb, sheetName);
        for (ExcelRow r : rows) {
            cr = r.writeRow(wb, s, r.isHeader(), cr);
        }
        ExcelToolkit.writeWorkBook(file, wb);
        return file;
    }

    public static File writeWorkBook(String path, StyledWorkbook workbook) throws ExcelToolkitException {
        String newPath = ExcelToolkit.validateFile(path);
        if (workbook instanceof CSVWorkbook) {
            return ((CSVWorkbook)workbook).writeToFile(newPath);
        }
        return ExcelToolkit.writeWorkBook(new File(newPath), workbook);
    }

    public static File writeWorkBook(File file, StyledWorkbook workbook) throws ExcelToolkitException {
        try {
            FileOutputStream outFile = new FileOutputStream(file);
            workbook.getWorkbook().write((OutputStream)outFile);
            outFile.close();
            if (workbook.getWorkbook() instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook.getWorkbook()).dispose();
            }
        }
        catch (IOException e) {
            throw new ExcelToolkitException("", e);
        }
        return file;
    }

    public static void addHeader(Sheet sheet, String text, HeaderFooterPosition position) {
        Header header = sheet.getHeader();
        switch (position) {
            case CENTER: {
                header.setCenter(text);
                break;
            }
            case LEFT: {
                header.setLeft(text);
                break;
            }
            case RIGHT: {
                header.setRight(text);
            }
        }
    }

    public static void addFooter(Sheet sheet, String text, HeaderFooterPosition position) {
        Footer footer = sheet.getFooter();
        switch (position) {
            case CENTER: {
                footer.setCenter(text);
                break;
            }
            case LEFT: {
                footer.setLeft(text);
                break;
            }
            case RIGHT: {
                footer.setRight(text);
            }
        }
    }

    public static int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, List<Object> cells, int currentRow, String ... sumString) {
        int count = 0;
        if (currentRow > 1048575) {
            throw new IllegalStateException("Max row count reached: a excel sheet can only contains 1048575 rows");
        }
        Row r = sheet.createRow(currentRow);
        StyledWorkbook styledWb = workbook;
        for (Object cellData : cells) {
            Cell c = r.createCell(count);
            Object v = cellData;
            if (cellData instanceof File) {
                try {
                    FileInputStream inputStream = new FileInputStream((File)cellData);
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    int pictureIdx = styledWb.getWorkbook().addPicture(bytes, 6);
                    ((InputStream)inputStream).close();
                    CreationHelper helper = styledWb.getWorkbook().getCreationHelper();
                    Drawing drawing = sheet.createDrawingPatriarch();
                    ClientAnchor anchor = helper.createClientAnchor();
                    anchor.setCol1(count);
                    anchor.setRow1(currentRow);
                    anchor.setCol2(count + 1);
                    anchor.setRow2(currentRow + 1);
                    Picture picture = drawing.createPicture(anchor, pictureIdx);
                    Dimension imageDimension = picture.getImageDimension();
                    double ratio = imageDimension.getHeight() / imageDimension.getWidth();
                    double imageWidth = workbook.getDefaultImageWidth();
                    sheet.setColumnWidth(count + 1, ExcelToolkit.cmToW(imageWidth));
                    c.getRow().setHeight((short)ExcelToolkit.cmToH(imageWidth * ratio));
                }
                catch (IOException e) {
                    System.out.println("Picture not included in Excel Sheet" + ((File)cellData).getAbsolutePath());
                }
            }
            if (cellData instanceof ExcelCell) {
                v = ((ExcelCell)cellData).getValue();
            }
            ExcelToolkit.addCellStyled(c, v, isHeader, sheet, styledWb);
            if (cellData instanceof ExcelCell) {
                ExcelCell cell = (ExcelCell)cellData;
                if (cell.getCellStyle() != null) {
                    c.setCellStyle(cell.getCellStyle());
                }
                switch (cell.getAlignment()) {
                    case 3: {
                        if (isHeader) {
                            c.setCellStyle(styledWb.getHeaderRightStyle());
                            break;
                        }
                        c.setCellStyle(styledWb.getRightStyle());
                    }
                }
                if (cell.getxSpan() > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(currentRow, currentRow, count, count + (cell.getxSpan() - 1)));
                    count += cell.getxSpan() - 1;
                }
                if (cell.getFormulaExpression() != null && !cell.getFormulaExpression().isEmpty()) {
                    c.setCellFormula(cell.getFormulaExpression());
                }
            }
            ++count;
        }
        if (sumString != null) {
            for (String s : sumString) {
                Cell c = r.createCell(count);
                ExcelToolkit.addCellStyled(c, s, true, sheet, styledWb);
                ++count;
            }
        }
        return currentRow + 1;
    }

    private static int cmToH(double cm) {
        return (int)(Units.pixelToPoints((int)ExcelToolkit.cmToPx(cm)) * 20.0);
    }

    private static int cmToPx(double cm) {
        return (int)Math.round(cm * 96.0 / 2.54);
    }

    private static int cmToW(double cm) {
        return (int)Math.round((((double)ExcelToolkit.cmToPx(cm) - 5.0) / 7.0 * 7.0 + 5.0) / 7.0 * 256.0);
    }

    private static Date getDateWithMidnightTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new Date(cal.getTimeInMillis());
    }

    public static void addCellStyled(Cell cell, Object value, boolean isHeader, Sheet sheet, StyledWorkbook wb) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue != null && stringValue.length() > Short.MAX_VALUE) {
                stringValue = stringValue.substring(0, Short.MAX_VALUE);
            }
            if (stringValue.startsWith("=")) {
                String cvv;
                if (isHeader) {
                    cell.setCellStyle(wb.getHeaderDecimalStyle());
                } else {
                    cell.setCellStyle(wb.getDecimalStyle());
                }
                String cv = cvv = ExcelToolkit.ensureParameterCount(stringValue);
                cell.setCellFormula(cv);
            } else {
                if (isHeader) {
                    cell.setCellStyle(wb.getHeaderDefaultStyle());
                } else {
                    cell.setCellStyle(wb.getDefaultStyle());
                }
                cell.setCellValue(stringValue);
            }
        } else if (value instanceof Integer) {
            CellStyle intStyle = null;
            intStyle = isHeader ? (wb.isUseIntegerStyleWithoutSeperator() ? wb.getHeaderIntegerWithoutSeperatorStyle() : wb.getHeaderIntegerStyle()) : (wb.isUseIntegerStyleWithoutSeperator() ? wb.getIntegerWithoutSeperatorStyle() : wb.getIntegerStyle());
            cell.setCellStyle(intStyle);
            cell.setCellValue(new Double(((Integer)value).intValue()).doubleValue());
        } else if (value instanceof Double) {
            if (isHeader) {
                cell.setCellStyle(wb.getHeaderDecimalStyle());
            } else {
                cell.setCellStyle(wb.getDecimalStyle());
            }
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Long) {
            if (isHeader) {
                cell.setCellStyle(wb.getHeaderIntegerStyle());
            } else {
                cell.setCellStyle(wb.getIntegerStyle());
            }
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof java.util.Date) {
            if (value instanceof Time) {
                if (isHeader) {
                    cell.setCellStyle(wb.getHeaderTimeStyle());
                } else {
                    cell.setCellStyle(wb.getTimeStyle());
                }
            } else if (value instanceof Timestamp) {
                if (isHeader) {
                    cell.setCellStyle(wb.getHeaderDateTimeStyle());
                } else {
                    cell.setCellStyle(wb.getDateTimeStyle());
                }
            } else if (isHeader) {
                cell.setCellStyle(wb.getHeaderDateStyle());
            } else {
                cell.setCellStyle(wb.getDateStyle());
            }
            java.util.Date d = (java.util.Date)value;
            if (!(d instanceof Time) && !(d instanceof Timestamp)) {
                d = ExcelToolkit.getDateWithMidnightTime(d);
            }
            cell.setCellValue(d);
        } else if (value instanceof Boolean) {
            if (isHeader) {
                cell.setCellStyle(wb.getHeaderDefaultStyle());
            } else {
                cell.setCellStyle(wb.getDefaultStyle());
            }
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (!(value instanceof File) && value != null) {
            String stringValue = value.toString();
            if (stringValue != null && stringValue.length() > Short.MAX_VALUE) {
                stringValue = stringValue.substring(0, Short.MAX_VALUE);
            }
            if (isHeader) {
                cell.setCellStyle(wb.getHeaderDefaultStyle());
            } else {
                cell.setCellStyle(wb.getDefaultStyle());
            }
            cell.setCellValue(stringValue);
        }
    }

    private static String ensureParameterCount(String formula) {
        String t = formula;
        if (t.startsWith("=SUM(")) {
            String parameters = t.substring(5, t.length() - 1);
            String[] paraSet = parameters.split(",");
            while (paraSet.length > 254) {
                paraSet = ExcelToolkit.groupParameters(paraSet, 255);
            }
            t = "SUM(";
            for (String s : paraSet) {
                t = t + s + ",";
            }
            if (paraSet.length > 0) {
                t = t.substring(0, t.length() - 1);
            }
            t = t + ")";
        } else if (t.startsWith("=")) {
            return t.substring(1, t.length());
        }
        return t;
    }

    private static String[] groupParameters(String[] params, int groupSize) {
        ArrayList<String> returns = new ArrayList<String>();
        int i = 0;
        StringBuffer currentBuffer = new StringBuffer();
        currentBuffer.append("(");
        for (String s : params) {
            currentBuffer.append(s);
            if (++i == groupSize) {
                currentBuffer.append(")");
                returns.add(currentBuffer.toString());
                currentBuffer = new StringBuffer();
                currentBuffer.append("(");
                i = 0;
                continue;
            }
            currentBuffer.append(",");
        }
        String t = currentBuffer.toString();
        if (!t.isEmpty()) {
            t = t.substring(0, t.length() - 1);
            t = t + ")";
            returns.add(t);
        }
        return returns.toArray(new String[0]);
    }

    public static void addCell(Cell cell, Object value, boolean isHeader) {
        if (value instanceof String) {
            if (((String)value).startsWith("=")) {
                String cv = ((String)value).substring(1);
                cv = ExcelToolkit.ensureParameterCount(cv);
                cell.setCellFormula(cv);
                cell.setCellType(2);
            } else {
                cell.setCellValue((String)value);
            }
        } else if (value instanceof Integer) {
            CellStyle intStyle = null;
            cell.setCellStyle(intStyle);
            cell.setCellValue(new Double(((Integer)value).intValue()).doubleValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof java.util.Date) {
            cell.setCellValue((java.util.Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value != null) {
            cell.setCellValue(value.toString());
        }
    }

    public static int addSpace(Sheet sheet, int currentRow) {
        sheet.createRow(currentRow);
        return currentRow + 1;
    }

    public static String getAlpha4Digit(int col) {
        if (col <= 26) {
            return "" + (char)(col + 64);
        }
        return ExcelToolkit.getAlpha4Digit(--col / 26) + ExcelToolkit.getAlpha4Digit(col % 26 + 1);
    }

    private static String createSUMString(String arguments) {
        String[] splits = arguments.split(",");
        String sumstring = "SUM(";
        for (int i = 0; i < splits.length; ++i) {
            sumstring = sumstring + splits[i] + ",";
        }
        if (splits.length > 0) {
            sumstring = sumstring.substring(0, sumstring.length() - 1);
        }
        sumstring = sumstring + ")";
        return sumstring;
    }

    public static String ensureExcelPostfixXLSX(String name) {
        String t = name;
        if (t == null) {
            t = "";
        }
        if (!t.endsWith(EXCEL_SUFFIX)) {
            t = t + EXCEL_SUFFIX;
        }
        return t;
    }

    public static void addRows(StyledWorkbook wb, List<ExcelRow> rows, String sheetName) {
        Sheet s = ExcelToolkit.insertSheet(wb, sheetName);
        ExcelToolkit.addRows(wb, rows, s);
    }

    public static void addRows(StyledWorkbook wb, List<ExcelRow> rows, Sheet sheet) {
        int cr = 0;
        for (ExcelRow r : rows) {
            cr = r.writeRow(wb, sheet, r.isHeader(), cr);
        }
    }

    public static Workbook readWorkbookFromFile(File file) throws InvalidFormatException, IOException {
        FileInputStream inp = new FileInputStream(file);
        return WorkbookFactory.create((InputStream)inp);
    }

    public static Workbook readWorkbookFromFile(String filename) throws InvalidFormatException, IOException {
        return ExcelToolkit.readWorkbookFromFile(new File(filename));
    }

    public static void overwriteCells(Workbook wb, int sheetnbr, int startCol, int startRow, Object[][] data, boolean createNewCells) {
        Sheet sheet = wb.getSheetAt(sheetnbr);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                Row row = sheet.getRow(startRow + j);
                if (row == null) {
                    if (!createNewCells) continue;
                    row = sheet.createRow(startRow + j);
                }
                if (row.getCell(startCol + i) == null) {
                    if (!createNewCells) continue;
                    row.createCell(startCol + i);
                }
                ExcelToolkit.addCell(row.getCell(startRow + 1), data[i][j], false);
            }
        }
        try {
            wb.setForceFormulaRecalculation(true);
        }
        catch (AbstractMethodError error) {
            wb.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
    }

    public static void overwriteCells(Workbook wb, int sheetnbr, Map<int[], Object> values, boolean createNewCells) {
        Sheet sheet = wb.getSheetAt(sheetnbr);
        for (Map.Entry<int[], Object> value : values.entrySet()) {
            Row row = sheet.getRow(value.getKey()[1]);
            if (row == null) {
                if (!createNewCells) continue;
                row = sheet.createRow(value.getKey()[1]);
            }
            if (row.getCell(value.getKey()[0]) == null) {
                if (!createNewCells) continue;
                row.createCell(value.getKey()[0]);
            }
            ExcelToolkit.addCell(row.getCell(value.getKey()[0]), value.getValue(), false);
        }
        try {
            wb.setForceFormulaRecalculation(true);
        }
        catch (AbstractMethodError error) {
            wb.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
    }

    public static int getNumRows(Workbook wb, int sheetNo) {
        if (wb.getSheetAt(sheetNo) != null) {
            return wb.getSheetAt(sheetNo).getLastRowNum();
        }
        return 0;
    }

    public static ExcelCell getColumnSumCell(int rowStart, int rowStop, int column) {
        String colChar = ExcelToolkit.getAlpha4Digit(column);
        ExcelCell cell = new ExcelCell(0.0);
        cell.setFormulaExpression("SUM(" + colChar + rowStart + ":" + colChar + rowStop + ")");
        return cell;
    }

    public static ExcelCell getColumnSumCell(List<Integer> sumRows, int column) {
        String colChar = ExcelToolkit.getAlpha4Digit(column);
        String sumString = "";
        for (Integer integer : sumRows) {
            if (!sumString.equals("")) {
                sumString = sumString + "+";
            }
            sumString = sumString + colChar + integer;
        }
        ExcelCell cell = new ExcelCell(0.0);
        cell.setFormulaExpression(sumString);
        return cell;
    }

    public static java.util.Date readAsDate(ExcelRow row, int columnIndex) {
        if (row.getCellValue(columnIndex) instanceof java.util.Date) {
            return (java.util.Date)row.getCellValue(columnIndex);
        }
        if (row.getCellValue(columnIndex) instanceof String) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                java.util.Date date = formatter.parse((String)row.getCellValue(columnIndex));
                return date;
            }
            catch (Exception formatter) {
                try {
                    SimpleDateFormat formatter2 = new SimpleDateFormat("dd/MM/yyyy");
                    java.util.Date date = formatter2.parse((String)row.getCellValue(columnIndex));
                    return date;
                }
                catch (Exception formatter2) {
                    try {
                        SimpleDateFormat formatter3 = new SimpleDateFormat("dd.MM.yyyy");
                        java.util.Date date = formatter3.parse((String)row.getCellValue(columnIndex));
                        return date;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static java.util.Date readAsDateTime(ExcelRow row, int columnIndex) {
        if (row.getCellValue(columnIndex) instanceof java.util.Date) {
            return (java.util.Date)row.getCellValue(columnIndex);
        }
        if (row.getCellValue(columnIndex) instanceof String) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                java.util.Date date = formatter.parse((String)row.getCellValue(columnIndex));
                return date;
            }
            catch (Exception formatter) {
                try {
                    SimpleDateFormat formatter2 = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    java.util.Date date = formatter2.parse((String)row.getCellValue(columnIndex));
                    return date;
                }
                catch (Exception formatter2) {
                    try {
                        SimpleDateFormat formatter3 = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                        java.util.Date date = formatter3.parse((String)row.getCellValue(columnIndex));
                        return date;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static Boolean readAsBoolean(ExcelRow row, int columnIndex) {
        Boolean replace = null;
        if (row.getCellValue(columnIndex) instanceof Boolean) {
            replace = (Boolean)row.getCellValue(columnIndex);
        } else if (row.getCellValue(columnIndex) instanceof String) {
            String t = (String)row.getCellValue(columnIndex);
            replace = "yes".equalsIgnoreCase(t) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return replace;
    }

    public static Double readAsDouble(ExcelRow row, int columnIndex) {
        Double newAmount = null;
        if (row.getCellValue(columnIndex) instanceof String) {
            try {
                newAmount = Double.valueOf((String)row.getCellValue(columnIndex));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (row.getCellValue(columnIndex) instanceof Integer) {
            newAmount = ((Integer)row.getCellValue(columnIndex)).doubleValue();
        } else if (row.getCellValue(columnIndex) instanceof Double) {
            newAmount = (Double)row.getCellValue(columnIndex);
        }
        return newAmount;
    }

    public static Integer readAsInteger(ExcelRow row, int columnIndex) {
        Integer integer = null;
        if (row.getCellValue(columnIndex) instanceof String) {
            try {
                integer = Integer.valueOf((String)row.getCellValue(columnIndex));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (row.getCellValue(columnIndex) instanceof Integer) {
            integer = (Integer)row.getCellValue(columnIndex);
        } else if (row.getCellValue(columnIndex) instanceof Double) {
            integer = ((Double)row.getCellValue(columnIndex)).intValue();
        }
        return integer;
    }

    public static Long readAsLong(ExcelRow row, int columnIndex) {
        Long longValue = null;
        if (row.getCellValue(columnIndex) instanceof String) {
            try {
                longValue = Long.valueOf((String)row.getCellValue(columnIndex));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (row.getCellValue(columnIndex) instanceof Integer) {
            longValue = ((Integer)row.getCellValue(columnIndex)).longValue();
        } else if (row.getCellValue(columnIndex) instanceof Double) {
            longValue = ((Double)row.getCellValue(columnIndex)).longValue();
        } else if (row.getCellValue(columnIndex) instanceof Long) {
            longValue = (Long)row.getCellValue(columnIndex);
        }
        return longValue;
    }

    public static String readAsString(ExcelRow row, int columnIndex) {
        String string = null;
        if (row.getCellValue(columnIndex) instanceof String) {
            string = (String)row.getCellValue(columnIndex);
        } else if (row.getCellValue(columnIndex) instanceof Integer) {
            string = row.getCellValue(columnIndex).toString();
        } else if (row.getCellValue(columnIndex) instanceof Double) {
            string = row.getCellValue(columnIndex).toString();
        }
        return string;
    }

    public static String convertStringToIntegerNumber(String value) {
        try {
            Double doubleValue = Double.valueOf(value);
            Integer integerValue = doubleValue.intValue();
            return integerValue.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    public static void setRegionBorderWithMedium(CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderBottom((int)BorderStyle.MEDIUM.getCode(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((int)BorderStyle.MEDIUM.getCode(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((int)BorderStyle.MEDIUM.getCode(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((int)BorderStyle.MEDIUM.getCode(), (CellRangeAddress)region, (Sheet)sheet);
    }

    public static CellStyle getErrorCellStyle(StyledWorkbook ws) {
        CellStyle dataStyle = ws.createCellStyle();
        dataStyle.setFillForegroundColor(IndexedColors.RED1.getIndex());
        dataStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataStyle.setFont(ws.getDefaultFont());
        return dataStyle;
    }

    public static enum HeaderFooterPosition {
        LEFT,
        RIGHT,
        CENTER;

    }
}

