/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelCell;
import ch.icit.utils.ExcelGroupToolkit;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.StyledWorkbook;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelRow
implements Comparable<ExcelRow> {
    public static String taxesSuffix = "{taxes}";
    public static String columnWildCard = "#";
    private List<Object> cells = new ArrayList<Object>();
    private Object userObject;
    private Object baseUserObject;
    private boolean isHeader;
    private CellStyle dataStyle = null;
    private List<String> additionalColumns;

    public ExcelRow(Object userObject, boolean isHeader) {
        this.userObject = userObject;
        this.isHeader = isHeader;
        this.dataStyle = null;
    }

    public ExcelRow(boolean isHeader) {
        this(null, isHeader);
    }

    public ExcelRow(Object userObject) {
        this(userObject, false);
    }

    public ExcelRow(CellStyle dataStyle) {
        this(null, false);
        this.dataStyle = dataStyle;
    }

    public ExcelRow() {
        this(null);
    }

    public CellStyle getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(CellStyle dataStyle) {
        this.dataStyle = dataStyle;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Object getBaseUserObject() {
        return this.baseUserObject;
    }

    public void setBaseUserObject(Object baseUserObject) {
        this.baseUserObject = baseUserObject;
    }

    public void setTitle(Object object, String ... fields) {
        this.doAddCell(object, fields);
    }

    public void addCell(Object object, String ... field) {
        if (this.dataStyle != null) {
            ExcelCell cell = new ExcelCell(object);
            cell.setCellStyle(this.dataStyle);
            this.doAddCell(cell, field);
        } else {
            this.doAddCell(object, field);
        }
    }

    public void addEmptyCells(int amount) {
        for (int i = 0; i < amount; ++i) {
            if (this.dataStyle != null) {
                ExcelCell cell = new ExcelCell("");
                cell.setCellStyle(this.dataStyle);
                this.cells.add(cell);
                continue;
            }
            this.cells.add("");
        }
    }

    public void addBooleanCell(Object o) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            Object object = o = b != false ? "yes" : "no";
        }
        if (o == null) {
            o = "no";
        }
        if (this.dataStyle != null) {
            ExcelCell cell = new ExcelCell(o);
            cell.setCellStyle(this.dataStyle);
            this.cells.add(cell);
        } else {
            this.cells.add(o);
        }
    }

    public void addCellToColumn(Object object, int columnToWrite) {
        if (this.cells.size() < columnToWrite) {
            for (int i = this.cells.size(); i < columnToWrite - 1; ++i) {
                this.addCell("", new String[0]);
            }
            this.addCell(object, new String[0]);
        } else if (this.dataStyle != null) {
            ExcelCell cell = new ExcelCell(object);
            cell.setCellStyle(this.dataStyle);
            this.cells.set(columnToWrite - 1, cell);
        } else {
            this.cells.set(columnToWrite - 1, object);
        }
    }

    public void addCellToColumn(Object object, String column) {
        int columnToWrite = 0;
        if (column.length() == 1) {
            columnToWrite = column.charAt(0) - 64;
        } else if (column.length() == 2) {
            char[] charArray = column.toCharArray();
            columnToWrite = (charArray[0] - 64) * 26 + (charArray[1] - 64);
        } else if (column.length() > 2) {
            System.out.println("More than two Letter Columns are not supported");
        }
        if (this.cells.size() < columnToWrite) {
            for (int i = this.cells.size(); i < columnToWrite - 1; ++i) {
                this.addCell("", new String[0]);
            }
            if (this.dataStyle != null) {
                ExcelCell cell = new ExcelCell(object);
                cell.setCellStyle(this.dataStyle);
                this.doAddCell(cell, new String[0]);
            } else {
                this.doAddCell(object, new String[0]);
            }
        } else if (this.dataStyle != null) {
            ExcelCell cell = new ExcelCell(object);
            cell.setCellStyle(this.dataStyle);
            this.cells.set(columnToWrite - 1, cell);
        } else {
            this.cells.set(columnToWrite - 1, object);
        }
    }

    protected void doAddCell(Object object, String ... fields) {
        if (fields == null || fields.length == 0) {
            this.cells.add(object);
        } else {
            for (int i = 0; i < fields.length; ++i) {
                String f = fields[i];
                if (f.contains(taxesSuffix)) {
                    f = f.replace(taxesSuffix, "");
                }
                Object o = ExcelGroupToolkit.reflectionRead(object, f);
                if ((o = this.getValueSuffix(i, o, object)) instanceof Boolean) {
                    Boolean b = (Boolean)o;
                    o = b != false ? "yes" : "no";
                }
                this.cells.add(o);
            }
        }
    }

    public Object getValueSuffix(int index, Object value, Object orign) {
        return value;
    }

    public int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, int currentRow) {
        return this.writeRow(workbook, sheet, isHeader || this.isHeader, currentRow, null);
    }

    public int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, int currentRow, String sumString) {
        return this.writeRow(workbook, sheet, isHeader || this.isHeader, currentRow, sumString, null);
    }

    public int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, int currentRow, String sumString, int sumOffset) {
        return this.writeRow(workbook, sheet, isHeader || this.isHeader, currentRow, sumString, sumOffset, null);
    }

    public int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, int currentRow, String sumString, String secondSumString) {
        return this.writeRow(workbook, sheet, isHeader || this.isHeader, currentRow, sumString, 0, secondSumString);
    }

    public int writeRow(StyledWorkbook workbook, Sheet sheet, boolean isHeader, int currentRow, String sumString, int sumOffset, String secondSumString) {
        String h2Sum;
        ArrayList<String> additionals = new ArrayList<String>();
        String hSum = sumString;
        if (hSum != null && hSum.contains(columnWildCard)) {
            hSum = hSum.replaceAll(columnWildCard, "" + (currentRow + 1));
            for (int i = 0; i < sumOffset; ++i) {
                additionals.add("");
            }
            additionals.add(hSum);
        }
        if ((h2Sum = secondSumString) != null && h2Sum.contains(columnWildCard)) {
            h2Sum = h2Sum.replaceAll(columnWildCard, "" + (currentRow + 1));
            additionals.add(h2Sum);
        }
        if (this.additionalColumns != null) {
            for (String s : this.additionalColumns) {
                String t = s.replaceAll("&", "" + (currentRow + 1));
                additionals.add(t);
            }
        }
        return ExcelToolkit.writeRow(workbook, sheet, isHeader || this.isHeader, this.cells, currentRow, additionals.toArray(new String[0]));
    }

    public int getCellCount() {
        return this.cells.size();
    }

    public Object getCellValue(int i) {
        if (this.cells.size() > i) {
            return this.cells.get(i);
        }
        return null;
    }

    @Override
    public int compareTo(ExcelRow o) {
        if (this.userObject instanceof Comparable && o.getUserObject() instanceof Comparable) {
            return ((Comparable)this.userObject).compareTo(o.getUserObject());
        }
        if (!this.cells.isEmpty() && o.getCellCount() > 0) {
            Object i1 = this.cells.get(0);
            Object i2 = o.getCellValue(0);
            if (i1 instanceof Comparable && i2 instanceof Comparable) {
                return ((Comparable)i1).compareTo(i2);
            }
        }
        return 0;
    }

    public List<Object> getCells() {
        return this.cells;
    }

    public void fillRow(int i, Object placeHolder) {
        while (this.cells.size() < i) {
            this.cells.add(placeHolder);
        }
    }

    public void setAdditionalColumns(List<String> additionalColumns) {
        this.additionalColumns = additionalColumns;
    }

    public void addStyledCell(String test) {
    }
}

