/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.services.exception;

import ch.icit.pegasus.server.core.services.exception.ServiceExceptionMessages;
import ch.icit.pegasus.server.core.services.exception.ServiceFault;
import java.io.Serializable;
import javax.xml.ws.WebFault;

@WebFault(name="ServiceFault", targetNamespace="https://icit.ch/pegasus/")
public class ServiceException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ServiceExceptionMessages errorCode;
    private String[] replacements;
    private Long id;
    private transient Throwable serverCause;
    private ServiceFault fault;
    private boolean sendMail = true;

    public ServiceException() {
    }

    protected ServiceException(ServiceFault fault) {
        super(fault.getFaultString());
        this.fault = fault;
    }

    public ServiceException(String message, ServiceFault faultInfo) {
        super(message);
        this.fault = faultInfo;
    }

    public ServiceException(String message, ServiceFault faultInfo, Throwable cause) {
        super(message, cause);
        this.fault = faultInfo;
    }

    public ServiceFault getFaultInfo() {
        return this.fault;
    }

    public ServiceException(String message) {
        super(message);
    }

    public ServiceException(String message, boolean sendMail) {
        super(message);
        this.setSendMail(sendMail);
    }

    public ServiceException(String code, String message, boolean sendMail) {
        super(message);
        this.fault = new ServiceFault();
        this.fault.setFaultString(message);
        this.fault.setFaultCode(code);
        this.setSendMail(sendMail);
    }

    public ServiceException(Throwable cause) {
        super(cause);
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(String message, Throwable cause, boolean sendMail) {
        super(message, cause);
        this.setSendMail(sendMail);
    }

    public ServiceException(String message, ServiceExceptionMessages errorCode, String ... replacements) {
        super(message);
        this.errorCode = errorCode;
        this.replacements = replacements;
        this.setId(System.currentTimeMillis());
    }

    public ServiceException(Throwable serverCause, ServiceExceptionMessages errorCode, String ... replacements) {
        this(serverCause.getMessage(), errorCode, replacements);
        this.setStackTrace(serverCause.getStackTrace());
        this.setServerCause(serverCause);
    }

    public final ServiceExceptionMessages getErrorCode() {
        return this.errorCode;
    }

    public final String[] getReplacements() {
        return this.replacements;
    }

    private final void setId(Long value) {
        this.id = value;
    }

    public final Long getId() {
        return this.id;
    }

    public final void setServerCause(Throwable value) {
        this.serverCause = value;
    }

    public final Throwable getServerCause() {
        return this.serverCause != null ? this.serverCause : this;
    }

    public boolean isSendMail() {
        return this.sendMail;
    }

    public void setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
    }
}

