/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.services.supply;

import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataValidationCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.KonterProbenSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryProductCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRecipeCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.MatDispoSupplierAndStoreTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.AmountModificationComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.IStockInventoryWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.ServiceImplementation;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.Map;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

@Remote
@WebService(targetNamespace="https://icit.ch/pegasus/storeservice")
@SOAPBinding(style=SOAPBinding.Style.RPC)
@ServiceImplementation(implementation="StoreServiceImpl")
public interface StoreService {
    @WebMethod
    public OptionalWrapper<DataValidationCheckSettingsComplete> getStockLevelCheckSettings() throws ServiceException;

    @WebMethod
    public OptionalWrapper<DataValidationCheckSettingsComplete> updateStockLevelCheckSettings(DataValidationCheckSettingsComplete var1) throws ServiceException;

    @WebMethod
    public void generateStockLevelCheck() throws ServiceException;

    @WebMethod
    public OptionalWrapper<KonterProbenSettingsComplete> getKonterProbenSettings() throws ServiceException;

    @WebMethod
    public OptionalWrapper<KonterProbenSettingsComplete> updateKonterProbenSettings(KonterProbenSettingsComplete var1) throws ServiceException;

    @WebMethod
    public void generateKonterProbenManually() throws ServiceException;

    @WebMethod
    public OptionalWrapper<InternalConsumptionComplete> createInternalConsumption(InternalConsumptionComplete var1) throws ServiceException;

    @WebMethod
    public <S extends InternalConsumptionComplete> OptionalWrapper<S> updateInternalConsumption(S var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InternalConsumptionComplete> getInternalConsumption(InternalConsumptionLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreComplete> createStore(StoreComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StorePositionLight> getPositionForId(Long var1) throws ServiceException;

    @WebMethod
    public <S extends StoreLight> OptionalWrapper<S> updateStore(S var1) throws ServiceException;

    @WebMethod
    public ListWrapper<ManualStockMovementComplete> move(ManualStockMovementComplete var1, boolean var2, boolean var3) throws ServiceException;

    @WebMethod
    public void logInventoryException(InventoryReference var1, BasicArticleReference var2, StoreQuantityComplete var3, StorePositionLight var4) throws ServiceException;

    @WebMethod
    public void correct(IStockInventoryWrapper var1, boolean var2, boolean var3) throws ServiceException;

    @WebMethod
    public void countProducts(InventoryReference var1, ListWrapper<InventoryProductCountComplete> var2) throws ServiceException;

    @WebMethod
    public void countRecipes(InventoryReference var1, ListWrapper<InventoryRecipeCountComplete> var2) throws ServiceException;

    @WebMethod
    public ListWrapper<StorePositionLight> getFreeStorePositions(StoreReference var1) throws ServiceException;

    @WebMethod
    public void validateInventoryCount(PegasusFileComplete var1, StoreReference var2) throws ServiceException;

    @WebMethod
    public ListWrapper<StorePositionLight> getAllFreeStorePositions() throws ServiceException;

    @WebMethod
    public void checkin(ManualStockCheckinComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreComplete> getStoreByReference(StoreReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreLight> getStoreLightByReference(StoreReference var1) throws ServiceException;

    @WebMethod
    public StoreQuantityComplete getStockForArticle(BasicArticleReference var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public StoreQuantityComplete getStockForStore(BasicArticleReference var1, StoreReference var2, TimestampWrapper var3) throws ServiceException;

    @WebMethod
    public StoreQuantityComplete getMainStockInTargetUnitIfPossible(BasicArticleReference var1, UnitComplete var2) throws ServiceException;

    @WebMethod
    public StoreQuantityComplete getStockInTargetUnitIfPossible(BasicArticleReference var1, UnitComplete var2) throws ServiceException;

    @WebMethod
    public StoreQuantityComplete getStockOnPositionInTargetUnitIfPossible(BasicArticleReference var1, StorePositionLight var2, UnitComplete var3) throws ServiceException;

    @WebMethod
    public MapWrapper<StoreLight, StoreQuantityComplete> getStockPerStore(BasicArticleReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<ArticleChargeBatchComplete> getBatches(BasicArticleReference var1, StorePositionLight var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ArticleChargeComplete> getCharge(ArticleChargeReference var1) throws ServiceException;

    @WebMethod
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getStockPerStorePosition(BasicArticleReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ManualStockCheckoutComplete> checkout(ManualStockCheckoutComplete var1) throws ServiceException;

    @WebMethod
    public void resetInventory(StoreReference var1, UserReference var2, TimestampWrapper var3) throws ServiceException;

    @WebMethod
    public ListWrapper<ArticleChargeBatchComplete> getInventory(StoreReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<ArticleChargeBatchComplete> findBatchesCountedBefore(TimestampWrapper var1) throws ServiceException;

    @WebMethod
    public ListWrapper<StockTransactionComplete> getLatestStockTransactions(BasicArticleReference var1, int var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ArticleChargeComplete> updateCharge(ArticleChargeComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckoutGroupComplete> createStockCheckoutGroup(StockCheckoutGroupComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckoutGroupComplete> updateStockCheckoutGroup(StockCheckoutGroupComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckinGroupComplete> createStockCheckinGroup(StockCheckinGroupComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckinGroupComplete> updateStockCheckinGroup(StockCheckinGroupComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckinGroupComplete> getStockCheckinGroup(StockCheckinGroupReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockCheckoutGroupComplete> getStockCheckoutGroup(StockCheckoutGroupReference var1) throws ServiceException;

    @WebMethod
    public void PrintStockTransactions(StockTransactionSearchConfiguration var1) throws ServiceException;

    @WebMethod
    @Deprecated
    public void correctStock(BasicArticleReference var1, InventoryLight var2) throws ServiceException;

    @WebMethod
    public ListWrapper<BasicArticleReference> getInventoryArticles(InventoryLight var1) throws ServiceException;

    @WebMethod
    public MapWrapper<CustomerLight, Map<BasicArticleLight, AmountModificationComplete>> getStoreForecast(TimestampWrapper var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public MapWrapper<BasicArticleReference, StoreQuantityComplete> getStock(ListWrapper<BasicArticleReference> var1) throws ServiceException;

    @WebMethod
    public MapWrapper<BasicArticleReference, StoreQuantityComplete> getStockOnlyMainStore(ListWrapper<BasicArticleReference> var1) throws ServiceException;

    @WebMethod
    public SearchResult<StoreArticleContentComplete> getStoreArticleContent(BasicArticleSearchConfiguration var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StorePositionComplete> getStore(StorePositionLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockMovementGroupComplete> getStockMovementGroup(StockMovementGroupReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockMovementGroupComplete> createStockMovementGroup(StockMovementGroupComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StockMovementGroupComplete> updateStockMovementGroup(StockMovementGroupComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<PurchaseOrderAcceptationComplete> updateAcceptation(PurchaseOrderAcceptationComplete var1) throws ServiceException;

    @WebMethod
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getStockPerStorePositionAtTime(BasicArticleReference var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public MapWrapper<StorePositionLight, Date> getExpiryDatePerStorePositionAtTime(BasicArticleReference var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreLight> consumeAllArticles(StoreReference var1, String var2) throws ServiceException;

    @WebMethod
    public <T extends StoreLight> OptionalWrapper<T> deleteStore(T var1) throws ServiceException;

    @WebMethod
    public <T extends StoreLight> OptionalWrapper<T> restoreStore(T var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> createSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> updateSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> restoreSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> deleteSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InternalConsumptionComplete> generateInternalConsumption(PegasusFileComplete var1) throws ServiceException;

    @WebMethod
    public void generateInventoryDateCheck() throws ServiceException;

    @WebMethod
    public void generateChargeWithoutBatchesCheck() throws ServiceException;

    @WebMethod
    public void generateChargeWithOnlyIRBatchesCheck() throws ServiceException;

    @WebMethod
    public void moveAllArticles(StoreReference var1, StorePositionLight var2, String var3) throws ServiceException;
}

