/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.util;

import ch.icit.pegasus.server.core.dtos.util.DateTimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.timerService.TimerServiceType;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@DTO(target="ch.icit.pegasus.server.core.entities.util.TimeDuration")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TimeDurationComplete
extends DateTimeDurationComplete {
    private TimeUnitE unit;

    public TimeDurationComplete() {
        super(TimerServiceType.TIME_DURATION);
    }

    public TimeDurationComplete(TimeUnitE unit) {
        super(TimerServiceType.TIME_DURATION);
        this.unit = unit;
    }

    public TimeDurationComplete(TimeUnitE unit, Double duration) {
        super(TimerServiceType.TIME_DURATION, duration);
        this.unit = unit;
    }

    public long getDurationInMillis() {
        switch (this.unit) {
            case HOUR: {
                return (long)(this.getDuration() * 3600000.0);
            }
            case MINUTE: {
                return (long)(this.getDuration() * 60000.0);
            }
            case SECOND: {
                return (long)(this.getDuration() * 1000.0);
            }
            case MILLISECOND: {
                return this.getDuration().longValue();
            }
        }
        return 0L;
    }

    public TimeUnitE getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnitE unit) {
        this.unit = unit;
    }
}

