/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.ArticleCategory")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class ArticleCategoryComplete
extends ArticleCategoryLight {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(ArticleCategoryComplete.class);
    private List<ArticleCategoryComplete> subCategories = new ArrayList<ArticleCategoryComplete>();

    public List<ArticleCategoryComplete> getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(List<ArticleCategoryComplete> subCategories) {
        this.subCategories = subCategories;
    }

    @Override
    public void beforeMarshal(Marshaller m) {
        try {
            super.beforeMarshal(m);
            this.subCategories.forEach(productCategoryComplete -> productCategoryComplete.beforeMarshal(m));
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        try {
            XmlCache.getXmlCache().put(this.getId(), this);
            super.afterUnmarshal(u, parent);
            for (ArticleCategoryComplete subCategory : this.subCategories) {
                subCategory.afterUnmarshal(u, parent);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }
}

