/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.recipe;

import ch.icit.pegasus.server.dtos.annotations.DTO;

@DTO(target="ch.icit.pegasus.server.core.entities.recipe.AllergenDeclarationState")
public enum AllergenDeclarationStateE {
    NEW_NOT_RELEASED(10, false, "10: New Not Released"),
    PROCESSING(20, false, "20: Processing"),
    WAITING_FOR_SUPPLIER(23, false, "23: Waiting for Supplier"),
    SPECIFICATION_PARKED(25, false, "25: Specification parked"),
    WAITING_FOR_QUALITY_GATE_1(30, false, "30: Waiting for Quality Gate 1"),
    QUALITY_GATE_1_APPROVED(40, false, "40: Quality Gate 1 Approved"),
    SPECIFICATION_APPROVED(50, true, "50: Specification approved"),
    ACTIVE_NON_FOOD(55, true, "55: Active non food"),
    SPECIFICATION_BLOCKED(60, false, "60: Specification blocked"),
    MANUALLY_APPROVED(666, true, "666: Manually approved");

    private Integer type;
    private Boolean approved = false;
    private String nameing;

    private AllergenDeclarationStateE(Integer type, Boolean approved, String naming) {
        this.type = type;
        this.approved = approved;
        this.nameing = naming;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public static AllergenDeclarationStateE getType(String nameing) {
        for (AllergenDeclarationStateE e : AllergenDeclarationStateE.values()) {
            if (!e.getNameing().equals(nameing)) continue;
            return e;
        }
        if (nameing.equals("xx: Changed not released")) {
            return NEW_NOT_RELEASED;
        }
        return null;
    }

    public static AllergenDeclarationStateE getType(Integer type) {
        for (AllergenDeclarationStateE e : AllergenDeclarationStateE.values()) {
            if (e.getType() != type) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case ACTIVE_NON_FOOD: {
                return "Active non food";
            }
            case NEW_NOT_RELEASED: {
                return "new not realeased";
            }
            case PROCESSING: {
                return "Processing";
            }
            case QUALITY_GATE_1_APPROVED: {
                return "Quality Gate 1 approved";
            }
            case SPECIFICATION_APPROVED: {
                return "Specification approved";
            }
            case SPECIFICATION_BLOCKED: {
                return "Specification blocked";
            }
            case SPECIFICATION_PARKED: {
                return "Specification parked";
            }
            case WAITING_FOR_QUALITY_GATE_1: {
                return "Waiting for Quality Gate 1";
            }
            case WAITING_FOR_SUPPLIER: {
                return "Waiting for Supplier";
            }
            case MANUALLY_APPROVED: {
                return "Manually approved";
            }
        }
        return "";
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public String getNameing() {
        return this.nameing;
    }

    public void setNameing(String nameing) {
        this.nameing = nameing;
    }
}

