/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.supply.Price")
public class PriceComplete
extends AEmbeddedDTO
implements Comparable<PriceComplete> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CurrencyComplete currency;
    @XmlAttribute
    private Double price;

    public PriceComplete() {
        this(null, 0.0);
    }

    public PriceComplete(CurrencyComplete currency, Double price) {
        this.currency = currency;
        this.price = price;
    }

    public PriceComplete(PriceComplete template) {
        this(template.getCurrency(), template.getPrice() != null ? template.getPrice() : 0.0);
    }

    @Override
    public String toString() {
        return this.getFormattedPrice() + "" + this.currency;
    }

    public CurrencyComplete getCurrency() {
        return this.currency;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setCurrency(CurrencyComplete currency) {
        this.currency = currency;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getFormattedPrice() {
        if (this.price == null) {
            return "0.000";
        }
        DecimalFormat format = new DecimalFormat("###################0.000");
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format.format(this.price);
    }

    @Override
    public int compareTo(PriceComplete o) {
        double theirPrice;
        double thisPrice = this.getCurrency().getCurrentVariant().getExchangeRate() * this.price;
        if (thisPrice < (theirPrice = o.getCurrency().getCurrentVariant().getExchangeRate() * o.getPrice())) {
            return -1;
        }
        if (thisPrice == theirPrice) {
            return 0;
        }
        return 1;
    }
}

