/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.search;

import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.general.SearchImplType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SupplierSearchConfiguration
extends ADtoSearchConfiguration<SupplierLight, SUPPLIER_COLUMN> {
    @XmlAttribute
    private Integer number;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String country;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ArticleCategoryReference articleCategory;
    @XmlAttribute
    private String invoiceReferenceNumber;
    @XmlAttribute
    private Boolean knownSupplier;

    public void setKnownSupplier(Boolean knownSupplier) {
        this.knownSupplier = knownSupplier;
    }

    public Boolean getKnownSupplier() {
        return this.knownSupplier;
    }

    public SearchImplType getIdentifier() {
        return SearchImplType.SUPPLIER;
    }

    public String getInvoiceReferenceNumber() {
        return this.invoiceReferenceNumber;
    }

    public void setInvoiceReferenceNumber(String invoiceReferenceNumber) {
        this.invoiceReferenceNumber = this.limitString(invoiceReferenceNumber);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = this.limitString(country);
    }

    public ArticleCategoryReference getArticleCategory() {
        return this.articleCategory;
    }

    public void setArticleCategory(ArticleCategoryReference articleCategory) {
        this.articleCategory = articleCategory;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.limitString(name);
    }

    public SUPPLIER_COLUMN getDefaultSortColumn() {
        return SUPPLIER_COLUMN.NAME;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        ArrayList<Tuple<String, String>> ret = new ArrayList<Tuple<String, String>>();
        ret.add(new Tuple((Object)Words.NUMBER, (Object)(this.number != null ? this.number.toString() : "")));
        ret.add(new Tuple((Object)Words.NAME, (Object)this.name));
        ret.add(new Tuple((Object)Words.COUNTRY, (Object)this.country));
        ret.add(new Tuple((Object)Words.KNOWN_SUPPLIER, (Object)(Boolean.TRUE.equals(this.knownSupplier) ? Words.YES : Words.NO_ANSWER)));
        ret.add(new Tuple((Object)Words.INVOICE_REFERENCE_NO, (Object)this.invoiceReferenceNumber));
        return ret;
    }

    public static enum SUPPLIER_COLUMN {
        NUMBER,
        NAME,
        COUNTRY,
        KNOWN_SUPPLIER;

    }
}

