/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.search;

import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimePeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.SearchImplType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlightScheduleSearchConfiguration
extends ADtoSearchConfiguration<FlightScheduleLight, FLIGHT_SCHEDULE_COLUMN> {
    @XmlAttribute
    private String flightNumber;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;
    private TimePeriodComplete departure;
    private PeriodComplete flightPeriod;
    private FlightTypeE flightType;
    private ModificationStateE state;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HandlingCostComplete handling;
    @XmlAttribute
    private Boolean autoCheckout;
    private HaulTypeComplete haulType;
    private FlightCategoryComplete category;
    @XmlAttribute
    private Integer number;
    private StowingListConfigurationComplete defaultStowingList;
    private AirportComplete deliveryAirport;
    private List<HaulTypeComplete> haulTypeList = new ArrayList<HaulTypeComplete>();
    @XmlAttribute
    private Boolean showNullHaulTypes = Boolean.FALSE;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private StowingListTemplateReference stowingList;

    public AirportComplete getDeliveryAirport() {
        return this.deliveryAirport;
    }

    public void setDeliveryAirport(AirportComplete deliveryAirport) {
        this.deliveryAirport = deliveryAirport;
    }

    public void setStowingList(StowingListTemplateReference stowingList) {
        this.stowingList = stowingList;
    }

    public StowingListTemplateReference getStowingList() {
        return this.stowingList;
    }

    public SearchImplType getIdentifier() {
        return SearchImplType.FLIGHT_SCHEDULE;
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String flightNumber) {
        this.flightNumber = this.limitString(flightNumber);
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public TimePeriodComplete getDeparture() {
        return this.departure;
    }

    public void setDeparture(TimePeriodComplete departure) {
        this.departure = departure;
    }

    public PeriodComplete getFlightPeriod() {
        return this.flightPeriod;
    }

    public void setFlightPeriod(PeriodComplete flightPeriod) {
        this.flightPeriod = flightPeriod;
    }

    public FlightTypeE getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightTypeE flightType) {
        this.flightType = flightType;
    }

    public FLIGHT_SCHEDULE_COLUMN getDefaultSortColumn() {
        return FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE;
    }

    public void setHandling(HandlingCostComplete handling) {
        this.handling = handling;
    }

    public HandlingCostComplete getHandling() {
        return this.handling;
    }

    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public HaulTypeComplete getHaulType() {
        return this.haulType;
    }

    public void setHaulType(HaulTypeComplete haulType) {
        this.haulType = haulType;
    }

    public FlightCategoryComplete getCategory() {
        return this.category;
    }

    public void setCategory(FlightCategoryComplete category) {
        this.category = category;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public StowingListConfigurationComplete getDefaultStowingList() {
        return this.defaultStowingList;
    }

    public void setDefaultStowingList(StowingListConfigurationComplete defaultStowingList) {
        this.defaultStowingList = defaultStowingList;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        ArrayList<Tuple<String, String>> configs = new ArrayList<Tuple<String, String>>();
        configs.add(new Tuple((Object)Words.FLIGHT_NUMBER, (Object)this.getFlightNumber()));
        configs.add(new Tuple((Object)Words.CUSTOMER, (Object)(this.getCustomer() != null ? this.getCustomer().getCode() : "")));
        configs.add(new Tuple((Object)Words.DEPARTURE, (Object)(this.getDeparture() != null ? (this.getDeparture().getStartTime() != null ? this.getDeparture().getStartTime().toString() : "") : "")));
        configs.add(new Tuple((Object)Words.AUTO_CHECKOUT, (Object)(Boolean.TRUE.equals(this.getAutoCheckout()) ? Words.YES : (this.getAutoCheckout() == null ? Words.ALL : Words.NO_ANSWER))));
        configs.add(new Tuple((Object)Words.CATEGORY, (Object)(this.getCategory() != null ? this.getCategory().getCode() : "")));
        return configs;
    }

    public List<HaulTypeComplete> getHaulTypeList() {
        return this.haulTypeList;
    }

    public void setHaulTypeList(List<HaulTypeComplete> haulTypeList) {
        this.haulTypeList = haulTypeList;
    }

    public Boolean getShowNullHaulTypes() {
        return this.showNullHaulTypes;
    }

    public void setShowNullHaulTypes(Boolean showNullHaulTypes) {
        this.showNullHaulTypes = showNullHaulTypes;
    }

    public static enum FLIGHT_SCHEDULE_COLUMN {
        AIRLINE,
        OUTBOUND_CODE,
        STD,
        STA,
        INBOUND_CODE,
        STOWING_LIST,
        PERIOD,
        STATE,
        OPDAYS,
        NUMBER;

    }
}

