/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import java.sql.Timestamp;

public class PriceToolkit {
    public static PriceComplete addPrices(PriceComplete p1, PriceComplete p2, Timestamp validityDate, CurrencyVariantAccessor accessor) throws Exception {
        return PriceToolkit.addPrices(p1, p2, null, validityDate, accessor);
    }

    public static PriceComplete subtractPrices(PriceComplete p1, PriceComplete p2, Timestamp validityDate, CurrencyVariantAccessor accessor) throws Exception {
        return PriceToolkit.addPrices(p1, p2 == null ? null : new PriceComplete(p2.getCurrency(), Double.valueOf(-p2.getPrice().doubleValue())), null, validityDate, accessor);
    }

    public static PriceComplete addPrices(PriceComplete p1, PriceComplete p2, CurrencyComplete targetCurrency, Timestamp validityDate, CurrencyVariantAccessor accessor) throws Exception {
        boolean p2invalid;
        boolean p1invalid = p1 == null || p1.getCurrency() == null || p1.getPrice() == null;
        boolean bl = p2invalid = p2 == null || p2.getCurrency() == null || p2.getPrice() == null;
        if (p1invalid) {
            return p2invalid ? null : new PriceComplete(p2);
        }
        if (p2invalid) {
            return p1invalid ? null : new PriceComplete(p1);
        }
        CurrencyComplete currency = targetCurrency != null ? targetCurrency : p1.getCurrency();
        double value = PriceToolkit.getPriceIn(currency, p1, accessor, validityDate);
        PriceComplete ret = new PriceComplete(currency, Double.valueOf(value += PriceToolkit.getPriceIn(currency, p2, accessor, validityDate)));
        return ret;
    }

    public static double getPriceIn(CurrencyComplete targetCurrency, PriceComplete sourcePrice, CurrencyVariantAccessor accessor, Timestamp validityDate) throws Exception {
        CurrencyVariantComplete cvTarget = (CurrencyVariantComplete)accessor.loadData(targetCurrency, validityDate);
        CurrencyVariantComplete cvSource = (CurrencyVariantComplete)accessor.loadData(sourcePrice.getCurrency(), validityDate);
        double f1 = cvTarget.getExchangeRate();
        double f2 = cvSource.getExchangeRate();
        return sourcePrice.getPrice() * f2 / f1;
    }
}

