/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import java.sql.Date;
import java.sql.Timestamp;

public class ProductStateToolkit {
    public static void updateProductState(ProductVariantComplete p, ModificationStateE newState, ModificationStateE oldState, Timestamp validityDate, RecipeVariantAccessor accessor) throws Exception {
        block15: {
            block16: {
                block13: {
                    block14: {
                        if (newState != ModificationStateE.DRAFT || oldState != ModificationStateE.ACCEPTED) break block13;
                        if (!(p instanceof SimpleProductVariantComplete)) break block14;
                        SimpleProductVariantComplete sp = (SimpleProductVariantComplete)p;
                        SimpleComponentComplete simpleComponentComplete = sp.getComponent();
                        break block15;
                    }
                    if (!(p instanceof ComplexProductVariantComplete)) break block15;
                    ComplexProductVariantComplete cpc = (ComplexProductVariantComplete)p;
                    for (SimpleProductComponentGroupComplete s : cpc.getProductComponentGroups()) {
                        for (ProductComponentComplete pcc : s.getComponents()) {
                            SimpleComponentComplete simpleComponentComplete;
                            if (pcc instanceof SimpleComponentComplete) {
                                simpleComponentComplete = (SimpleComponentComplete)pcc;
                                continue;
                            }
                            if (!(pcc instanceof CompoundComponentComplete)) continue;
                            simpleComponentComplete = (CompoundComponentComplete)pcc;
                        }
                    }
                    break block15;
                }
                if (newState != ModificationStateE.ACCEPTED || oldState != ModificationStateE.DRAFT) break block16;
                if (p instanceof SimpleProductVariantComplete) {
                    SimpleProductVariantComplete sp = (SimpleProductVariantComplete)p;
                    SimpleComponentComplete simpleComponentComplete = sp.getComponent();
                } else {
                    ComplexProductVariantComplete cp = (ComplexProductVariantComplete)p;
                    for (SimpleProductComponentGroupComplete sc : cp.getProductComponentGroups()) {
                        for (ProductComponentComplete innerComps : sc.getComponents()) {
                            ProductStateToolkit.updateInnerComponets(innerComps, (CustomerReference)p.getProduct().getCustomer(), validityDate, accessor, cp.getTenderVariant());
                        }
                    }
                }
                if (newState != ModificationStateE.ACCEPTED || p.getFixedPrice().booleanValue()) break block15;
                p.setFixedPrice(Boolean.valueOf(true));
                p.setSalesPrice(p.getSalesPrice());
                break block15;
            }
            if (oldState == ModificationStateE.DRAFT) {
                if (p instanceof SimpleProductVariantComplete) {
                    SimpleProductVariantComplete sp = (SimpleProductVariantComplete)p;
                    SimpleComponentComplete simpleComponentComplete = sp.getComponent();
                } else if (p instanceof ComplexProductVariantComplete) {
                    ComplexProductVariantComplete cpc = (ComplexProductVariantComplete)p;
                    for (SimpleProductComponentGroupComplete s : cpc.getProductComponentGroups()) {
                        for (ProductComponentComplete productComponentComplete : s.getComponents()) {
                        }
                    }
                }
            }
        }
    }

    private static void updateInnerComponets(ProductComponentComplete innerComps, CustomerReference customer, Timestamp validity, RecipeVariantAccessor accessor, boolean useTender) throws Exception {
        if (innerComps instanceof SimpleComponentComplete) {
            SimpleComponentComplete scc = (SimpleComponentComplete)innerComps;
            BasicArticleComplete art = scc.getArticle();
            PriceComplete priceComplete = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)art, validity, customer, useTender);
        } else if (innerComps instanceof CompoundComponentComplete) {
            RecipeVariantComplete recipeVariantComplete = (RecipeVariantComplete)accessor.loadData(((CompoundComponentComplete)innerComps).getRecipe(), validity);
        }
        ProductStateToolkit.calculateBruttoQuantity(innerComps, customer, useTender, new Date(validity.getTime()));
    }

    private static void calculateBruttoQuantity(ProductComponentComplete component, CustomerReference customer, boolean tender, Date validity) {
        if (component instanceof SimpleComponentComplete) {
            SimpleComponentComplete c = (SimpleComponentComplete)component;
            if (c.getAutoCalculateBrutto().booleanValue() && c.getNettoQuantity() instanceof LinearQuantityInterpolationComplete) {
                double cookingWaste = ArticlePriceCalculationToolkit.getCookingWaste(c.getArticle(), customer, tender);
                LinearQuantityInterpolationComplete bl = new LinearQuantityInterpolationComplete();
                bl.setClientOId(Long.valueOf(ADTO.getNextId()));
                double nb = ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getQuantity() / ((100.0 - cookingWaste) / 100.0);
                bl.setResultingQuantity(new QuantityComplete(Double.valueOf(nb), ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getUnit()));
            }
        } else {
            CompoundComponentComplete c = (CompoundComponentComplete)component;
            if (c.getNettoQuantity() instanceof LinearQuantityInterpolationComplete) {
                double cookingWaste = 0.0;
                cookingWaste = tender ? ArticlePriceCalculationToolkit.getRecipeGroupTenderCookingWaste(c.getRecipe().getCurrentVariant(), validity) : ArticlePriceCalculationToolkit.getRecipeGroupProductiveCookingWaste(c.getRecipe().getCurrentVariant(), validity);
                LinearQuantityInterpolationComplete bl = new LinearQuantityInterpolationComplete();
                bl.setClientOId(Long.valueOf(ADTO.getNextId()));
                double nb = ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getQuantity() / ((100.0 - cookingWaste) / 100.0);
                bl.setResultingQuantity(new QuantityComplete(Double.valueOf(nb), ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getUnit()));
            }
        }
    }
}

