/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete;
import ch.icit.pegasus.server.core.dtos.recipe.IRecipe;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.DTOUtilException;
import ch.icit.pegasus.server.core.dtos.utils.PriceQuantityCombination;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.BasicArticleAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedBasicArticleIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipe;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipeIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.RecipeCalculationToolkit;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ProductRecipeAmountCalculationToolkit {
    public static QuantityComplete resolveSteps(Stack<ProductComponentComplete> toplevel, ProductComponentComplete comp) throws DTOUtilException {
        QuantityComplete currentQuant = null;
        ProductComponentComplete current = null;
        while (!toplevel.isEmpty()) {
            ProductComponentComplete c = toplevel.pop();
            if (current == null) {
                current = c;
                LinearQuantityInterpolationComplete quant = (LinearQuantityInterpolationComplete)c.getQuantity();
                currentQuant = quant.getResultingQuantity();
                continue;
            }
            StepQuantityInterpolationComplete stepQuant = (StepQuantityInterpolationComplete)c.getQuantity();
            currentQuant = RecipeCalculationToolkit.resolveStep(stepQuant.getSteps(), currentQuant);
            current = c;
        }
        StepQuantityInterpolationComplete stepQuant = (StepQuantityInterpolationComplete)comp.getQuantity();
        currentQuant = RecipeCalculationToolkit.resolveStep(stepQuant.getSteps(), currentQuant);
        return currentQuant;
    }

    public static HashMap<BasicArticleComplete, PriceQuantityCombination> getAmount4SimpleProductComponentGroup(SimpleProductComponentGroupComplete group, double count, ModificationStateE state, Timestamp validityDate, RecipeVariantAccessor accessor, CurrencyVariantAccessor currencyAccessor, CustomerReference customer, boolean useTender) throws Exception {
        HashMap<BasicArticleComplete, PriceQuantityCombination> map = new HashMap<BasicArticleComplete, PriceQuantityCombination>();
        for (ProductComponentComplete pc : group.getComponents()) {
            if (pc instanceof SimpleComponentComplete) {
                QuantityComplete q;
                if (((SimpleComponentComplete)pc).getArticle() == null || (q = ProductRecipeAmountCalculationToolkit.calculateArticle(((SimpleComponentComplete)pc).getArticle(), pc.getQuantity(), null, null, (SimpleComponentComplete)pc, validityDate)) == null) continue;
                PriceQuantityCombination qq = new PriceQuantityCombination();
                q.setQuantity(Double.valueOf(q.getQuantity() * count));
                qq.setQuantity(q);
                if (state != null) {
                    qq.setPrice(ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)((SimpleComponentComplete)pc).getArticle(), validityDate, customer, useTender));
                }
                ProductRecipeAmountCalculationToolkit.mergeArticlePriceQuantityMap(map, ((SimpleComponentComplete)pc).getArticle(), qq, validityDate);
                continue;
            }
            if (!(pc instanceof CompoundComponentComplete) || ((CompoundComponentComplete)pc).getUnderlyingRecipe() == null) continue;
            ProductRecipeAmountCalculationToolkit.calculateRecipe(map, (CompoundComponentComplete)pc, count, null, null, state, false, validityDate, accessor, currencyAccessor, customer, useTender);
        }
        return map;
    }

    public static Map<RecipeVariantLight, QuantityComplete> getRecipeAmount4Product(ProductVariantComplete product, int count, ModificationStateE state, Timestamp validityDate, RecipeVariantAccessor accessor) throws Exception {
        HashMap<RecipeVariantLight, QuantityComplete> map = new HashMap<RecipeVariantLight, QuantityComplete>();
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete p = (ComplexProductVariantComplete)product;
            if (p.getProductComponentGroups() == null) {
                return map;
            }
            for (SimpleProductComponentGroupComplete spc : p.getProductComponentGroups()) {
                for (ProductComponentComplete pc : spc.getComponents()) {
                    if (!(pc instanceof CompoundComponentComplete) || ((CompoundComponentComplete)pc).getUnderlyingRecipe() == null) continue;
                    RecipeVariantComplete rl = (RecipeVariantComplete)accessor.loadData(((CompoundComponentComplete)pc).getUnderlyingRecipe(), validityDate);
                    QuantityComplete q = map.get(rl);
                    if (q == null) {
                        q = new QuantityComplete(Double.valueOf(0.0), rl.getYield().getUnit());
                        map.put((RecipeVariantLight)rl, q);
                    }
                    if (!(pc.getQuantity() instanceof LinearQuantityInterpolationComplete)) continue;
                    LinearQuantityInterpolationComplete lq = (LinearQuantityInterpolationComplete)pc.getQuantity();
                    double d = UnitConversionToolkit.convertUnit(lq.getResultingQuantity().getUnit(), q.getUnit(), (double)lq.getResultingQuantity().getQuantity(), null, validityDate);
                    q.setQuantity(Double.valueOf(q.getQuantity() + d * (double)count));
                }
            }
        }
        return map;
    }

    public static Map<RecipeVariantLight, Map<BasicArticleComplete, QuantityComplete>> getArticleAmount4ProductPerRecipe(ProductVariantComplete product, int count, ModificationStateE state, Timestamp validityDate, RecipeVariantAccessor accessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        HashMap<RecipeVariantLight, Map<BasicArticleComplete, QuantityComplete>> map = new HashMap<RecipeVariantLight, Map<BasicArticleComplete, QuantityComplete>>();
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete p = (ComplexProductVariantComplete)product;
            if (p.getProductComponentGroups() == null) {
                return map;
            }
            for (SimpleProductComponentGroupComplete spc : p.getProductComponentGroups()) {
                for (ProductComponentComplete pc : spc.getComponents()) {
                    if (!(pc instanceof CompoundComponentComplete) || ((CompoundComponentComplete)pc).getUnderlyingRecipe() == null) continue;
                    RecipeComplete rl = ((CompoundComponentComplete)pc).getUnderlyingRecipe();
                    RecipeVariantComplete variant = null;
                    try {
                        variant = (RecipeVariantComplete)accessor.loadData(rl, validityDate);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("No valid variant found for Recipe " + rl.getNumber() + " @ " + validityDate);
                    }
                    Map<BasicArticleComplete, QuantityComplete> artMap = map.get(variant);
                    if (artMap == null) {
                        artMap = new HashMap<BasicArticleComplete, QuantityComplete>();
                        map.put((RecipeVariantLight)variant, artMap);
                    }
                    if (!(pc.getQuantity() instanceof LinearQuantityInterpolationComplete)) continue;
                    LinearQuantityInterpolationComplete lq = (LinearQuantityInterpolationComplete)pc.getQuantity();
                    HashMap<BasicArticleComplete, PriceQuantityCombination> nmap = new HashMap<BasicArticleComplete, PriceQuantityCombination>();
                    try {
                        ProductRecipeAmountCalculationToolkit.calculateRecipe(nmap, (CompoundComponentComplete)pc, count, variant.getYield(), lq.getResultingQuantity(), state, false, validityDate, accessor, currencyAccessor, (CustomerReference)product.getProduct().getCustomer(), product.getTenderVariant());
                        for (Map.Entry e : nmap.entrySet()) {
                            QuantityComplete q = artMap.get(e.getKey());
                            if (q == null) {
                                q = new QuantityComplete(Double.valueOf(0.0), ((BasicArticleComplete)e.getKey()).getPriceUnit());
                                artMap.put((BasicArticleComplete)e.getKey(), q);
                            }
                            double d = UnitConversionToolkit.convertUnit(((PriceQuantityCombination)e.getValue()).getQuantity().getUnit(), ((BasicArticleComplete)e.getKey()).getPriceUnit(), (double)((PriceQuantityCombination)e.getValue()).getQuantity().getQuantity(), (BasicArticleLight)e.getKey(), validityDate);
                            q.setQuantity(Double.valueOf(q.getQuantity() + d));
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("No valid variant found for Recipe " + rl.getNumber() + " @ " + validityDate);
                    }
                }
            }
        }
        return map;
    }

    public static Map<BasicArticleComplete, PriceQuantityCombination> getAmount4Product(ProductVariantComplete product, double count, ModificationStateE state, Timestamp validityDate, RecipeVariantAccessor accessor, CurrencyVariantAccessor currencyAccessor) throws Exception {
        return ProductRecipeAmountCalculationToolkit.getAmount4Product(product, count, state, validityDate, accessor, false, currencyAccessor);
    }

    public static Map<BasicArticleComplete, PriceQuantityCombination> getAmount4Product(ProductVariantComplete product, double count, ModificationStateE state, Timestamp validityDate, RecipeVariantAccessor accessor, boolean ignoreRecipe, CurrencyVariantAccessor currencyAccessor) throws Exception {
        HashMap<BasicArticleComplete, PriceQuantityCombination> map = new HashMap<BasicArticleComplete, PriceQuantityCombination>();
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete p = (ComplexProductVariantComplete)product;
            if (p.getProductComponentGroups() == null) {
                return map;
            }
            for (SimpleProductComponentGroupComplete spc : p.getProductComponentGroups()) {
                for (ProductComponentComplete pc : spc.getComponents()) {
                    if (pc instanceof SimpleComponentComplete) {
                        QuantityComplete q;
                        if (((SimpleComponentComplete)pc).getArticle() == null) continue;
                        SimpleComponentComplete c = (SimpleComponentComplete)pc;
                        QuantityInterpolationComplete gross = pc.getNettoQuantity();
                        if (c.getAutoCalculateBrutto().booleanValue()) {
                            if (c.getNettoQuantity() instanceof LinearQuantityInterpolationComplete) {
                                double cookingWaste = ArticlePriceCalculationToolkit.getCookingWaste(c.getArticle(), (CustomerReference)product.getProduct().getCustomer(), product.getTenderVariant());
                                LinearQuantityInterpolationComplete bl = new LinearQuantityInterpolationComplete();
                                bl.setClientOId(Long.valueOf(ADTO.getNextId()));
                                double nb = ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getQuantity() / ((100.0 - cookingWaste) / 100.0);
                                bl.setResultingQuantity(new QuantityComplete(Double.valueOf(nb), ((LinearQuantityInterpolationComplete)c.getNettoQuantity()).getResultingQuantity().getUnit()));
                                gross = bl;
                                c.setQuantity(gross);
                            }
                        } else {
                            gross = c.getQuantity();
                        }
                        if ((q = ProductRecipeAmountCalculationToolkit.calculateArticle(((SimpleComponentComplete)pc).getArticle(), gross, null, null, (SimpleComponentComplete)pc, validityDate)) == null) continue;
                        PriceQuantityCombination qq = new PriceQuantityCombination();
                        q.setQuantity(Double.valueOf(q.getQuantity() * count));
                        qq.setQuantity(q);
                        if (Boolean.TRUE.equals(((SimpleComponentComplete)pc).getArticle().getCustomerIsOwner()) || Boolean.TRUE.equals(((SimpleComponentComplete)pc).getArticle().getExcludeFromMaterialCostCalculations())) {
                            PriceComplete net = ArticlePriceCalculationToolkit.getNettoPrice((BasicArticleLight)((SimpleComponentComplete)pc).getArticle(), validityDate, (CustomerReference)product.getProduct().getCustomer(), (boolean)product.getTenderVariant());
                            qq.setPrice(new PriceComplete(net.getCurrency(), Double.valueOf(0.0)));
                        } else {
                            qq.setPrice(ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)((SimpleComponentComplete)pc).getArticle(), validityDate, (CustomerReference)product.getProduct().getCustomer(), (boolean)product.getTenderVariant()));
                        }
                        ProductRecipeAmountCalculationToolkit.mergeArticlePriceQuantityMap(map, ((SimpleComponentComplete)pc).getArticle(), qq, validityDate);
                        continue;
                    }
                    if (!(pc instanceof CompoundComponentComplete) || ignoreRecipe) continue;
                    CompoundComponentComplete cc = (CompoundComponentComplete)pc;
                    if (((CompoundComponentComplete)pc).getUnderlyingRecipe() == null) continue;
                    ProductRecipeAmountCalculationToolkit.calculateRecipe(map, (CompoundComponentComplete)pc, count, null, null, state, false, validityDate, accessor, currencyAccessor, (CustomerReference)product.getProduct().getCustomer(), product.getTenderVariant());
                }
            }
        } else if (product instanceof SimpleProductVariantComplete) {
            SimpleProductVariantComplete p = (SimpleProductVariantComplete)product;
            PriceQuantityCombination pqc = new PriceQuantityCombination();
            if (p != null && p.getComponent() != null && p.getComponent().getArticle() != null) {
                if (p.getComponent().getArticle().getCustomerIsOwner().booleanValue() || p.getComponent().getArticle().getExcludeFromMaterialCostCalculations().booleanValue()) {
                    PriceComplete netto = ArticlePriceCalculationToolkit.getNettoPrice((BasicArticleLight)p.getComponent().getArticle(), validityDate, (CustomerReference)product.getProduct().getCustomer(), (boolean)product.getTenderVariant());
                    pqc.setPrice(new PriceComplete(netto.getCurrency(), Double.valueOf(0.0)));
                } else {
                    pqc.setPrice(ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)p.getComponent().getArticle(), validityDate, (CustomerReference)product.getProduct().getCustomer(), (boolean)product.getTenderVariant()));
                }
                LinearQuantityInterpolationComplete qq = (LinearQuantityInterpolationComplete)p.getComponent().getQuantity();
                QuantityComplete q = ProductRecipeAmountCalculationToolkit.calculateArticle(p.getComponent().getArticle(), (QuantityInterpolationComplete)qq, null, null, p.getComponent(), validityDate);
                q.setQuantity(Double.valueOf(q.getQuantity() * count));
                pqc.setQuantity(q);
                map.put(p.getComponent().getArticle(), pqc);
            }
        } else {
            throw new RuntimeException("Invalid Product type: " + product.getClass().getSimpleName() + "!");
        }
        return map;
    }

    public static void mergeArticlePriceQuantityMap(Map<BasicArticleComplete, PriceQuantityCombination> map, BasicArticleComplete article, PriceQuantityCombination q, Timestamp validity) {
        PriceQuantityCombination savedOne = map.get(article);
        if (savedOne == null) {
            map.put(article, q);
        } else {
            double d = UnitConversionToolkit.convertUnit(q.getQuantity().getUnit(), savedOne.getQuantity().getUnit(), (double)q.getQuantity().getQuantity(), (BasicArticleLight)article, validity);
            savedOne.getQuantity().setQuantity(Double.valueOf(savedOne.getQuantity().getQuantity() + d));
        }
    }

    public static Map<RecipeVariantLight, Map<BasicArticleComplete, List<PriceQuantityCombination>>> mergeRecipeArticleQuantityMaps(Map<RecipeVariantLight, Map<BasicArticleComplete, List<PriceQuantityCombination>>> map1, Map<RecipeVariantLight, Map<BasicArticleComplete, List<PriceQuantityCombination>>> map2) {
        for (Map.Entry<RecipeVariantLight, Map<BasicArticleComplete, List<PriceQuantityCombination>>> r : map1.entrySet()) {
            Map<BasicArticleComplete, List<PriceQuantityCombination>> rl = map2.get(r.getKey());
            if (rl == null) {
                rl = new HashMap<BasicArticleComplete, List<PriceQuantityCombination>>();
                map2.put(r.getKey(), rl);
            }
            ProductRecipeAmountCalculationToolkit.mergeArticlePriceQuantityMaps(r.getValue(), rl);
        }
        return map2;
    }

    public static Map<BasicArticleComplete, List<PriceQuantityCombination>> mergeArticlePriceQuantityMaps(Map<BasicArticleComplete, List<PriceQuantityCombination>> map, Map<BasicArticleComplete, List<PriceQuantityCombination>> map2) {
        for (Map.Entry<BasicArticleComplete, List<PriceQuantityCombination>> a : map.entrySet()) {
            List<PriceQuantityCombination> savedOne = map2.get(a.getKey());
            if (savedOne == null) {
                savedOne = new ArrayList<PriceQuantityCombination>();
                map2.put(a.getKey(), savedOne);
            }
            savedOne.addAll((Collection<PriceQuantityCombination>)a.getValue());
        }
        return map2;
    }

    public static void mergeArticleQuantityMap(Map<BasicArticleComplete, QuantityComplete> map, BasicArticleComplete article, QuantityComplete q, Timestamp validity) {
        QuantityComplete savedOne = map.get(article);
        if (savedOne == null) {
            map.put(article, q);
        } else {
            double d = UnitConversionToolkit.convertUnit(q.getUnit(), savedOne.getUnit(), (double)q.getQuantity(), (BasicArticleLight)article, validity);
            savedOne.setQuantity(Double.valueOf(savedOne.getQuantity() + d));
        }
    }

    public static Map<BasicArticleComplete, QuantityComplete> mergeArticleQuantityMaps(Map<BasicArticleComplete, QuantityComplete> map, Map<BasicArticleComplete, QuantityComplete> map2, Timestamp validity) {
        for (Map.Entry<BasicArticleComplete, QuantityComplete> a : map.entrySet()) {
            QuantityComplete savedOne = map2.get(a.getKey());
            if (savedOne == null) {
                savedOne = new QuantityComplete(Double.valueOf(0.0), a.getKey().getPriceUnit());
                map2.put(a.getKey(), savedOne);
            }
            double d = UnitConversionToolkit.convertUnit(a.getValue().getUnit(), savedOne.getUnit(), (double)a.getValue().getQuantity(), (BasicArticleLight)a.getKey(), validity);
            savedOne.setQuantity(Double.valueOf(savedOne.getQuantity() + d));
        }
        return map2;
    }

    public static Map<RecipeVariantLight, QuantityComplete> mergeRecipeQuantityMaps(Map<RecipeVariantLight, QuantityComplete> map, Map<RecipeVariantLight, QuantityComplete> map2) {
        for (Map.Entry<RecipeVariantLight, QuantityComplete> a : map.entrySet()) {
            QuantityComplete savedOne = map2.get(a.getKey());
            if (savedOne == null) {
                map2.put(a.getKey(), new QuantityComplete(a.getValue()));
                continue;
            }
            double d = a.getValue().getQuantity();
            savedOne.setQuantity(Double.valueOf(savedOne.getQuantity() + d));
        }
        return map2;
    }

    public static Map<BasicArticleComplete, PriceQuantityCombination> calculateRecipe(Map<BasicArticleComplete, PriceQuantityCombination> map, CompoundComponentComplete recipe, double count, QuantityComplete recipeYield, QuantityComplete realRecipeAmount, ModificationStateE state, boolean fromWithin, Timestamp validityDate, RecipeVariantAccessor recipeAccessor, CurrencyVariantAccessor currencyAccessor, CustomerReference customer, boolean useTender) throws Exception {
        Map<BasicArticleComplete, PriceQuantityCombination> ret = map;
        if (ret == null) {
            ret = new HashMap<BasicArticleComplete, PriceQuantityCombination>();
        }
        RecipeComplete rRecipe = recipe.getUnderlyingRecipe();
        RecipeVariantComplete rRecipeVariant = (RecipeVariantComplete)recipeAccessor.loadData(rRecipe, validityDate);
        QuantityInterpolationComplete ic = recipe.getQuantity();
        QuantityComplete nq = new QuantityComplete();
        QuantityComplete yield = recipeYield;
        QuantityComplete realYield = realRecipeAmount;
        if (ic instanceof LinearQuantityInterpolationComplete) {
            LinearQuantityInterpolationComplete lq = (LinearQuantityInterpolationComplete)recipe.getQuantity();
            if (recipeYield != null && realRecipeAmount != null) {
                double convertedValue = UnitConversionToolkit.convertUnit(lq.getResultingQuantity().getUnit(), lq.getResultingQuantity().getUnit(), (double)lq.getResultingQuantity().getQuantity(), null, validityDate);
                double nYield = UnitConversionToolkit.convertUnit(yield.getUnit(), realYield.getUnit(), (double)yield.getQuantity(), null, validityDate);
                if (fromWithin && nYield != realRecipeAmount.getQuantity()) {
                    nYield = realRecipeAmount.getQuantity();
                }
                nq.setQuantity(Double.valueOf(convertedValue * count));
                nq.setUnit(lq.getResultingQuantity().getUnit());
            } else {
                nq.setQuantity(Double.valueOf(lq.getResultingQuantity().getQuantity() * count));
                nq.setUnit(lq.getResultingQuantity().getUnit());
            }
            yield = rRecipeVariant.getYield();
            realYield = nq;
        } else if (ic instanceof StepQuantityInterpolationComplete) {
            StepQuantityInterpolationComplete sq = (StepQuantityInterpolationComplete)ic;
            yield = rRecipeVariant.getYield();
            if (recipeYield != null && yield != null) {
                realYield = RecipeCalculationToolkit.resolveStep(sq.getSteps(), realRecipeAmount);
            }
        }
        double nRealYield = UnitConversionToolkit.convertUnit(realYield.getUnit(), yield.getUnit(), (double)realYield.getQuantity(), null, validityDate);
        realYield.setQuantity(Double.valueOf(nRealYield));
        realYield.setUnit(yield.getUnit());
        RecipeVariantComplete r = rRecipeVariant;
        CalculatedRecipe b = RecipeCalculationToolkit.calculateRecipeIngredients((IRecipe)r, realYield, null, currencyAccessor, recipeAccessor, validityDate, customer, useTender);
        for (CalculatedIngredient ing : b.getIngredients()) {
            ProductRecipeAmountCalculationToolkit.checkIngredients(map, ing, validityDate, customer, useTender);
        }
        return ret;
    }

    private static void checkIngredients(Map<BasicArticleComplete, PriceQuantityCombination> map, CalculatedIngredient ing, Timestamp validityDate, CustomerReference customer, boolean useTender) {
        if (ing instanceof CalculatedBasicArticleIngredient) {
            BasicArticleComplete artC = ((SimpleIngredientComplete)ing.getIngredient()).getArticle();
            PriceQuantityCombination qq = new PriceQuantityCombination();
            if (Boolean.TRUE.equals(artC.getCustomerIsOwner()) || Boolean.TRUE.equals(artC.getExcludeFromMaterialCostCalculations())) {
                qq.setPrice(new PriceComplete(ing.getPrice()));
            } else {
                qq.setPrice(ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)artC, validityDate, customer, useTender));
            }
            qq.setQuantity(ing.getQuantity());
            ProductRecipeAmountCalculationToolkit.mergeArticlePriceQuantityMap(map, artC, qq, validityDate);
        } else if (ing instanceof CalculatedRecipeIngredient) {
            CalculatedRecipe r = ((CalculatedRecipeIngredient)ing).getRecipe();
            for (CalculatedIngredient i : r.getIngredients()) {
                ProductRecipeAmountCalculationToolkit.checkIngredients(map, i, validityDate, customer, useTender);
            }
        }
    }

    private static QuantityComplete calculateArticle(BasicArticleComplete article, QuantityInterpolationComplete ic, QuantityComplete recipeYield, QuantityComplete realRecipeAmount, SimpleComponentComplete comp, Timestamp validity) throws DTOUtilException {
        if (article == null) {
            return new QuantityComplete();
        }
        QuantityInterpolationComplete ing = ic;
        QuantityComplete nq = new QuantityComplete();
        if (ing instanceof LinearQuantityInterpolationComplete) {
            UnitComplete sourceUnit = ((LinearQuantityInterpolationComplete)ing).getResultingQuantity().getUnit();
            UnitComplete destinationUnit = null;
            if (destinationUnit == null) {
                destinationUnit = article.getPriceUnit();
            }
            double sourceAmount = ((LinearQuantityInterpolationComplete)ing).getResultingQuantity().getQuantity();
            double convertedValue = UnitConversionToolkit.convertUnit(sourceUnit, destinationUnit, sourceAmount, (BasicArticleLight)article, validity);
            if (recipeYield != null && realRecipeAmount != null) {
                double nYield = UnitConversionToolkit.convertUnit(realRecipeAmount.getUnit(), recipeYield.getUnit(), (double)realRecipeAmount.getQuantity(), (BasicArticleLight)article, validity);
                convertedValue = convertedValue * nYield / recipeYield.getQuantity();
            }
            nq.setQuantity(Double.valueOf(convertedValue));
            nq.setUnit(destinationUnit);
            return nq;
        }
        if (ing instanceof StepQuantityInterpolationComplete) {
            StepQuantityInterpolationComplete sq = (StepQuantityInterpolationComplete)ing;
            QuantityComplete q = RecipeCalculationToolkit.resolveStep(sq.getSteps(), realRecipeAmount);
            return q;
        }
        return null;
    }

    public static Map<BasicArticleComplete, PriceQuantityCombination> processSubstitutions(FlightLight flight, CabinClassComplete cabinClass, ProductComplete product, RecipeComplete recipe, List<ItemSubstitutionEntryComplete> nsubs, Map<BasicArticleComplete, PriceQuantityCombination> articles, BasicArticleAccessor accessor, ProductVariantComplete variant, Timestamp validity) throws Exception {
        for (ItemSubstitutionEntryComplete s : nsubs) {
            boolean take = ProductRecipeAmountCalculationToolkit.matchSubstitution(flight, cabinClass, product, recipe, s);
            if (!take) continue;
            BasicArticleComplete newArticleComplete = (BasicArticleComplete)accessor.loadData(s.getNewArticle(), null);
            if (s.getOriginArticle() != null) {
                BasicArticleComplete originArticleComplete = (BasicArticleComplete)accessor.loadData(s.getOriginArticle(), null);
                double substitutionOriginInStoreUnit = UnitConversionToolkit.convertUnit(s.getOriginQuantity().getUnit(), originArticleComplete.getPriceUnit(), (double)s.getOriginQuantity().getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                PriceQuantityCombination articleOriginQuantity = articles.get(originArticleComplete);
                QuantityComplete usedOriginQuantity = new QuantityComplete(Double.valueOf(0.0), originArticleComplete.getPriceUnit());
                if (articleOriginQuantity != null) {
                    double articleOriginInStoreUnit = UnitConversionToolkit.convertUnit(articleOriginQuantity.getQuantity().getUnit(), originArticleComplete.getPriceUnit(), (double)articleOriginQuantity.getQuantity().getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                    double nd = Math.max(0.0, articleOriginInStoreUnit - substitutionOriginInStoreUnit);
                    if (s.getUseCompleteOriginQuantity().booleanValue()) {
                        nd = 0.0;
                        usedOriginQuantity.setQuantity(Double.valueOf(articleOriginInStoreUnit));
                    } else {
                        nd = Math.max(0.0, articleOriginInStoreUnit - substitutionOriginInStoreUnit);
                        usedOriginQuantity.setQuantity(Double.valueOf(substitutionOriginInStoreUnit));
                    }
                    double np = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)originArticleComplete, flight.getStd(), (CustomerReference)product.getCustomer(), (boolean)variant.getTenderVariant()).getPrice();
                    if (nd <= 0.0) {
                        articles.remove(originArticleComplete);
                    } else {
                        articleOriginQuantity.getPrice().setPrice(Double.valueOf(np));
                        articleOriginQuantity.getQuantity().setQuantity(Double.valueOf(nd));
                    }
                }
            }
            double substitutionReplacedInStoreUnit = UnitConversionToolkit.convertUnit(s.getReplacedQuantity().getUnit(), newArticleComplete.getPriceUnit(), (double)s.getReplacedQuantity().getQuantity(), (BasicArticleLight)newArticleComplete, validity);
            PriceQuantityCombination nq = articles.get(newArticleComplete);
            if (nq == null) {
                nq = new PriceQuantityCombination();
                nq.setPrice(new PriceComplete());
                nq.getPrice().setPrice(Double.valueOf(0.0));
                nq.getPrice().setCurrency(null);
                nq.setQuantity(new QuantityComplete());
                nq.getQuantity().setQuantity(Double.valueOf(0.0));
                nq.getQuantity().setUnit(newArticleComplete.getPriceUnit());
                articles.put(newArticleComplete, nq);
            }
            double articleReplacedInStoreUnit = UnitConversionToolkit.convertUnit(nq.getQuantity().getUnit(), newArticleComplete.getPriceUnit(), (double)nq.getQuantity().getQuantity(), (BasicArticleLight)newArticleComplete, validity);
            double nd = articleReplacedInStoreUnit + substitutionReplacedInStoreUnit;
            if (s.getUseCompleteReplacedQuantity().booleanValue()) {
                boolean foundUnit = false;
                if (s.getOriginArticle() != null) {
                    BasicArticleComplete originArticleComplete = (BasicArticleComplete)accessor.loadData(s.getOriginArticle(), null);
                    double substitutionOriginInStoreUnit = UnitConversionToolkit.convertUnit(s.getOriginQuantity().getUnit(), originArticleComplete.getPriceUnit(), (double)s.getOriginQuantity().getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                    PriceQuantityCombination articleOriginQuantity = articles.get(originArticleComplete);
                    QuantityComplete usedOriginQuantity = new QuantityComplete(Double.valueOf(0.0), originArticleComplete.getPriceUnit());
                    if (UnitConversionToolkit.isUnitContaining(usedOriginQuantity.getUnit(), newArticleComplete.getPriceUnit(), (BasicArticleLight)newArticleComplete, validity) != 11) {
                        PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)originArticleComplete, validity);
                        Collections.sort(base.getPackingQuantities());
                        for (PackagingQuantityComplete pa : base.getPackingQuantities()) {
                            if (foundUnit || UnitConversionToolkit.isUnitContaining(pa.getUnit(), newArticleComplete.getPriceUnit(), (BasicArticleLight)newArticleComplete, validity) == 11) continue;
                            foundUnit = true;
                            double d = UnitConversionToolkit.convertUnit(usedOriginQuantity.getUnit(), pa.getUnit(), (double)usedOriginQuantity.getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                            d = UnitConversionToolkit.convertUnit(pa.getUnit(), newArticleComplete.getPriceUnit(), d, (BasicArticleLight)newArticleComplete, validity);
                            nd = articleReplacedInStoreUnit + d;
                        }
                    } else {
                        double d = UnitConversionToolkit.convertUnit(usedOriginQuantity.getUnit(), newArticleComplete.getPriceUnit(), (double)usedOriginQuantity.getQuantity(), (BasicArticleLight)newArticleComplete, validity);
                        nd = articleReplacedInStoreUnit + d;
                    }
                    if (!foundUnit) {
                        throw new IllegalStateException("Unable to auto calculate substituted quantity from Article " + originArticleComplete.getNumber() + " - " + originArticleComplete.getName() + " to " + newArticleComplete.getNumber() + " - " + newArticleComplete.getName());
                    }
                } else {
                    nd = articleReplacedInStoreUnit;
                    if (nd == 0.0) {
                        nd = 1.0;
                    }
                }
            } else {
                nd = articleReplacedInStoreUnit + substitutionReplacedInStoreUnit;
            }
            double np = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)newArticleComplete, flight.getStd(), (CustomerReference)product.getCustomer(), (boolean)variant.getTenderVariant()).getPrice();
            nq.getPrice().setPrice(Double.valueOf(np));
            nq.getQuantity().setQuantity(Double.valueOf(nd));
        }
        return articles;
    }

    public static Map<BasicArticleComplete, QuantityComplete> processSubstitutionsQuantity(FlightLight flight, CabinClassComplete cabinClass, ProductComplete product, RecipeComplete recipe, List<ItemSubstitutionEntryComplete> nsubs, Map<BasicArticleComplete, QuantityComplete> articles, BasicArticleAccessor accessor, Timestamp validity) throws Exception {
        for (ItemSubstitutionEntryComplete s : nsubs) {
            boolean take = ProductRecipeAmountCalculationToolkit.matchSubstitution(flight, cabinClass, product, recipe, s);
            if (!take) continue;
            BasicArticleComplete originArticleComplete = (BasicArticleComplete)accessor.loadData(s.getOriginArticle(), null);
            BasicArticleComplete newArticleComplete = (BasicArticleComplete)accessor.loadData(s.getNewArticle(), null);
            double substitutitionArticleInStoreUnit = UnitConversionToolkit.convertUnit(s.getOriginQuantity().getUnit(), originArticleComplete.getPriceUnit(), (double)s.getOriginQuantity().getQuantity(), (BasicArticleLight)originArticleComplete, validity);
            QuantityComplete articlesOriginQuantity = articles.get(originArticleComplete);
            QuantityComplete usedOriginQuantity = new QuantityComplete(Double.valueOf(0.0), originArticleComplete.getPriceUnit());
            if (articlesOriginQuantity != null) {
                double articleOriginQuantityInStoreUnit = UnitConversionToolkit.convertUnit(articlesOriginQuantity.getUnit(), originArticleComplete.getPriceUnit(), (double)articlesOriginQuantity.getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                double nd = Math.max(0.0, articleOriginQuantityInStoreUnit - substitutitionArticleInStoreUnit);
                if (s.getUseCompleteOriginQuantity().booleanValue()) {
                    nd = 0.0;
                    usedOriginQuantity.setQuantity(Double.valueOf(articleOriginQuantityInStoreUnit));
                } else {
                    nd = Math.max(0.0, articleOriginQuantityInStoreUnit - substitutitionArticleInStoreUnit);
                    usedOriginQuantity.setQuantity(Double.valueOf(substitutitionArticleInStoreUnit));
                }
                if (nd <= 0.0) {
                    articles.remove(originArticleComplete);
                } else {
                    articlesOriginQuantity.setQuantity(Double.valueOf(nd));
                }
            }
            double substitutitionNewArticleInStoreUnit = UnitConversionToolkit.convertUnit(s.getReplacedQuantity().getUnit(), originArticleComplete.getPriceUnit(), (double)s.getReplacedQuantity().getQuantity(), (BasicArticleLight)originArticleComplete, validity);
            QuantityComplete articleReplacedQuantity = articles.get(newArticleComplete);
            if (articleReplacedQuantity == null) {
                articleReplacedQuantity = new QuantityComplete();
                articleReplacedQuantity.setQuantity(Double.valueOf(0.0));
                articleReplacedQuantity.setUnit(newArticleComplete.getPriceUnit());
                articles.put(newArticleComplete, articleReplacedQuantity);
            }
            double articleReplacedInStoreUnit = UnitConversionToolkit.convertUnit(articleReplacedQuantity.getUnit(), newArticleComplete.getPriceUnit(), (double)articleReplacedQuantity.getQuantity(), (BasicArticleLight)newArticleComplete, validity);
            double nd = articleReplacedInStoreUnit + substitutitionNewArticleInStoreUnit;
            if (s.getUseCompleteReplacedQuantity().booleanValue()) {
                boolean foundUnit = false;
                if (UnitConversionToolkit.isUnitContaining(usedOriginQuantity.getUnit(), newArticleComplete.getPriceUnit(), (BasicArticleLight)newArticleComplete, validity) != 11) {
                    PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)originArticleComplete, validity);
                    Collections.sort(base.getPackingQuantities());
                    for (PackagingQuantityComplete pa : base.getPackingQuantities()) {
                        if (foundUnit || UnitConversionToolkit.isUnitContaining(pa.getUnit(), newArticleComplete.getPriceUnit(), (BasicArticleLight)newArticleComplete, validity) == 11) continue;
                        foundUnit = true;
                        double d = UnitConversionToolkit.convertUnit(usedOriginQuantity.getUnit(), pa.getUnit(), (double)usedOriginQuantity.getQuantity(), (BasicArticleLight)originArticleComplete, validity);
                        d = UnitConversionToolkit.convertUnit(pa.getUnit(), newArticleComplete.getPriceUnit(), d, (BasicArticleLight)newArticleComplete, validity);
                        nd = articleReplacedInStoreUnit + d;
                    }
                } else {
                    double d = UnitConversionToolkit.convertUnit(usedOriginQuantity.getUnit(), newArticleComplete.getPriceUnit(), (double)usedOriginQuantity.getQuantity(), (BasicArticleLight)newArticleComplete, validity);
                    nd = articleReplacedInStoreUnit + d;
                }
                if (!foundUnit) {
                    throw new IllegalStateException("Unable to auto calculate substituted quantity from Article " + originArticleComplete.getNumber() + " - " + originArticleComplete.getName() + " to " + newArticleComplete.getNumber() + " - " + newArticleComplete.getName());
                }
            } else {
                nd = articleReplacedInStoreUnit + substitutitionNewArticleInStoreUnit;
            }
            articleReplacedQuantity.setQuantity(Double.valueOf(nd));
        }
        return articles;
    }

    private static boolean matchSubstitution(FlightLight flight, CabinClassComplete clazz, ProductComplete product, RecipeComplete recipe, ItemSubstitutionEntryComplete e) {
        boolean takeEntry = e.getFlight().equals((Object)flight);
        if (takeEntry) {
            takeEntry = clazz == null ? e.getCabinClass() == null : (e.getCabinClass() == null ? true : e.getCabinClass().equals((Object)clazz));
        }
        if (takeEntry) {
            takeEntry = product == null && e.getProd() == null ? true : e.getProd() != null && product.equals((Object)e.getProd());
        }
        if (takeEntry) {
            takeEntry = recipe != null && e.getRp() != null ? recipe.equals((Object)e.getRp()) : recipe == null && e.getRp() == null;
        }
        return takeEntry;
    }
}

