/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.toolkit;

import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class DrawToolkit {
    public static void drawResizeCorner(Graphics2D g2, Component comp, int offsetX, int offsetY) {
        g2.setColor(new Color(16, 16, 16));
        g2.drawLine(comp.getWidth() - 6 - offsetX, comp.getHeight() - 3 - offsetY, comp.getWidth() - 3 - offsetX, comp.getHeight() - 6 - offsetY);
        g2.drawLine(comp.getWidth() - 10 - offsetX, comp.getHeight() - 3 - offsetY, comp.getWidth() - 3 - offsetX, comp.getHeight() - 10 - offsetY);
        g2.drawLine(comp.getWidth() - 14 - offsetX, comp.getHeight() - 3 - offsetY, comp.getWidth() - 3 - offsetX, comp.getHeight() - 14 - offsetY);
    }

    public static Shape createHatchTexture(int w, int h, double radius) {
        return DrawToolkit.createHatchTexture(w, h, radius, 4);
    }

    public static Shape createHatchTexture(int w, int h, double radius, int space) {
        double texHeight = h;
        double texWidth = Math.tan(radius) * texHeight;
        GeneralPath p = new GeneralPath();
        int i = space;
        while ((double)i < (double)w + texWidth) {
            p.moveTo(i, 0.0f);
            p.lineTo((double)i - texWidth - 1.0, texHeight - 1.0);
            i += space;
        }
        return p;
    }

    public static float setAlphaComposite(Graphics2D g2, AlphaFader fader, float max) {
        if (fader == null) {
            return max;
        }
        Float p = Float.valueOf(max);
        try {
            p = Float.valueOf(fader.lookUpComposite(max));
            if (p.equals(Float.valueOf(Float.NaN))) {
                p = Float.valueOf(0.0f);
            }
            g2.setComposite(AlphaComposite.getInstance(3, p.floatValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p.floatValue();
    }

    public static float setAlphaComposite(Graphics2D g2, AlphaFader fader) {
        return DrawToolkit.setAlphaComposite(g2, fader, 1.0f);
    }

    public static void drawEmbossedString(Graphics2D g2, String text, int x, int y, Color c1, Color c2) {
        DrawToolkit.drawEmbossedString(g2, text, x, y, c1, c2, 0, 1);
    }

    public static void drawEmbossedString(Graphics2D g2, String text, int x, int y, Color c1, Color c2, int xoffset, int yoffset) {
        g2.setColor(c2);
        g2.drawString(text, x + xoffset, y + yoffset);
        g2.setColor(c1);
        g2.drawString(text, x, y);
    }
}

