/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import java.awt.Component;
import java.sql.Date;
import java.util.List;

public abstract class TemporalVariantInserter<T extends VariantLight> {
    public abstract Node<T> getLatestData();

    public abstract T createNewVariant();

    public abstract Node<Date> getStartDate(Node<T> var1);

    public abstract Node<Date> getEndDate(Node<T> var1);

    public abstract void setValidityPeriod(T var1, PeriodComplete var2);

    public void insertNewVariant(Component uiParent, Node<List<T>> parentNode) {
        Node<T> latestData = this.getLatestData();
        T m = this.createNewVariant();
        m.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (latestData != null) {
            Date d;
            Node<Date> latestDateStart = this.getStartDate(latestData);
            Node<Date> latestDateEnd = this.getEndDate(latestData);
            Date lastEnd = (Date)latestDateEnd.getValue();
            Date lastStart = (Date)latestDateStart.getValue();
            boolean isFuture = false;
            if (lastStart.getTime() > System.currentTimeMillis()) {
                isFuture = true;
            }
            boolean wasInfinity = false;
            if (CalendarUtil.isInfinityDate((Date)lastEnd)) {
                wasInfinity = true;
                if (isFuture) {
                    d = new Date(lastStart.getTime());
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                } else {
                    d = new Date(System.currentTimeMillis());
                    d = new PeriodComplete(d, null).getStartDate();
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                }
                d = new PeriodComplete(null, d).getEndDate();
            } else {
                d = lastEnd;
                d = new PeriodComplete(null, d).getEndDate();
            }
            d.setTime(d.getTime() + 2L);
            PeriodComplete period = new PeriodComplete(d, d);
            if (wasInfinity) {
                period.setEndDate(CalendarUtil.getInfinityDate());
            }
            this.setValidityPeriod(m, period);
        } else {
            this.setValidityPeriod(m, new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO(m, true, false);
        parentNode.addChild(n, System.currentTimeMillis());
        uiParent.validate();
    }
}

