/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.productivity.ProductivityDailyFixHoursVariantComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.productivity.ProductivityDailyFixHoursVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.reserve.RecipeReserveVariantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ProductivityDailyFixHoursSettingsTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public ProductivityDailyFixHoursSettingsTable() {
        super(true, Words.ADD, true, true, "Daily Fix Hours Variants");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ProductivityDailyFixHoursSettingsTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ProductivityDailyFixHoursVariantComplete c = new ProductivityDailyFixHoursVariantComplete();
                c.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                c.setManHours(Double.valueOf(0.0));
                c.setMonday(Boolean.valueOf(true));
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                ProductivityDailyFixHoursSettingsTable.this.getModel().getNode().addChild(node, 0L);
                ProductivityDailyFixHoursSettingsTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.DEPARMENT, null, null, null, "", 200));
        columns.add(new TableColumnInfo(Words.DAYS, null, null, null, "", 400));
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", TableColumnInfo.periodColumnWidth * 2));
        columns.add(new TableColumnInfo(Words.HOURS, null, null, null, "", 80));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField name;
        private ComboBox department;
        private TitledItem<CheckBox> mo;
        private TitledItem<CheckBox> tu;
        private TitledItem<CheckBox> we;
        private TitledItem<CheckBox> th;
        private TitledItem<CheckBox> fr;
        private TitledItem<CheckBox> sa;
        private TitledItem<CheckBox> so;
        private TitledItem<CheckBox> sp;
        private TitledPeriodEditor validity;
        private TextField hours;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.name = new TextField(m.getNode().getChildNamed(RecipeReserveVariantComplete_.name));
            this.department = new ComboBox(m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.department), NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class));
            this.mo = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.monday)), "Mo", TitledItem.TitledItemOrientation.EAST);
            this.tu = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.tuesday)), "Tu", TitledItem.TitledItemOrientation.EAST);
            this.we = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.wednesday)), "We", TitledItem.TitledItemOrientation.EAST);
            this.th = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.thursday)), "Th", TitledItem.TitledItemOrientation.EAST);
            this.fr = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.friday)), "Fr", TitledItem.TitledItemOrientation.EAST);
            this.sa = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.saturday)), "Sa", TitledItem.TitledItemOrientation.EAST);
            this.so = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.sunday)), "So", TitledItem.TitledItemOrientation.EAST);
            this.sp = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.specialDay)), "Holiday", TitledItem.TitledItemOrientation.EAST);
            this.validity = new TitledPeriodEditor(null, null);
            this.validity.enableInfinity(false, true);
            this.validity.setNode((Node<PeriodComplete>)m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.validity));
            this.hours = new TextField(m.getNode().getChildNamed(ProductivityDailyFixHoursVariantComplete_.manHours), TextFieldType.DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.name);
            this.add(this.department);
            this.add(this.mo);
            this.add(this.tu);
            this.add(this.we);
            this.add(this.th);
            this.add(this.fr);
            this.add(this.sa);
            this.add(this.so);
            this.add(this.sp);
            this.add(this.validity);
            this.add(this.hours);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.department.kill();
            this.mo.kill();
            this.tu.kill();
            this.we.kill();
            this.th.kill();
            this.fr.kill();
            this.sa.kill();
            this.so.kill();
            this.sp.kill();
            this.hours.kill();
            this.validity.kill();
            this.delete.kill();
            this.name = null;
            this.department = null;
            this.mo = null;
            this.tu = null;
            this.we = null;
            this.th = null;
            this.fr = null;
            this.sa = null;
            this.so = null;
            this.sp = null;
            this.hours = null;
            this.validity = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.name);
            CheckedListAdder.addToList(focusList, this.department);
            CheckedListAdder.addToList(focusList, this.mo);
            CheckedListAdder.addToList(focusList, this.tu);
            CheckedListAdder.addToList(focusList, this.we);
            CheckedListAdder.addToList(focusList, this.th);
            CheckedListAdder.addToList(focusList, this.fr);
            CheckedListAdder.addToList(focusList, this.sa);
            CheckedListAdder.addToList(focusList, this.so);
            CheckedListAdder.addToList(focusList, this.sp);
            CheckedListAdder.addToList(focusList, this.validity);
            CheckedListAdder.addToList(focusList, this.hours);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.mo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (parent.getHeight() - TableRowImpl.this.mo.getHeight()) / 2);
                TableRowImpl.this.mo.setSize(TableRowImpl.this.mo.getPreferredSize());
                TableRowImpl.this.tu.setLocation(TableRowImpl.this.mo.getX() + TableRowImpl.this.mo.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.tu.setSize(TableRowImpl.this.tu.getPreferredSize());
                TableRowImpl.this.we.setLocation(TableRowImpl.this.tu.getX() + TableRowImpl.this.tu.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.we.setSize(TableRowImpl.this.we.getPreferredSize());
                TableRowImpl.this.th.setLocation(TableRowImpl.this.we.getX() + TableRowImpl.this.we.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.th.setSize(TableRowImpl.this.th.getPreferredSize());
                TableRowImpl.this.fr.setLocation(TableRowImpl.this.th.getX() + TableRowImpl.this.th.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.fr.setSize(TableRowImpl.this.fr.getPreferredSize());
                TableRowImpl.this.sa.setLocation(TableRowImpl.this.fr.getX() + TableRowImpl.this.fr.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.sa.setSize(TableRowImpl.this.sa.getPreferredSize());
                TableRowImpl.this.so.setLocation(TableRowImpl.this.sa.getX() + TableRowImpl.this.sa.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.so.setSize(TableRowImpl.this.so.getPreferredSize());
                TableRowImpl.this.sp.setLocation(TableRowImpl.this.so.getX() + TableRowImpl.this.so.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mo.getY());
                TableRowImpl.this.sp.setSize(TableRowImpl.this.sp.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.validity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.validity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.validity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.validity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.hours.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.hours.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.hours.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.hours.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

