/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterManMinutesPriceComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterManMinutesPriceComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class InternalCostCenterPriceTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public InternalCostCenterPriceTable() {
        super(true, Words.ADD, true, true, Words.PRICES);
        this.setComparator(new Comparator<TableRowImpl>(){

            @Override
            public int compare(TableRowImpl o1, TableRowImpl o2) {
                if (o1.getModel().getNode().getValue() instanceof InternalCostCenterManMinutesPriceComplete) {
                    InternalCostCenterManMinutesPriceComplete a1 = (InternalCostCenterManMinutesPriceComplete)o1.getModel().getNode().getValue();
                    InternalCostCenterManMinutesPriceComplete a2 = (InternalCostCenterManMinutesPriceComplete)o2.getModel().getNode().getValue();
                    return a1.compareTo(a2);
                }
                return 0;
            }
        });
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                InternalCostCenterPriceTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                InternalCostCenterPriceTable.this.insertNewPrice();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tk = TableColumnInfo.priceColumnWidth + 60;
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tk, tk, tk));
        int tp = TableColumnInfo.periodColumnWidth * 2;
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", tp, tp, tp));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void insertNewPrice() {
        Node latestData = this.getModel().getNode().getChildCount() > 0 ? this.getModel().getNode().getChildAt(this.getModel().getNode().getChildCount() - 1) : null;
        InternalCostCenterManMinutesPriceComplete np = new InternalCostCenterManMinutesPriceComplete();
        np.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (latestData != null) {
            Date d;
            Node latestDateStart = latestData.getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.validity, PeriodComplete_.startDate});
            Node latestDateEnd = latestData.getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.validity, PeriodComplete_.endDate});
            Date lastEnd = (Date)latestDateEnd.getValue();
            Date lastStart = (Date)latestDateStart.getValue();
            boolean isFuture = false;
            if (lastStart.getTime() > System.currentTimeMillis()) {
                isFuture = true;
            }
            boolean wasInfinity = false;
            if (CalendarUtil.isInfinityDate((Date)lastEnd)) {
                wasInfinity = true;
                if (isFuture) {
                    d = new Date(lastStart.getTime());
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                } else {
                    d = new Date(System.currentTimeMillis());
                    d = new PeriodComplete(d, null).getStartDate();
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                }
                d = new PeriodComplete(null, d).getEndDate();
            } else {
                d = lastEnd;
                d = new PeriodComplete(null, d).getEndDate();
            }
            d.setTime(d.getTime() + 2L);
            PeriodComplete period = new PeriodComplete(d, d);
            if (wasInfinity) {
                period.setEndDate(CalendarUtil.getInfinityDate());
            }
            np.setValidity(period);
        } else {
            np.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        if (latestData != null) {
            np.setPricePerHour(new PriceComplete(((InternalCostCenterManMinutesPriceComplete)latestData.getValue()).getPricePerHour()));
        } else {
            SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            np.setPricePerHour(new PriceComplete(settingsComplete.getCurrency(), Double.valueOf(0.0)));
        }
        this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)np, true, false), 0L);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private InputComboBox price;
        private TitledPeriodEditor period;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.price = new InputComboBox(null, null, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.price.setUseMaxKommaStellen(true);
            this.price.setMaxKommaStellen(3);
            this.price.setOverrideUnitWith(60);
            this.price.setNode(m.getNode().getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.pricePerHour, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.pricePerHour, PriceComplete_.currency}));
            m.getNode().getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.pricePerHour, PriceComplete_.price}).addNodeListener((NodeListener)this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.period = new TitledPeriodEditor(null, null);
            this.period.enableInfinity(false, true);
            this.period.setNode((Node<PeriodComplete>)m.getNode().getChildNamed(InternalCostCenterManMinutesPriceComplete_.validity));
            this.setLayout(new Layout3());
            this.add(this.delete);
            this.add(this.price);
            this.add(this.period);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new DtoField[]{InternalCostCenterManMinutesPriceComplete_.pricePerHour, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            this.price.kill();
            this.price = null;
            this.period.kill();
            this.period = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.price);
            CheckedListAdder.addToList(focusList, this.period);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
        }

        public void valueChanged(Node<?> node) {
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

