/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.production_new.UpdateConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.production_new.UpdateConfigurationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;

public class CustomerUpdateColumnCountTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public CustomerUpdateColumnCountTable(String day) {
        super(true, Words.ADD, true, false, Words.CUSTOMERS);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomerUpdateColumnCountTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                UpdateConfigurationComplete newDiscount = new UpdateConfigurationComplete();
                newDiscount.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)newDiscount, false, false);
                if (node4DTO != null) {
                    CustomerUpdateColumnCountTable.this.getModel().getNode().addChild(node4DTO, 0L);
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(day, null, null, null, "", 80, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 120));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> this.createRow(model1)));
    }

    public void setNode(Node customers) {
        this.getModel().setNode(customers);
    }

    private Table2RowPanel createRow(Table2RowModel model) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        row.addLayoutComponent(SearchTextField2Factory.getCustomerSearchField(true, model.getNode().getChildNamed(UpdateConfigurationComplete_.customer)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextField(model.getNode().getChildNamed(UpdateConfigurationComplete_.columnCount), TextFieldType.INT), DefaultTable2RowPanelLayout.LayoutType.FILL);
        DeleteButton delete = new DeleteButton();
        delete.addButtonListener((source, x, y) -> model.getNode().getParent().removeChild(model.getNode(), 0L));
        row.addLayoutComponent(delete, DefaultTable2RowPanelLayout.LayoutType.FIX);
        return row;
    }
}

