/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.skins.impls.defaults;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.StateSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class SkinReader {
    private static Map<String, WeakReference<BufferedImage>> properties = new HashMap<String, WeakReference<BufferedImage>>();

    public BufferedImage getImage(DefaultSkins skinDefinition, Button.ButtonState state) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        SizedSkin1Field.SkinSize usedSize = null;
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyNameSized(usedState, usedSize));
            }
            properties.put(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    public BufferedImage getImageSized(DefaultSkins skinDefinition, Button.ButtonState state, SizedSkin1Field.SkinSize size) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        SizedSkin1Field.SkinSize usedSize = skinDefinition.getUsedSize(size);
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyNameSized(usedState, usedSize));
            }
            properties.put(this.createCompletePropertyNameSized(skinDefinition, skinDefinition.getPath(), usedState, usedSize), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    public BufferedImage getImageToggled(DefaultSkins skinDefinition, Button.ButtonState state, boolean checked) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyNameToggled(skinDefinition, skinDefinition.getPath(), usedState, checked));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyNameToggled(skinDefinition, skinDefinition.getPath(), usedState, checked));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyNameToggled(usedState, checked));
            }
            properties.put(this.createCompletePropertyNameToggled(skinDefinition, skinDefinition.getPath(), usedState, checked), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    public BufferedImage getImageTwoState(DefaultSkins skinDefinition, Button.ButtonState state, StateSkin.StateType type) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyNameTwoState(skinDefinition, skinDefinition.getPath(), usedState, type));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyNameTwoState(skinDefinition, skinDefinition.getPath(), usedState, type));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyNameTwoState(usedState, type));
            }
            properties.put(this.createCompletePropertyNameTwoState(skinDefinition, skinDefinition.getPath(), usedState, type), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    public BufferedImage getImage(DefaultSkins skinDefinition, Button.ButtonState state, Skin3Field.Skin3FieldDirection direction) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyName3Field(skinDefinition, skinDefinition.getPath(), usedState, direction));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyName3Field(skinDefinition, skinDefinition.getPath(), usedState, direction));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyName3Field(usedState, direction));
            }
            properties.put(this.createCompletePropertyName3Field(skinDefinition, skinDefinition.getPath(), usedState, direction), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    public BufferedImage getImage(DefaultSkins skinDefinition, Button.ButtonState state, Skin9Field.Skin9FieldDirection direction) {
        BufferedImage i;
        Button.ButtonState usedState = skinDefinition.getUsedState(state);
        WeakReference<BufferedImage> p = properties.get(this.createCompletePropertyName9Field(skinDefinition, skinDefinition.getPath(), usedState, direction));
        BufferedImage bufferedImage = i = p != null ? (BufferedImage)p.get() : null;
        if (i == null) {
            i = this.reloadProperty(this.createCompletePropertyName9Field(skinDefinition, skinDefinition.getPath(), usedState, direction));
            if (i == null) {
                throw new IllegalArgumentException("Unable to find Image: " + skinDefinition.getPath() + "." + this.createPropertyName9Field(usedState, direction));
            }
            properties.put(this.createCompletePropertyName9Field(skinDefinition, skinDefinition.getPath(), usedState, direction), new WeakReference<BufferedImage>(i));
        }
        return i;
    }

    private String createPropertyNameTwoState(Button.ButtonState state, StateSkin.StateType type) {
        switch (type) {
            case Green: {
                return "green." + state.toString();
            }
            case None: {
                return "none." + state.toString();
            }
            case Orange: {
                return "orange." + state.toString();
            }
        }
        return null;
    }

    private BufferedImage reloadProperty(String name) {
        return AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute(name));
    }

    private String createPropertyNameSized(Button.ButtonState state, SizedSkin1Field.SkinSize size) {
        if (size == null) {
            return state.toString();
        }
        return size.getName() + "." + state.toString();
    }

    private String createPropertyName3Field(Button.ButtonState state, Skin3Field.Skin3FieldDirection size) {
        if (size == null) {
            return state.toString();
        }
        return size.toString() + "." + state.toString();
    }

    private String createPropertyName9Field(Button.ButtonState state, Skin9Field.Skin9FieldDirection size) {
        if (size == null) {
            return state.toString();
        }
        return size.toString() + "." + state.toString();
    }

    private String createPropertyNameToggled(Button.ButtonState state, boolean checked) {
        return (checked ? "checked" : "unchecked") + "." + state.toString();
    }

    private String createCompletePropertyNameSized(DefaultSkins skinDefinition, String base, Button.ButtonState state, SizedSkin1Field.SkinSize size) {
        return skinDefinition.getPath() + "." + this.createPropertyNameSized(state, size);
    }

    private String createCompletePropertyName3Field(DefaultSkins skinDefinition, String base, Button.ButtonState state, Skin3Field.Skin3FieldDirection direction) {
        return skinDefinition.getPath() + "." + this.createPropertyName3Field(state, direction);
    }

    private String createCompletePropertyName9Field(DefaultSkins skinDefinition, String base, Button.ButtonState state, Skin9Field.Skin9FieldDirection direction) {
        return skinDefinition.getPath() + "." + this.createPropertyName9Field(state, direction);
    }

    private String createCompletePropertyNameToggled(DefaultSkins skinDefinition, String base, Button.ButtonState state, boolean checked) {
        return skinDefinition.getPath() + "." + this.createPropertyNameToggled(state, checked);
    }

    private String createCompletePropertyNameTwoState(DefaultSkins skinDefinition, String base, Button.ButtonState state, StateSkin.StateType type) {
        return skinDefinition.getPath() + "." + this.createPropertyNameTwoState(state, type);
    }

    public void clear() {
        properties.clear();
    }
}

