/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan;

import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.TableGenerator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.RecipeProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HeaderView
implements TableGenerator {
    private TextLabel item;
    private TextLabel product;
    private TextLabel recipe;
    private TextLabel startStock;
    private Table2RowModel model;
    private Node stockNode;

    @Override
    public List<TableColumnInfo> generateColumns(CustomerLight customer) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Item", null, null, null, "", 0, 450, Integer.MAX_VALUE));
        columns.add(new TableColumnInfo("Product", null, null, null, "", 75));
        columns.add(new TableColumnInfo("Recipe", null, null, null, "", 75));
        columns.add(new TableColumnInfo("Start<br/>Stock", null, null, null, "", 75));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void installItems(Table2RowModel model, Container container, Node<WeeklyPlanComplete> weeklyPlanCompleteNode, Node stockNode) {
        this.model = model;
        this.stockNode = stockNode;
        if (model.getNode().getValue() instanceof ProductProductionJobComplete) {
            this.item = new TextLabel(((ProductProductionJobComplete)model.getNode().getValue()).getProduct().getCurrentVariant().getName());
            this.product = new TextLabel(((ProductProductionJobComplete)model.getNode().getValue()).getProduct().getNumber() + "");
            this.recipe = new TextLabel();
        } else if (model.getNode().getValue() instanceof RecipeProductionJobComplete) {
            this.item = new TextLabel(((RecipeProductionJobComplete)model.getNode().getValue()).getRecipe().getCurrentVariant().getName());
            this.product = new TextLabel();
            this.recipe = new TextLabel(((RecipeProductionJobComplete)model.getNode().getValue()).getRecipe().getNumber() + "");
        } else if (model.getNode().getValue() instanceof ProductComplete) {
            ProductComplete productC = (ProductComplete)model.getNode().getValue();
            this.item = new TextLabel(productC.getCurrentVariant().getName());
            this.product = new TextLabel(productC.getNumber() + "");
            this.recipe = new TextLabel();
        }
        this.startStock = new TextLabel(stockNode.getChildNamed(new String[]{"startStock"}), ConverterRegistry.getConverter(QuantityConverter1Decimal.class));
        container.add(this.item);
        container.add(this.product);
        container.add(this.recipe);
        container.add(this.startStock);
    }

    private void loadStartStockForProduct(final ProductComplete product, final Timestamp dueDate) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                QuantityComplete productStock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductStock(new ProductReference(product.getId()), new TimestampWrapper(dueDate));
                Node startStock = HeaderView.this.stockNode.getChildNamed(new String[]{"startStock"});
                startStock.setValue((Object)productStock, 0L);
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)productStock, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)HeaderView.this.startStock);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void loadStartStockForRecipe(final RecipeComplete recipe, final Timestamp dueDate) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                QuantityComplete recipeStock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getRecipeStock(new RecipeReference(recipe.getId()), new TimestampWrapper(dueDate));
                Node startStock = HeaderView.this.stockNode.getChildNamed(new String[]{"startStock"});
                startStock.setValue((Object)recipeStock, 0L);
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)recipeStock, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)HeaderView.this.startStock);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void updateItems(Table2RowModel model, Node<WeeklyPlanComplete> node) {
        Iterator it = node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        boolean foundRecipe = false;
        while (it.hasNext()) {
            RecipeProductionJobComplete r;
            Node n = (Node)it.next();
            if (!(n.getValue() instanceof RecipeProductionJobComplete) || !(r = (RecipeProductionJobComplete)n.getValue()).getProduct().equals(model.getNode().getValue())) continue;
            this.recipe.setText(r.getRecipe().getNumber() + "");
            foundRecipe = true;
            this.stockNode.getChildNamed(new String[]{"item"}).setValue((Object)r.getRecipe(), 0L);
            this.loadStartStockForRecipe(r.getRecipe(), new Timestamp(((Date)node.getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.startDate}).getValue()).getTime()));
        }
        if (!foundRecipe) {
            this.stockNode.getChildNamed(new String[]{"item"}).setValue(model.getNode().getValue(), 0L);
            this.loadStartStockForProduct((ProductComplete)model.getNode().getValue(), new Timestamp(((Date)node.getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.startDate}).getValue()).getTime()));
        }
    }

    private int getCellPadding() {
        return this.model.getParentModel().getTable().getCellPadding();
    }

    @Override
    public int layoutItems(int cx, int cy, int pw, int ph, int index) {
        int currentX = cx;
        int w = this.model.getParentModel().getColumnWidth(index++);
        this.item.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.item.getPreferredSize().getHeight()) / 2.0));
        this.item.setSize(w - 2 * this.getCellPadding(), (int)this.item.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        this.product.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.product.getPreferredSize().getHeight()) / 2.0));
        this.product.setSize(w - 2 * this.getCellPadding(), (int)this.product.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        this.recipe.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.recipe.getPreferredSize().getHeight()) / 2.0));
        this.recipe.setSize(w - 2 * this.getCellPadding(), (int)this.recipe.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        this.startStock.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.startStock.getPreferredSize().getHeight()) / 2.0));
        this.startStock.setSize(w - 2 * this.getCellPadding(), (int)this.startStock.getPreferredSize().getHeight());
        return currentX + w;
    }
}

