/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.myway;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayout;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class PopupInsert1
extends JPanelFadable
implements IPopUpInsert {
    private static final long serialVersionUID = 1L;
    private final ScrollPane pane = new ScrollPane();
    private final JPanel contentPane = new Viewport();
    private int userPrefWidth = -1;
    private int userPrefHeight = -1;
    protected int border = 10;
    protected InnerPopUp2 popup;

    public PopupInsert1() {
        this.setProgress(1.0f);
        Color bc = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.contentPane.setBackground(bc);
        this.pane.getHorizontalScrollBar().setBackground(bc);
        this.pane.getVerticalScrollBar().setBackground(bc);
        this.pane.setBackground(bc);
        this.pane.setViewportView(this.contentPane);
        this.contentPane.setLayout(new CreepyLayout());
        this.setLayout(new Layout());
        this.add(this.pane);
    }

    public void setInnerBorderHorizontal(int ihb) {
        if (this.contentPane.getLayout() instanceof CreepyLayout) {
            ((CreepyLayout)this.contentPane.getLayout()).setInnerBorderHorizontal(ihb);
        }
    }

    public void setOuterBorderHorizontal(int ohb) {
        if (this.contentPane.getLayout() instanceof CreepyLayout) {
            ((CreepyLayout)this.contentPane.getLayout()).setOuterBorderHorizontal(ohb);
        }
    }

    public void setInnerBorderVertical(int ivb) {
        if (this.contentPane.getLayout() instanceof CreepyLayout) {
            ((CreepyLayout)this.contentPane.getLayout()).setInnerBorderVertical(ivb);
        }
    }

    public void setOuterBorderVertical(int ovb) {
        if (this.contentPane.getLayout() instanceof CreepyLayout) {
            ((CreepyLayout)this.contentPane.getLayout()).setOuterBorderVertical(ovb);
        }
    }

    public JPanel getViewPort() {
        return this.contentPane;
    }

    @Override
    public void setUserPrefSize(int w, int h) {
        this.userPrefWidth = w;
        this.userPrefHeight = h;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        this.popup = ip;
    }

    @Override
    public InnerPopUp2 getInnerPopUp() {
        return this.popup;
    }

    @Override
    public abstract boolean tryToGrabFocus();

    @Override
    public abstract List<Component> getFocusComponents();

    @Override
    public abstract boolean isClosableWithEnter();

    @Override
    public abstract Object[] getValues(PopupAction var1);

    @Override
    public abstract boolean isInnerComponent(Component var1);

    @Override
    public boolean usePictureBorder() {
        return false;
    }

    @Override
    public abstract boolean validateContent();

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.validateContent()) {
            this.popup.hidePopUp(this.getValues(isOK));
        }
    }

    @Override
    public void popupClosed() {
        this.kill();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    private class Viewport
    extends JPanel
    implements Focusable {
        private static final long serialVersionUID = 1L;

        private Viewport() {
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            for (Component c : this.getComponents()) {
                if (!(c instanceof Focusable)) continue;
                CheckedListAdder.addToList(a, (Focusable)((Object)c));
            }
            return a;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        @Override
        public Selectable getSelectDelegationComponent() {
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            for (Component c : this.getComponents()) {
                if (!(c instanceof Focusable)) continue;
                ((Focusable)((Object)c)).requestFocusInWindowNow();
                return;
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            w = PopupInsert1.this.userPrefWidth == -1 ? (int)((double)w + PopupInsert1.this.contentPane.getPreferredSize().getWidth()) : PopupInsert1.this.userPrefWidth;
            h = PopupInsert1.this.userPrefHeight == -1 ? (int)((double)h + PopupInsert1.this.contentPane.getPreferredSize().getHeight()) : PopupInsert1.this.userPrefHeight;
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            PopupInsert1.this.pane.setLocation(0, 0);
            PopupInsert1.this.pane.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

