/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.export;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.ExcelExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.RadioButtonAnalysisItem;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.MealCycleToolkit;
import ch.icit.utils.ExcelRow;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalysisPopupInsert<T extends IUniversal>
extends ExcelExportPopupInsert
implements ButtonListener {
    Logger log = LoggerFactory.getLogger(AnalysisPopupInsert.class);
    private static final long serialVersionUID = 1L;
    protected AnalysisSmartExternalOpenTool<T> externalOpenTool;
    private int itemsExported = 0;
    private long itemsSum = 0L;
    private ScrollPane scrollPane;
    private JPanel viewPort;
    private final List<AnalysisItem<?>> headerItems = new ArrayList();
    private final List<AnalysisItem<?>> customItems = new ArrayList();
    private TextLabel printTitle;
    private TextLabel printFormatTitle;
    private TextLabel styleSheetTitle;
    private TextLabel optionsTitle;
    private HorizontalSeparator separator;
    private RadioButtonBox exportSelectionBox;
    protected JPanel customPane;
    protected TitledItem<RadioButton> exportAll;
    protected TitledItem<RadioButton> exportCurrent;
    protected TitledItem<RadioButton> exportFiltered;
    private boolean isDataToExportChoosable = true;
    private boolean isReportTypeChoosable = false;
    private ReportTypeE reportType;
    protected RadioButtonBox reportTypeBox;
    protected boolean reportTypesLoaded = false;
    private final List<Runnable> loadBeforeShowing = new ArrayList<Runnable>();
    private boolean isExportFormatChoosable = false;
    private RadioButtonBox exportFormatSelectionBox;
    protected TitledItem<RadioButton> pdfRadioButton;
    protected TitledItem<RadioButton> excelRadioButton;
    protected TitledItem<RadioButton> csvRadioButton;
    protected TitledItem<RadioButton> numbers;
    protected TextField numberField;
    protected InfoButton numberInfo;
    protected ExpandIcon expandIcon;
    protected Table2 table;

    public AnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool) {
        this(externalOpenTool, false);
    }

    public AnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable, boolean withNumbers, ReportTypeE reportType) {
        this(externalOpenTool, isExportFormatChoosable, withNumbers, reportType, true);
    }

    public AnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable) {
        this(externalOpenTool, isExportFormatChoosable, false, null, true);
    }

    public AnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable, ReportTypeE reportType) {
        this(externalOpenTool, isExportFormatChoosable, false, reportType, true);
    }

    public AnalysisPopupInsert(AnalysisSmartExternalOpenTool<T> externalOpenTool, boolean isExportFormatChoosable, boolean withNumbers, ReportTypeE reportType, boolean isDataToExportChoosable) {
        super(true);
        this.externalOpenTool = externalOpenTool;
        this.isExportFormatChoosable = isExportFormatChoosable;
        this.isDataToExportChoosable = isDataToExportChoosable;
        if (reportType != null) {
            this.isReportTypeChoosable = true;
            this.reportType = reportType;
        }
        this.scrollPane = new ScrollPane();
        this.scrollPane.installDefaultColor();
        this.viewPort = new DefaultPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setVisibleContainer(VisibleContainer pane) {
            }

            @Override
            public void requestFocusInWindowNow() {
            }

            @Override
            public List<Component> getFocusComponents() {
                return null;
            }
        };
        this.scrollPane.setViewportView(this.viewPort);
        this.scrollPane.setVisible(true);
        this.viewPort.setVisible(true);
        this.add(this.scrollPane);
        this.setLayout(new InnerLayout());
        this.setViewContainer(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.printTitle = new TextLabel(this.getTitleText());
        this.customPane = new JPanel();
        this.customPane.setOpaque(false);
        this.exportSelectionBox = new RadioButtonBox();
        if (this.isReportTypeChoosable) {
            this.styleSheetTitle = new TextLabel(this.getStyleSheetText());
            this.reportTypeBox = new RadioButtonBox();
        }
        if (this.chooseExportFormat()) {
            this.printFormatTitle = new TextLabel(this.getFormatText());
            this.exportFormatSelectionBox = new RadioButtonBox();
            if (this.includePDFExportFormat()) {
                this.pdfRadioButton = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_AS_PDF, TitledItem.TitledItemOrientation.EAST);
            }
            this.excelRadioButton = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_AS_EXCEL, TitledItem.TitledItemOrientation.EAST);
            if (this.includePDFExportFormat()) {
                this.pdfRadioButton.getElement().setChecked(true);
            } else {
                this.excelRadioButton.getElement().setChecked(true);
            }
            if (this.includeCSVExportFormat()) {
                this.csvRadioButton = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_AS_CSV, TitledItem.TitledItemOrientation.EAST);
            }
            if (this.includePDFExportFormat()) {
                this.exportFormatSelectionBox.addBox(this.pdfRadioButton, this.pdfRadioButton.getElement());
            }
            this.exportFormatSelectionBox.addBox(this.excelRadioButton, this.excelRadioButton.getElement());
            if (this.includeCSVExportFormat()) {
                this.exportFormatSelectionBox.addBox(this.csvRadioButton, this.csvRadioButton.getElement());
            }
        }
        this.getViewContainer().setLayout(new Layout());
        if (this.useSearch()) {
            this.exportCurrent = new TitledItem<RadioButton>(new RadioButton(), this.getExportCurrentText(), TitledItem.TitledItemOrientation.EAST);
            this.exportFiltered = new TitledItem<RadioButton>(new RadioButton(), this.getExportFilteredText(), TitledItem.TitledItemOrientation.EAST);
            if (this.canExportAll()) {
                this.exportAll = new TitledItem<RadioButton>(new RadioButton(), this.getExportAllText(), TitledItem.TitledItemOrientation.EAST);
            }
            this.exportCurrent.getElement().addButtonListener(this);
            this.exportFiltered.getElement().addButtonListener(this);
            if (isDataToExportChoosable && this.canExportAll()) {
                this.exportAll.getElement().addButtonListener(this);
            }
            this.exportCurrent.getElement().setChecked(true);
        }
        if (isDataToExportChoosable) {
            this.getViewContainer().add(this.printTitle);
            if (this.useSearch()) {
                this.exportSelectionBox.addBox(this.exportCurrent, this.exportCurrent.getElement());
                this.exportSelectionBox.addBox(this.exportFiltered, this.exportFiltered.getElement());
            }
            if (isDataToExportChoosable && this.canExportAll()) {
                this.exportSelectionBox.addBox(this.exportAll, this.exportAll.getElement());
            }
            if (withNumbers) {
                this.numbers = new TitledItem<RadioButton>(new RadioButton(), "Export by Number", TitledItem.TitledItemOrientation.EAST);
                this.numbers.getElement().addButtonListener(this);
                this.exportSelectionBox.addBox(this.numbers, this.numbers.getElement());
                this.numberField = new TextField();
                this.numberField.getFader().setPermanent(true);
                this.getViewContainer().add(this.numberField);
                this.numberInfo = new InfoButton();
                this.numberInfo.getFader().setPermanent(true);
                this.numberInfo.installStringViewer(ProductToolkit.getStringRangeDescription());
                this.getViewContainer().add(this.numberInfo);
                this.table = this.createTable();
                if (this.table != null) {
                    this.expandIcon = new ExpandIcon();
                    this.expandIcon.addButtonListener(this);
                    this.table.getFader().setPermanent(true);
                    this.table.getFader().setMetaParent(this.getViewContainer());
                    this.table.getFader().setProgress(0.0f);
                    this.table.setSize(0, (int)this.numberField.getPreferredSize().getHeight());
                    this.table.setEnabled(false);
                    this.expandIcon.setEnabled(false);
                    this.getViewContainer().add(this.table);
                    this.getViewContainer().add(this.expandIcon);
                }
                this.numberField.setEnabled(false);
                this.numberInfo.setEnabled(false);
            }
        }
        this.getViewContainer().add(this.exportSelectionBox);
        if (this.chooseExportFormat()) {
            this.getViewContainer().add(this.printFormatTitle);
            this.getViewContainer().add(this.exportFormatSelectionBox);
        }
        if (this.isReportTypeChoosable) {
            this.getViewContainer().add(this.styleSheetTitle);
            this.getViewContainer().add(this.reportTypeBox);
        }
        this.separator = new HorizontalSeparator();
        if (isDataToExportChoosable) {
            this.getViewContainer().add(this.separator);
        }
        this.optionsTitle = new TextLabel(Words.OPTIONS);
        this.getViewContainer().add(this.optionsTitle);
        this.addOptionItems();
        if (this.useSearch()) {
            this.headerItems.add(new RadioButtonAnalysisItem(this.exportCurrent, "exportCurrent"));
            this.headerItems.add(new RadioButtonAnalysisItem(this.exportFiltered, "exportFiltered"));
            if (this.canExportAll()) {
                this.headerItems.add(new RadioButtonAnalysisItem(this.exportAll, "exportAll"));
            }
        }
        if (this.exportFormatSelectionBox != null) {
            if (this.includePDFExportFormat()) {
                this.headerItems.add(new RadioButtonAnalysisItem(this.pdfRadioButton, "pdfRadioButton"));
            }
            this.headerItems.add(new RadioButtonAnalysisItem(this.excelRadioButton, "excelRadioButton"));
            if (this.includeCSVExportFormat()) {
                this.headerItems.add(new RadioButtonAnalysisItem(this.csvRadioButton, "csvRadioButton"));
            }
        }
        this.loadConfigurationValues();
        this.setEnabled(this.isEnabled());
    }

    public List<Runnable> getLoadBeforeShowing() {
        return this.loadBeforeShowing;
    }

    protected boolean includeCSVExportFormat() {
        return false;
    }

    protected boolean includePDFExportFormat() {
        return true;
    }

    public abstract void addOptionItems();

    public boolean loadDataBeforeShowing() {
        return false;
    }

    public boolean useSearch() {
        return true;
    }

    protected final void loadConfigurationValues() {
        FilterChainConfiguration config = FilterChainConfiguration.loadConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        if (config == null) {
            config = new FilterChainConfiguration();
        }
        if (config != null) {
            this.updateConfiguration(config);
        }
    }

    protected final void writeConfigurationValues() {
        FilterChainConfiguration.saveConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), this.createFilterChainConfig(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    public final void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            for (AnalysisItem<?> t : this.customItems) {
                if (t.getMultiValues() != null) {
                    t.updateMultiValues(conf);
                }
                if (t.getName().equals(n)) {
                    t.updatePersistValue(v);
                }
                if (t.getSubItem() == null || !t.getSubItem().getName().equals(n)) continue;
                t.getSubItem().updatePersistValue(v);
            }
            for (AnalysisItem<?> t : this.headerItems) {
                if (!t.getName().equals(n)) continue;
                t.updatePersistValue(v);
            }
        }
    }

    public final FilterChainConfiguration createFilterChainConfig() {
        Object persistValue;
        FilterChainConfiguration conf = new FilterChainConfiguration();
        for (AnalysisItem<?> e : this.customItems) {
            FilterChainConfiguration multiPersistValue;
            if (e.getMultiValues() != null && (multiPersistValue = e.getMultiPersistValue()) != null) {
                conf = multiPersistValue;
            }
            if (e.getSubItem() != null && (persistValue = e.getSubItem().getPersistValue()) != null) {
                conf.addProperty(e.getSubItem().getName(), persistValue.toString());
            }
            if ((persistValue = e.getPersistValue()) == null) continue;
            conf.addProperty(e.getName(), persistValue.toString());
        }
        for (AnalysisItem<?> e : this.headerItems) {
            persistValue = e.getPersistValue();
            if (persistValue == null) continue;
            conf.addProperty(e.getName(), persistValue.toString());
        }
        return conf;
    }

    public String getExportAllText() {
        return Words.EXPORT_ALL;
    }

    public String getExportFilteredText() {
        return Words.EXPORT_FILTERED;
    }

    public String getExportCurrentText() {
        return Words.EXPORT_CURRENT;
    }

    public String getTitleText() {
        return Words.SELECT_DATA_TO_EXPORT;
    }

    public String getFormatText() {
        return Words.SELECT_FORMAT_TO_EXPORT;
    }

    public String getStyleSheetText() {
        return Words.SELECT_STYLESHEET;
    }

    public boolean canExportAll() {
        return true;
    }

    public Table2 createTable() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        ip.createFocusCycle();
    }

    public void addOptionsItem(AnalysisItem<?> ti) {
        this.customItems.add(ti);
        this.getViewContainer().add((Component)ti.getElement());
        if (ti.getSubItem() != null) {
            this.getViewContainer().add((Component)ti.getSubItem().getElement());
        }
        this.revalidate();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.expandIcon != null & this.expandIcon == source) {
            if (!this.expandIcon.isExpanded()) {
                this.hideTable();
            } else {
                this.showTable();
            }
        } else if (this.numbers != null) {
            boolean isNumbers = false;
            if (this.numbers.getElement() == source) {
                isNumbers = true;
            }
            this.numberField.setEnabled(isNumbers);
            this.numberInfo.setEnabled(isNumbers);
            if (this.expandIcon != null) {
                this.expandIcon.setEnabled(isNumbers);
            }
            if (this.table != null) {
                this.table.setEnabled(isNumbers);
            }
        }
    }

    private void showTable() {
        if (this.table != null) {
            this.table.fadeIn();
            this.table.setSizeSmooth(this.table.getWidth(), 250);
            this.numberField.fadeOut(false);
            this.numberInfo.fadeOut(false);
        }
    }

    private void hideTable() {
        if (this.table != null) {
            this.table.fadeOut(false);
            this.table.setSizeSmooth(this.table.getWidth(), (int)this.numberField.getPreferredSize().getHeight());
            this.numberField.fadeIn();
            this.numberInfo.fadeIn();
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (AnalysisItem<?> c : this.customItems) {
            if (c instanceof Focusable) {
                CheckedListAdder.addToList(a, c);
            }
            if (c.getSubItem() == null || !(c.getSubItem() instanceof Focusable)) continue;
            CheckedListAdder.addToList(a, c.getSubItem());
        }
        return a;
    }

    public String getSheetName() {
        return "1";
    }

    public void updateItemCount() {
        ++this.itemsExported;
        this.animation.stateChanged(this.getPrefixText() + " " + this.itemsExported + " of " + this.itemsSum + " Items");
    }

    public Iterator<T> getIterator() throws ServiceException {
        if (this.exportCurrent.getElement().isChecked()) {
            ASearchConfiguration<T, ?> sc = this.externalOpenTool.getFilteredConfig();
            SearchResultIterator sri = new SearchResultIterator(sc, this.externalOpenTool.getPageNumber());
            List list = sri.next(30);
            this.itemsSum = list.size();
            return list.iterator();
        }
        if (this.exportFiltered.getElement().isChecked()) {
            ASearchConfiguration<T, ?> sc = this.externalOpenTool.getFilteredConfig();
            sc.setPageNumber(0);
            SearchResultIterator sri = new SearchResultIterator(sc);
            this.itemsSum = sri.getSize();
            return sri.iterator();
        }
        if (this.canExportAll() && this.exportAll.getElement().isChecked()) {
            SearchResultIterator sri = new SearchResultIterator(this.externalOpenTool.getEmptyConfig());
            this.itemsSum = sri.getSize();
            return sri.iterator();
        }
        if (this.numbers != null && this.numbers.getElement().isChecked()) {
            return null;
        }
        return null;
    }

    public ASearchConfiguration<T, ?> getSearchConfiguration() {
        if (this.exportCurrent.getElement().isChecked()) {
            ASearchConfiguration<T, ?> sc = this.externalOpenTool.getFilteredConfig();
            sc.setPageNumber(this.externalOpenTool.getPageNumber());
            sc.setSearchtype(ASearchConfiguration.SearchType.Page);
            sc.setNumResults(30);
            return sc;
        }
        if (this.exportFiltered.getElement().isChecked()) {
            ASearchConfiguration<T, ?> sc = this.externalOpenTool.getFilteredConfig();
            sc.setSearchtype(ASearchConfiguration.SearchType.Filtered);
            sc.setPageNumber(0);
            sc.setNumResults(Integer.MAX_VALUE);
            return sc;
        }
        if (this.canExportAll() && this.exportAll.getElement().isChecked()) {
            ASearchConfiguration<T, ?> sc = this.externalOpenTool.getEmptyConfig();
            sc.setSearchtype(ASearchConfiguration.SearchType.Full);
            sc.setPageNumber(0);
            sc.setNumResults(Integer.MAX_VALUE);
            return sc;
        }
        return null;
    }

    public abstract void doProcessData();

    @Override
    protected void startPrinting() {
        super.startPrinting();
        this.doProcessData();
    }

    @Deprecated
    public List<ExcelRow> getInfoRows() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        rows.addAll(this.getDescription());
        rows.add(this.getHeaderRow());
        return rows;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.useSearch()) {
            if (this.isDataToExportChoosable && this.canExportAll()) {
                this.exportAll.setVisible(false);
            }
            this.exportCurrent.setVisible(false);
            this.exportFiltered.setVisible(false);
        }
        if (this.isReportTypeChoosable) {
            this.styleSheetTitle.setVisible(false);
            this.reportTypeBox.setVisible(false);
        }
        if (this.chooseExportFormat()) {
            if (this.includePDFExportFormat()) {
                this.pdfRadioButton.setVisible(false);
            }
            this.excelRadioButton.setVisible(false);
            this.printFormatTitle.setVisible(false);
            if (this.includeCSVExportFormat()) {
                this.csvRadioButton.setVisible(false);
            }
        }
        if (this.numbers != null) {
            this.numbers.setVisible(false);
            this.numberField.setVisible(false);
            this.numberInfo.setVisible(false);
        }
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.expandIcon != null) {
            this.expandIcon.setVisible(false);
        }
        this.printTitle.setVisible(false);
        this.optionsTitle.setVisible(false);
        this.separator.setVisible(false);
        for (AnalysisItem<?> custom : this.customItems) {
            if (custom != null) {
                ((JComponent)custom.getElement()).setVisible(false);
            }
            if (custom.getSubItem() == null) continue;
            ((JComponent)custom.getSubItem().getElement()).setVisible(false);
        }
    }

    public void addInheritedComponents() {
        if (this.useSearch()) {
            if (this.isDataToExportChoosable && this.canExportAll()) {
                this.exportAll.setVisible(true);
            }
            this.exportCurrent.setVisible(true);
            this.exportFiltered.setVisible(true);
        }
        if (this.isReportTypeChoosable) {
            this.styleSheetTitle.setVisible(true);
            this.reportTypeBox.setVisible(true);
        }
        if (this.chooseExportFormat()) {
            if (this.includePDFExportFormat()) {
                this.pdfRadioButton.setVisible(true);
            }
            this.excelRadioButton.setVisible(true);
            this.printFormatTitle.setVisible(true);
            if (this.includeCSVExportFormat()) {
                this.csvRadioButton.setVisible(true);
            }
        }
        if (this.numbers != null) {
            this.numbers.setVisible(true);
            this.numberField.setVisible(true);
            this.numberInfo.setVisible(true);
        }
        if (this.table != null) {
            this.table.setVisible(true);
        }
        if (this.expandIcon != null) {
            this.expandIcon.setVisible(true);
        }
        this.printTitle.setVisible(true);
        this.optionsTitle.setVisible(true);
        this.separator.setVisible(true);
        for (AnalysisItem<?> custom : this.customItems) {
            if (custom == null) continue;
            ((JComponent)custom.getElement()).setVisible(true);
            if (custom.getSubItem() == null) continue;
            ((JComponent)custom.getSubItem().getElement()).setVisible(true);
        }
    }

    @Override
    protected int getInheritedComponentsHeight() {
        int h = super.getInheritedComponentsHeight();
        return h;
    }

    public int getCustomItemHeight() {
        int h = 0;
        if (this.customItems.size() > 0) {
            if (this.isDataToExportChoosable) {
                h = (int)((double)h + this.separator.getPreferredSize().getHeight());
                h += this.border;
            }
            h = (int)((double)h + this.optionsTitle.getPreferredSize().getHeight());
            h += this.border;
            for (AnalysisItem<?> custom : this.customItems) {
                h = (int)((double)h + ((JComponent)custom.getElement()).getPreferredSize().getHeight());
                h += this.border;
                if (custom.getSubItem() == null) continue;
                h = (int)((double)h + ((JComponent)custom.getSubItem().getElement()).getPreferredSize().getHeight());
                h += this.border;
            }
        }
        return h;
    }

    public int layoutCustomItems(Container parent, int h, int width) {
        int h2 = h;
        if (this.customItems.size() > 0) {
            if (this.isDataToExportChoosable) {
                this.separator.setLocation(this.border, h2);
                this.separator.setSize(parent.getWidth() - 2 * this.border, (int)this.separator.getPreferredSize().getHeight());
                h2 = this.separator.getY() + this.separator.getHeight() + this.border;
            }
            if (this.isDataToExportChoosable) {
                this.optionsTitle.setLocation(this.border, h2);
            } else {
                this.optionsTitle.setLocation(this.border, 0);
            }
            this.optionsTitle.setSize(parent.getWidth() - 2 * this.border, (int)this.optionsTitle.getPreferredSize().getHeight());
            h2 = this.optionsTitle.getY() + this.optionsTitle.getHeight() + this.border;
            for (AnalysisItem<?> custom : this.customItems) {
                boolean layout = true;
                if (custom.getElement() instanceof Fadable && !((Fadable)custom.getElement()).getFader().isFaded()) {
                    layout = false;
                }
                if (custom.getSubItem() != null && custom.getSubItem().getElement() instanceof Fadable && !((Fadable)custom.getElement()).getFader().isFaded()) {
                    layout = false;
                }
                if (!layout) continue;
                ((Component)custom.getElement()).setLocation(this.border, h2);
                int height = (int)((JComponent)custom.getElement()).getPreferredSize().getHeight();
                if (custom.isGrowHeight()) {
                    height = parent.getHeight() - h2;
                }
                ((Component)custom.getElement()).setSize(parent.getWidth() - 2 * this.border, height);
                h2 = ((JComponent)custom.getElement()).getY() + ((JComponent)custom.getElement()).getHeight() + this.border;
                if (custom.getSubItem() == null) continue;
                ((Component)custom.getSubItem().getElement()).setLocation(3 * this.border, h2 - this.border);
                ((Component)custom.getSubItem().getElement()).setSize(parent.getWidth() - 2 * this.border, (int)((JComponent)custom.getElement()).getPreferredSize().getHeight());
                h2 = ((JComponent)custom.getSubItem().getElement()).getY() + ((JComponent)custom.getElement()).getHeight() + this.border;
            }
        }
        return h2;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public String getTitleString() {
        return null;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Deprecated
    public List<ExcelRow> getDescription() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow creationDate = new ExcelRow(null);
        Converter c = ConverterRegistry.getConverter(DateTimeConverter.class);
        creationDate.addCell((Object)("Creation date: " + c.convert((Object)new Timestamp(System.currentTimeMillis()), null, new Object[0])), new String[0]);
        rows.add(creationDate);
        ExcelRow exportSelection = new ExcelRow(null);
        String export = "Export ";
        if (this.exportCurrent.getElement().isChecked()) {
            export = export + "selected page";
        } else if (this.exportFiltered.getElement().isChecked()) {
            export = export + "filtered content";
        } else if (this.canExportAll() && this.exportAll.getElement().isChecked()) {
            export = export + "all";
        }
        rows.add(exportSelection);
        exportSelection.addCell((Object)export, new String[0]);
        return rows;
    }

    public List<Integer> getNumbers() {
        String t = this.numberField.getText();
        List counts = MealCycleToolkit.getIntegerForString((String)t);
        return counts;
    }

    @Deprecated
    protected ExcelRow getHeaderRow() {
        return new ExcelRow();
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        String t;
        List counts;
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.numbers != null && this.numbers.getElement().isChecked() && (this.expandIcon == null || !this.expandIcon.isExpanded()) && (counts = MealCycleToolkit.getIntegerForString((String)(t = this.numberField.getText()))).isEmpty()) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Add atleast one number"));
        }
        return o;
    }

    public String getPrefixText() {
        return "Exporting";
    }

    public boolean chooseExportFormat() {
        return this.isExportFormatChoosable;
    }

    public ReportingOutputFormatE getReportFormatType() {
        if (this.chooseExportFormat()) {
            if (this.includePDFExportFormat() && this.pdfRadioButton.getElement().isChecked()) {
                return ReportingOutputFormatE.PDF;
            }
            if (this.excelRadioButton.getElement().isChecked()) {
                return ReportingOutputFormatE.XLSX;
            }
            if (this.includeCSVExportFormat() && this.csvRadioButton.getElement().isChecked()) {
                return ReportingOutputFormatE.CSV;
            }
        }
        return ReportingOutputFormatE.XLSX;
    }

    protected ReportFileComplete getSelectedReport() {
        RadioButton b = null;
        if (this.reportTypeBox != null) {
            b = this.reportTypeBox.getSelectedButton() == null ? this.reportTypeBox.getAnyButton() : this.reportTypeBox.getSelectedButton();
        }
        if (b != null) {
            return ((DefaultScrollablePrintPopup2.ReportSelection)b).getUserObject();
        }
        return null;
    }

    public void loadReportTypes() {
        if (this.reportType != null || this.loadBeforeShowing != null && !this.loadBeforeShowing.isEmpty()) {
            this.removeInheritedComponents();
            this.ensureAnimation("Loading Report Data");
            if (this.popup != null) {
                this.popup.enableCancelButton(false);
                this.popup.enableOKButton(false);
                this.popup.enablePreviewButton(false);
            }
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    return AnalysisPopupInsert.this.loadReportTypesNow();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node != null) {
                                if (AnalysisPopupInsert.this.reportType != null && AnalysisPopupInsert.this.reportTypeBox != null) {
                                    List reports = (List)node.getValue();
                                    boolean first = true;
                                    for (ReportFileComplete r : reports) {
                                        DefaultScrollablePrintPopup2.ReportSelection f = new DefaultScrollablePrintPopup2.ReportSelection(r);
                                        TitledItem<RadioButton> item = new TitledItem<RadioButton>(f, r.getDescription(), TitledItem.TitledItemOrientation.EAST);
                                        AnalysisPopupInsert.this.reportTypeBox.addBox(item, f);
                                        AnalysisPopupInsert.this.headerItems.add(new RadioButtonAnalysisItem(item, r.getDescription()));
                                    }
                                    if (first && AnalysisPopupInsert.this.reportTypeBox.getAnyButton() != null) {
                                        AnalysisPopupInsert.this.reportTypeBox.getAnyButton().setChecked(true);
                                    }
                                }
                                AnalysisPopupInsert.this.removeAnimation(false);
                                AnalysisPopupInsert.this.addInheritedComponents();
                                if (AnalysisPopupInsert.this.popup != null) {
                                    AnalysisPopupInsert.this.popup.enablePreviewButton(true);
                                    AnalysisPopupInsert.this.popup.enableBackgroundButton(true);
                                    AnalysisPopupInsert.this.popup.enableCancelButton(true);
                                    AnalysisPopupInsert.this.popup.enableOKButton(true);
                                }
                            }
                            AnalysisPopupInsert.this.loadConfigurationValues();
                            AnalysisPopupInsert.this.reportTypesLoaded = true;
                        }

                        public void errorOccurred(ClientException exception) {
                            AnalysisPopupInsert.this.reportTypesLoaded = true;
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.reportTypesLoaded = true;
            this.loadConfigurationValues();
        }
    }

    protected Node<?> loadReportTypesNow() throws ClientGetFromServerException {
        for (Runnable r : this.loadBeforeShowing) {
            r.run();
        }
        if (this.reportType != null) {
            SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(this.reportType);
            List results = r.getResults();
            Collections.sort(results, Ordering.natural().onResultOf((Function)new Function<ReportFileComplete, String>(){

                public String apply(ReportFileComplete input) {
                    return input.getDescription();
                }
            }));
            List reportConfig = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportConfiguration(this.reportType).getList();
            if (reportConfig != null) {
                block6: for (ReportConfigurationComplete rc : reportConfig) {
                    switch (rc.getType()) {
                        case HIDE_DEFAULT: {
                            Iterator it;
                            if (!rc.getShowDefault().booleanValue()) {
                                it = results.iterator();
                                while (it.hasNext()) {
                                    if (((ReportFileComplete)it.next()).getId() != null) continue;
                                    it.remove();
                                }
                            }
                            if (!rc.getHideReport().booleanValue()) break;
                            it = results.iterator();
                            while (it.hasNext()) {
                                ReportFileComplete report = (ReportFileComplete)it.next();
                                if (!report.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            continue block6;
                        }
                        case MAX_LABEL_ENTRIES: {
                            break;
                        }
                        case REPLACE_IN_LOCATION: {
                            Iterator it = results.iterator();
                            LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                            if (rc.getShowReport().booleanValue() || !location.equals((Object)rc.getLocation())) break;
                            while (it.hasNext()) {
                                ReportFileComplete rfc = (ReportFileComplete)it.next();
                                if (!rfc.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            break;
                        }
                    }
                }
            }
            ListNode i = new ListNode();
            i.setValue((Object)results, 0L);
            return i;
        }
        return new Node();
    }

    @Override
    @Deprecated
    public String getFileEnding() {
        if (this.chooseExportFormat()) {
            if (this.getReportFormatType().equals((Object)ReportingOutputFormatE.PDF)) {
                return ".pdf";
            }
            if (this.getReportFormatType().equals((Object)ReportingOutputFormatE.XLSX)) {
                return ".xlsx";
            }
        }
        return ".xlsx";
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container arg0) {
            AnalysisPopupInsert.this.scrollPane.setLocation(0, 0);
            AnalysisPopupInsert.this.scrollPane.setSize(arg0.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension(350, 500);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (AnalysisPopupInsert.this.msg != null && AnalysisPopupInsert.this.msg.isVisible() && AnalysisPopupInsert.this.msg.getText() != null && !AnalysisPopupInsert.this.msg.getText().isEmpty()) {
                Dimension dim = AnalysisPopupInsert.this.msg.getPreferredSize();
                return new Dimension(dim.width + 2 * AnalysisPopupInsert.this.border, 2 * AnalysisPopupInsert.this.border + dim.height);
            }
            int h = 0;
            h += AnalysisPopupInsert.this.border;
            h = (int)((double)h + AnalysisPopupInsert.this.printTitle.getPreferredSize().getHeight());
            h += AnalysisPopupInsert.this.border;
            h = (int)((double)h + AnalysisPopupInsert.this.exportSelectionBox.getPreferredSize().getHeight());
            h += AnalysisPopupInsert.this.border;
            if (AnalysisPopupInsert.this.chooseExportFormat()) {
                h += AnalysisPopupInsert.this.border;
                h = (int)((double)h + AnalysisPopupInsert.this.printFormatTitle.getPreferredSize().getHeight());
                h += AnalysisPopupInsert.this.border;
                h = (int)((double)h + AnalysisPopupInsert.this.exportSelectionBox.getPreferredSize().getHeight());
                h += AnalysisPopupInsert.this.border;
            }
            if (AnalysisPopupInsert.this.isReportTypeChoosable) {
                h += AnalysisPopupInsert.this.border;
                h = (int)((double)h + AnalysisPopupInsert.this.styleSheetTitle.getPreferredSize().getHeight());
                h += AnalysisPopupInsert.this.border;
                h = (int)((double)h + AnalysisPopupInsert.this.reportTypeBox.getPreferredSize().getHeight());
                h += AnalysisPopupInsert.this.border;
            }
            if (AnalysisPopupInsert.this.table != null) {
                h += AnalysisPopupInsert.this.table.getHeight();
                h += AnalysisPopupInsert.this.border;
            } else if (AnalysisPopupInsert.this.numberField != null) {
                h = (int)((double)h + AnalysisPopupInsert.this.numberField.getPreferredSize().getHeight());
                h += AnalysisPopupInsert.this.border;
            }
            h += AnalysisPopupInsert.this.getCustomItemHeight();
            int w = (int)(AnalysisPopupInsert.this.exportSelectionBox.getPreferredSize().getWidth() + (double)(2 * AnalysisPopupInsert.this.border));
            if (AnalysisPopupInsert.this.chooseExportFormat()) {
                w = (int)(AnalysisPopupInsert.this.exportFormatSelectionBox.getPreferredSize().getWidth() + (double)(2 * AnalysisPopupInsert.this.border));
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = AnalysisPopupInsert.this.layoutInheritedComponents(parent);
            AnalysisPopupInsert.this.printTitle.setLocation(AnalysisPopupInsert.this.border, h + AnalysisPopupInsert.this.border);
            AnalysisPopupInsert.this.printTitle.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.printTitle.getPreferredSize().getHeight());
            AnalysisPopupInsert.this.exportSelectionBox.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.printTitle.getY() + AnalysisPopupInsert.this.printTitle.getHeight() + AnalysisPopupInsert.this.border);
            AnalysisPopupInsert.this.exportSelectionBox.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.exportSelectionBox.getPreferredSize().getHeight());
            int h2 = AnalysisPopupInsert.this.exportSelectionBox.getY() + AnalysisPopupInsert.this.exportSelectionBox.getHeight() + AnalysisPopupInsert.this.border;
            if (AnalysisPopupInsert.this.numberField != null) {
                if (AnalysisPopupInsert.this.expandIcon != null) {
                    AnalysisPopupInsert.this.numberField.setLocation((int)((double)AnalysisPopupInsert.this.border + AnalysisPopupInsert.this.expandIcon.getPreferredSize().getWidth() + (double)AnalysisPopupInsert.this.border), h2);
                    AnalysisPopupInsert.this.numberField.setSize((int)((double)AnalysisPopupInsert.this.exportSelectionBox.getWidth() - (3.0 + AnalysisPopupInsert.this.numberInfo.getPreferredSize().getWidth() + (double)AnalysisPopupInsert.this.border + AnalysisPopupInsert.this.expandIcon.getPreferredSize().getWidth())), (int)AnalysisPopupInsert.this.numberField.getPreferredSize().getHeight());
                    AnalysisPopupInsert.this.expandIcon.setLocation(AnalysisPopupInsert.this.border, (int)((double)(AnalysisPopupInsert.this.numberField.getY() + AnalysisPopupInsert.this.numberField.getHeight()) - AnalysisPopupInsert.this.expandIcon.getPreferredSize().getHeight() - 6.0));
                    AnalysisPopupInsert.this.expandIcon.setSize(AnalysisPopupInsert.this.expandIcon.getPreferredSize());
                } else {
                    AnalysisPopupInsert.this.numberField.setLocation(AnalysisPopupInsert.this.border, h2);
                    AnalysisPopupInsert.this.numberField.setSize((int)((double)AnalysisPopupInsert.this.exportSelectionBox.getWidth() - (3.0 + AnalysisPopupInsert.this.numberInfo.getPreferredSize().getWidth())), (int)AnalysisPopupInsert.this.numberField.getPreferredSize().getHeight());
                }
                AnalysisPopupInsert.this.numberInfo.setLocation(AnalysisPopupInsert.this.numberField.getX() + AnalysisPopupInsert.this.numberField.getWidth() + 3, (int)((double)(AnalysisPopupInsert.this.numberField.getY() + AnalysisPopupInsert.this.numberField.getHeight()) - AnalysisPopupInsert.this.numberInfo.getPreferredSize().getHeight() - 2.0));
                AnalysisPopupInsert.this.numberInfo.setSize(AnalysisPopupInsert.this.numberInfo.getPreferredSize());
                if (AnalysisPopupInsert.this.table != null) {
                    AnalysisPopupInsert.this.table.setSize(AnalysisPopupInsert.this.numberField.getWidth(), AnalysisPopupInsert.this.table.getHeight());
                    AnalysisPopupInsert.this.table.setLocation(AnalysisPopupInsert.this.numberField.getX(), AnalysisPopupInsert.this.numberField.getY());
                    h2 = AnalysisPopupInsert.this.table.getY() + AnalysisPopupInsert.this.table.getHeight() + AnalysisPopupInsert.this.border;
                } else {
                    h2 = AnalysisPopupInsert.this.numberField.getY() + AnalysisPopupInsert.this.numberField.getHeight() + AnalysisPopupInsert.this.border;
                }
            }
            if (AnalysisPopupInsert.this.chooseExportFormat()) {
                AnalysisPopupInsert.this.printFormatTitle.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.exportSelectionBox.getY() + AnalysisPopupInsert.this.exportSelectionBox.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.printFormatTitle.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.printFormatTitle.getPreferredSize().getHeight());
                AnalysisPopupInsert.this.exportFormatSelectionBox.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.printFormatTitle.getY() + AnalysisPopupInsert.this.printFormatTitle.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.exportFormatSelectionBox.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.exportFormatSelectionBox.getPreferredSize().getHeight());
                h2 = AnalysisPopupInsert.this.exportFormatSelectionBox.getY() + AnalysisPopupInsert.this.exportFormatSelectionBox.getHeight() + AnalysisPopupInsert.this.border;
            }
            if (AnalysisPopupInsert.this.isReportTypeChoosable && AnalysisPopupInsert.this.chooseExportFormat()) {
                AnalysisPopupInsert.this.styleSheetTitle.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.exportFormatSelectionBox.getY() + AnalysisPopupInsert.this.exportFormatSelectionBox.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.styleSheetTitle.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.styleSheetTitle.getPreferredSize().getHeight());
                AnalysisPopupInsert.this.reportTypeBox.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.styleSheetTitle.getY() + AnalysisPopupInsert.this.styleSheetTitle.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.reportTypeBox.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.reportTypeBox.getPreferredSize().getHeight());
                h2 = AnalysisPopupInsert.this.reportTypeBox.getY() + AnalysisPopupInsert.this.reportTypeBox.getHeight() + AnalysisPopupInsert.this.border;
            } else if (AnalysisPopupInsert.this.isReportTypeChoosable && !AnalysisPopupInsert.this.chooseExportFormat()) {
                AnalysisPopupInsert.this.styleSheetTitle.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.exportSelectionBox.getY() + AnalysisPopupInsert.this.exportSelectionBox.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.styleSheetTitle.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.styleSheetTitle.getPreferredSize().getHeight());
                AnalysisPopupInsert.this.reportTypeBox.setLocation(AnalysisPopupInsert.this.border, AnalysisPopupInsert.this.styleSheetTitle.getY() + AnalysisPopupInsert.this.styleSheetTitle.getHeight() + AnalysisPopupInsert.this.border);
                AnalysisPopupInsert.this.reportTypeBox.setSize(parent.getWidth() - 2 * AnalysisPopupInsert.this.border, (int)AnalysisPopupInsert.this.reportTypeBox.getPreferredSize().getHeight());
                h2 = AnalysisPopupInsert.this.reportTypeBox.getY() + AnalysisPopupInsert.this.reportTypeBox.getHeight() + AnalysisPopupInsert.this.border;
            }
            AnalysisPopupInsert.this.layoutCustomItems(parent, h2, parent.getWidth());
        }
    }
}

