/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.table.commiter.FileDownloader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killer;
import ch.icit.pegasus.client.gui.utils.PDFViewerScrollable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.loading.PDFDownloadProgressbar;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class PDFPreviewPopupInset
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private PDFViewerScrollable pdfViewer;
    private PDFDownloadProgressbar progress;
    private FileDownloader id;
    private boolean isProgress = false;
    private TextLabel msg;
    private TextButton openFile;
    private TextButton choosePDF;
    private TextButton deletePDF;
    private Node<DocumentScanComplete> node;
    private File originFile;

    public PDFPreviewPopupInset(boolean withOpenFile, boolean withChoosePDF, boolean withDeletePDF, Node<DocumentScanComplete> document) {
        this.node = document;
        this.pdfViewer = new PDFViewerScrollable();
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.setLayout(new Layout());
        if (withOpenFile) {
            this.openFile = new TextButton("Open File");
            this.openFile.addButtonListener(this);
            this.add(this.openFile);
        }
        if (withChoosePDF) {
            this.choosePDF = new TextButton("Choose File");
            this.choosePDF.addButtonListener(this);
            this.add(this.choosePDF);
        }
        if (withDeletePDF) {
            this.deletePDF = new TextButton("Delete File");
            this.deletePDF.addButtonListener(this);
            this.add(this.deletePDF);
        }
        this.add(this.pdfViewer);
        if (document != null && document.getValue() != null && ((DocumentScanComplete)document.getValue()).getFileData() != null) {
            this.progress = new PDFDownloadProgressbar(this);
            this.progress.stateChanged("Download Image");
            this.id = new FileDownloader(((DocumentScanComplete)document.getValue()).getFileData());
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    if (PDFPreviewPopupInset.this.id != null) {
                        PDFPreviewPopupInset.this.id.download(PDFPreviewPopupInset.this.progress);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return null;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            this.isProgress = true;
            this.add((Component)this.progress, -1);
            this.progress.start();
            this.progress.fadeIn();
            this.validate();
            SwingUtilities.invokeLater(() -> ThreadSafeLoader.run(run));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.choosePDF);
        CheckedListAdder.addToList(focusList, this.deletePDF);
        CheckedListAdder.addToList(focusList, this.openFile);
        return focusList;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.openFile != null) {
            this.openFile.setEnabled(isEnabled);
        }
        if (this.choosePDF != null) {
            this.choosePDF.setEnabled(isEnabled);
        }
        if (this.deletePDF != null) {
            this.deletePDF.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        Killer.kill(this.progress);
        Killer.kill(this.pdfViewer);
        Killer.kill(this.openFile);
        Killer.kill(this.choosePDF);
        Killer.kill(this.deletePDF);
        this.progress = null;
        this.pdfViewer = null;
        this.openFile = null;
        this.choosePDF = null;
        this.deletePDF = null;
        this.id = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        DocumentScanComplete value;
        if (source == this.openFile) {
            if (this.originFile != null) {
                try {
                    Desktop.getDesktop().open(this.originFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (source == this.choosePDF) {
            File file = FileChooserUtil.loadFile();
            DocumentScanComplete value2 = (DocumentScanComplete)this.node.getValue();
            if (value2 == null) {
                value2 = new DocumentScanComplete();
                value2.setClientOId(Long.valueOf(ADTO.getNextId()));
                this.node.setValue((Object)value2, 0L);
            }
            value2.setFileData(new PegasusFileComplete());
            value2.getFileData().setCategory(FileCategoryE.DOCUMENT);
            value2.getFileData().setLocalFile(file);
            this.originFile = file;
            this.isProgress = false;
            try {
                this.pdfViewer.showPDF(this.originFile);
            }
            catch (IOException e) {
                this.exception(e.getMessage());
            }
            this.revalidate();
        } else if (source == this.deletePDF && (value = (DocumentScanComplete)this.node.getValue()) != null) {
            value.setFileData(null);
            value.setContentAsText("");
            try {
                this.pdfViewer.showPDF(null);
            }
            catch (IOException e) {
                this.exception(e.getMessage());
            }
        }
    }

    public void pdfDownloaded(File pdfFile) {
        if (pdfFile != null) {
            this.originFile = pdfFile;
            this.isProgress = false;
            try {
                if (this.pdfViewer != null) {
                    this.pdfViewer.showPDF(pdfFile);
                }
            }
            catch (IOException e) {
                this.exception(e.getMessage());
            }
            this.revalidate();
        } else {
            this.exception("Unable to load PDF File. Please try again.");
        }
    }

    private void exception(String text) {
        if (this.msg == null) {
            this.msg = new TextLabel(text);
            this.msg.setProgress(1.0f);
            this.add((Component)this.msg, 0);
        } else {
            this.msg.setText(text);
        }
    }

    public void exceptionOccured() {
        this.exception("Unable to load PDF File. Please try again.");
        this.revalidate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (PDFPreviewPopupInset.this.msg != null) {
                PDFPreviewPopupInset.this.msg.setLocation((int)((double)parent.getWidth() - PDFPreviewPopupInset.this.msg.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - PDFPreviewPopupInset.this.msg.getPreferredSize().getHeight()) / 2.0));
                PDFPreviewPopupInset.this.msg.setSize(PDFPreviewPopupInset.this.msg.getPreferredSize());
            } else {
                PDFPreviewPopupInset.this.pdfViewer.setLocation(PDFPreviewPopupInset.this.border, PDFPreviewPopupInset.this.border);
                if (PDFPreviewPopupInset.this.openFile != null) {
                    PDFPreviewPopupInset.this.pdfViewer.setSize(parent.getWidth() - 2 * PDFPreviewPopupInset.this.border, (int)((double)parent.getHeight() - ((double)(3 * PDFPreviewPopupInset.this.border) + PDFPreviewPopupInset.this.openFile.getPreferredSize().getHeight())));
                } else if (PDFPreviewPopupInset.this.choosePDF != null) {
                    PDFPreviewPopupInset.this.pdfViewer.setSize(parent.getWidth() - 2 * PDFPreviewPopupInset.this.border, (int)((double)parent.getHeight() - ((double)(3 * PDFPreviewPopupInset.this.border) + PDFPreviewPopupInset.this.choosePDF.getPreferredSize().getHeight())));
                } else if (PDFPreviewPopupInset.this.deletePDF != null) {
                    PDFPreviewPopupInset.this.pdfViewer.setSize(parent.getWidth() - 2 * PDFPreviewPopupInset.this.border, (int)((double)parent.getHeight() - ((double)(3 * PDFPreviewPopupInset.this.border) + PDFPreviewPopupInset.this.deletePDF.getPreferredSize().getHeight())));
                } else {
                    PDFPreviewPopupInset.this.pdfViewer.setSize(parent.getWidth() - 2 * PDFPreviewPopupInset.this.border, parent.getHeight() - 2 * PDFPreviewPopupInset.this.border);
                }
                if (PDFPreviewPopupInset.this.openFile != null) {
                    PDFPreviewPopupInset.this.openFile.setLocation((int)((double)parent.getWidth() - (5.0 + PDFPreviewPopupInset.this.openFile.getPreferredSize().getWidth())), PDFPreviewPopupInset.this.pdfViewer.getHeight() + 5);
                    PDFPreviewPopupInset.this.openFile.setSize(PDFPreviewPopupInset.this.openFile.getPreferredSize());
                }
                if (PDFPreviewPopupInset.this.choosePDF != null) {
                    PDFPreviewPopupInset.this.choosePDF.setLocation(5, PDFPreviewPopupInset.this.pdfViewer.getHeight() + 5);
                    PDFPreviewPopupInset.this.choosePDF.setSize(PDFPreviewPopupInset.this.choosePDF.getPreferredSize());
                }
                if (PDFPreviewPopupInset.this.deletePDF != null) {
                    PDFPreviewPopupInset.this.deletePDF.setLocation(PDFPreviewPopupInset.this.choosePDF.getX() + PDFPreviewPopupInset.this.choosePDF.getWidth() + 5, PDFPreviewPopupInset.this.pdfViewer.getHeight() + 5);
                    PDFPreviewPopupInset.this.deletePDF.setSize(PDFPreviewPopupInset.this.deletePDF.getPreferredSize());
                }
            }
            if (PDFPreviewPopupInset.this.isProgress) {
                PDFPreviewPopupInset.this.progress.setLocation((int)(((double)parent.getWidth() - PDFPreviewPopupInset.this.progress.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - PDFPreviewPopupInset.this.progress.getPreferredSize().getHeight()) / 2);
                PDFPreviewPopupInset.this.progress.setSize(PDFPreviewPopupInset.this.progress.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

