/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.EnterListener;
import ch.icit.pegasus.client.gui.utils.Enterable;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.TextUtils;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxCellRenderer;
import ch.icit.pegasus.client.gui.utils.combobox.CustomScrollBarUI;
import ch.icit.pegasus.client.gui.utils.combobox.SortedComboBoxModel;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.popup.MouseConsumer;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboBox
extends JComboBox
implements LafListener,
NodeListener,
Fadable,
Movable,
AttributeListener,
ItemListener,
Focusable,
Killable,
ImageConsumer,
FocusListener,
Validatable,
UIStateLoadable,
Stringable,
Nodable,
Enterable,
MouseConsumer {
    private static final Logger log = LoggerFactory.getLogger(ComboBox.class);
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private final List<EnterListener> enterListener = new ArrayList<EnterListener>();
    private Class<?> nodeCommittingClass;
    protected boolean isKilled = false;
    private boolean isPersistable = true;
    private Object defaultSelection;
    private String defaultComboChooseText;
    private JButton currentButton;
    private long currentUnDoId = 0L;
    private boolean isIgnoreMinimalWidth;
    protected static int minimalWidth = 0;
    private static int defaultInset;
    private AlphaFader<ComboBox> fader;
    private Mover<ComboBox> mover;
    private boolean isContentValid = true;
    protected ScrollComboPopup currentPopUp;
    private static BufferedImage image_up_1;
    private static BufferedImage image_up_2;
    private static BufferedImage image_up_3;
    private static BufferedImage image_down_1;
    private static BufferedImage image_down_2;
    private static BufferedImage image_down_3;
    private static BufferedImage image_over_1;
    private static BufferedImage image_over_2;
    private static BufferedImage image_over_3;
    private static BufferedImage image_focus_1;
    private static BufferedImage image_focus_2;
    private static BufferedImage image_focus_3;
    private static BufferedImage image_disabled_1;
    private static BufferedImage image_disabled_2;
    private static BufferedImage image_disabled_3;
    private static BufferedImage image_error_1;
    private static BufferedImage image_error_2;
    private static BufferedImage image_error_3;
    private static boolean isInit;
    public static Color popUpBackgroundColor;
    public static Color popUpForegroundColor;
    public static Color popUpSelectedBackgroundColor;
    public static Color popUpSelectedForegroundColor;
    public static Font popUpItemFont;
    private List<ItemListener> itemListeners = new ArrayList<ItemListener>();
    public static Color defaultForeground;
    public static Color disabledForeground;
    private boolean isUpdatingStructure = false;
    private Node node;
    private Converter converterIReadableNodePossibleValue;
    private Converter possibleValue2Node;
    private Converter viewConverter;
    private Node possibleValues;
    private boolean isProxyNodeAction = false;
    private boolean isNullable = false;
    private List<Node> affectedNodes = new ArrayList<Node>();
    private ListCellRenderer listCellRenderer;
    private VisibleContainer visibleContainer;
    private AWTEventListener keyListener;
    private boolean useConverter;
    private boolean ignoreSorting;

    public ComboBox(Node allValues) {
        this();
        Iterator it = allValues.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.addItem(n);
        }
    }

    public ComboBox() {
        this(true);
    }

    public ComboBox(boolean sorted) {
        this.init(sorted);
        this.setEnabled(true);
        this.setUI(new ComboBoxUI());
        this.setOpaque(false);
        this.defaultComboChooseText = Words.CHOOSE_WITH_POINTS;
        this.mover = new Mover<ComboBox>(this);
        this.fader = new AlphaFader<ComboBox>(this, false);
        this.fader.setDisableWhenHidden(true);
        this.setProgress(1.0f);
        this.attributeChanged("All attributes changed");
    }

    public void setIgnoreSorting(boolean ignoreSorting) {
        this.ignoreSorting = ignoreSorting;
    }

    public void setUseConverter(boolean b) {
        this.useConverter = b;
    }

    @Override
    public String getPersistString() {
        return "" + this.getSelectedIndex();
    }

    @Override
    public void loadState(String state, String id) {
        int i = Integer.valueOf(state);
        if (i < this.getItemCount()) {
            this.setSelectedIndex(i);
        }
    }

    @Override
    public String getStringValue() {
        return (String)this.viewConverter.convert(this.node.getValue(), this.node, new Object[0]);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.requestFocusInWindow();
    }

    public void setConverN2A(Converter c) {
        this.converterIReadableNodePossibleValue = c;
    }

    public void setConverterA2N(Converter c) {
        this.possibleValue2Node = c;
    }

    public Converter getConverteA2N() {
        return this.possibleValue2Node;
    }

    public Converter getConverterN2A() {
        return this.converterIReadableNodePossibleValue;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    public void insertItem(Object o) {
        if (this.viewConverter != null) {
            String t = (String)this.viewConverter.convert(o, null, new Object[0]);
            this.addItem(t);
        } else {
            this.addItem(o);
        }
    }

    public void setViewConverter(Converter c) {
        this.viewConverter = c;
    }

    public Converter getViewConverter() {
        return this.viewConverter;
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        if (this.itemListeners == null) {
            super.addItemListener(aListener);
            return;
        }
        if (!this.itemListeners.contains(aListener)) {
            this.itemListeners.add(aListener);
            super.addItemListener(aListener);
        }
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        if (this.itemListeners != null) {
            this.itemListeners.remove(aListener);
        }
        super.removeItemListener(aListener);
    }

    public void setComparator(Comparator comp) {
        if (comp != null) {
            ((SortedComboBoxModel)this.getModel()).setComparator(comp);
        }
    }

    public ComboBox(Node node, Node possibleValues, Converter IReadableNodePossibleValue, Converter possibleValue2Node, Converter viewConverter, boolean nullValue, boolean isProxyAction) {
        this(node, possibleValues, IReadableNodePossibleValue, possibleValue2Node, viewConverter, nullValue, isProxyAction, false, null);
    }

    public ComboBox(Node node, Node possibleValues, Converter IReadableNodePossibleValue, Converter possibleValue2Node, Converter viewConverter, boolean nullValue) {
        this(node, possibleValues, IReadableNodePossibleValue, possibleValue2Node, viewConverter, nullValue, false);
    }

    public ComboBox(Node node, Node possibleValues, Converter viewConverter, boolean nullable) {
        this(node, possibleValues, ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), viewConverter, nullable);
    }

    public ComboBox(Node node, Node possibleValues, Converter viewConverter, boolean nullable, boolean proxy) {
        this(node, possibleValues, ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), viewConverter, nullable, proxy);
    }

    public ComboBox(Node node, Node possibleValues, Converter viewConverter) {
        this(node, possibleValues, ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), viewConverter);
    }

    public ComboBox(Node node, Node possibleValues, Converter node2PossibleValue, Converter possibleValue2Node, Converter viewConverter) {
        this(node, possibleValues, node2PossibleValue, possibleValue2Node, viewConverter, false);
    }

    public ComboBox(Node node, Node possibleValues, Converter IReadableNodePossibleValue, Converter possibleValue2Node, Converter viewConverter, Comparator comp) {
        this(node, possibleValues, IReadableNodePossibleValue, possibleValue2Node, viewConverter, false, false, false, comp);
    }

    public ComboBox(Node node, Node possibleValues, Converter IReadableNodePossibleValue, Converter possibleValue2Node, Converter viewConverter, boolean nullValue, boolean isProxyAction, boolean isUpdateStructure, Comparator comp) {
        this();
        if (comp != null) {
            ((SortedComboBoxModel)this.getModel()).setComparator(comp);
        }
        this.isUpdatingStructure = isUpdateStructure;
        this.isProxyNodeAction = isProxyAction;
        this.possibleValue2Node = possibleValue2Node;
        this.converterIReadableNodePossibleValue = IReadableNodePossibleValue;
        this.viewConverter = viewConverter;
        this.possibleValues = possibleValues;
        this.removeItemListener(this);
        if (nullValue) {
            this.isNullable = true;
            this.addItem("");
        }
        if (this.possibleValues != null) {
            this.getAllChildAddEvents();
            this.possibleValues.addNodeListener((NodeListener)this);
            this.addItemListener(this);
        }
        this.setNode(node);
    }

    private void getAllChildAddEvents() {
        Node[] ps;
        for (Node n : ps = this.possibleValues.getChildsAsArray()) {
            n.setConverter(this.viewConverter);
        }
        if (this.getModel() instanceof SortedComboBoxModel) {
            Comparator<Node> comp = new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    Object v2;
                    Object v1 = ComboBox.this.getNodeCommittingClass() != null ? o1.getValue(ComboBox.this.getNodeCommittingClass()) : o1.getValue();
                    Object object = v2 = ComboBox.this.getNodeCommittingClass() != null ? o2.getValue(ComboBox.this.getNodeCommittingClass()) : o2.getValue();
                    if (v1 instanceof Comparable && v2 instanceof Comparable) {
                        try {
                            return ((Comparable)v1).compareTo(v2);
                        }
                        catch (Exception e) {
                            log.error("Error while get Children", (Throwable)e);
                        }
                    }
                    v1 = o1.getFormattedValue();
                    v2 = o2.getFormattedValue();
                    if (v1 == null) {
                        return v2 == null ? 0 : -1;
                    }
                    if (v2 == null) {
                        return 1;
                    }
                    if (v1 instanceof Comparable) {
                        return ((Comparable)v1).compareTo(v2);
                    }
                    return 0;
                }
            };
            if (!this.ignoreSorting) {
                this.possibleValues.sortChilds((Comparator)comp);
            }
            this.initModel(this.possibleValues.getChildsAsArray());
        } else if (this.getModel() instanceof DefaultComboBoxModel) {
            this.initModel(this.possibleValues.getChildsAsArray());
        } else {
            throw new IllegalStateException();
        }
        if (this.isNullable) {
            this.addItem("");
        }
    }

    public void initModel(Node[] nodes) {
        if (this.getModel() instanceof SortedComboBoxModel) {
            SortedComboBoxModel m = new SortedComboBoxModel(nodes);
            super.setModel(m);
        } else if (this.getModel() instanceof DefaultComboBoxModel) {
            super.setModel(new DefaultComboBoxModel<Node>(nodes));
        }
    }

    public static Node getPossiblesWithNull(Node posses) {
        ViewNode n = new ViewNode("");
        n.addChild(new Node(), 0L);
        Iterator it = posses.getChilds();
        while (it.hasNext()) {
            n.addChild((Node)it.next(), 0L);
        }
        return n;
    }

    public void setModel(ComboBoxModel aModel) {
        super.setModel(aModel);
        if (this.possibleValues != null) {
            this.refreshPossibleValues(this.possibleValues);
        }
    }

    public void setNode(Node node) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (this.node != null) {
            this.isProxyNodeAction = this.node instanceof ProxyNode;
            this.node.addNodeListener((NodeListener)this);
            this.initNode();
        }
    }

    public boolean isProxyNodeAction() {
        return this.isProxyNodeAction;
    }

    public void setProxyNodeAction(boolean isProxyNodeAction) {
        this.isProxyNodeAction = isProxyNodeAction;
    }

    public void addAffectedNode(Node n) {
        this.affectedNodes.add(n);
    }

    public List<Node> getAffectedNodes() {
        return this.affectedNodes;
    }

    private void initNode() {
        if (this.node == null) {
            return;
        }
        if (this.node.getValue() == null && !this.isNullable) {
            this.writeSelection2Node(this.getSelectedItem());
        } else {
            this.removeItemListener(this);
            this.selectValueInList();
            this.addItemListener(this);
        }
    }

    public void updateSelectableValues(List usedObjects) {
        List p = (List)((ArrayList)usedObjects).clone();
        if (this.getSelectedItem() instanceof Node) {
            Node m = (Node)this.getSelectedItem();
            Object selectedItem = null;
            for (Object o : p) {
                Node n = (Node)o;
                if (m == null || !n.getValue().equals(m.getValue())) continue;
                selectedItem = o;
            }
        }
        ((ComboBoxCellRenderer)this.getRenderer()).setUsedItems(p);
    }

    public ScrollComboPopup getCurrentPopUp() {
        return this.currentPopUp;
    }

    public String getCurrentPopUpName() {
        return this.currentPopUp.getName();
    }

    public void setListCellRenderer(ListCellRenderer cellRenderer) {
        this.listCellRenderer = cellRenderer;
    }

    public void selectItem(Object i) {
        if (this.viewConverter != null) {
            Object o = this.viewConverter.convert(i, null, new Object[0]);
            if (o != null) {
                this.setSelectedItem(o);
            }
        } else {
            this.setSelectedItem(i);
        }
    }

    public long getCurrentUnDoId() {
        return this.currentUnDoId;
    }

    public void setCurrentUnDoId(long currentUnDoId) {
        this.currentUnDoId = currentUnDoId;
    }

    private void selectValueInList() {
        if (this.node == null) {
            return;
        }
        if (this.converterIReadableNodePossibleValue == null) {
            return;
        }
        Object o = this.converterIReadableNodePossibleValue.convert(this.node.getValue(), this.node, new Object[0]);
        if (o == null) {
            this.setSelectedItem("");
            return;
        }
        this.removeItemListener(this);
        if (o instanceof Node) {
            o = ((Node)o).getValue();
        }
        if (this.possibleValues != null) {
            try {
                Iterator it = this.possibleValues.getChilds();
                while (it.hasNext()) {
                    Node v = (Node)it.next();
                    if (v.getValue() != null && !this.useConverter) {
                        if (!v.getValue().equals(o)) continue;
                        this.setSelectedItem(v);
                        if (o != null) {
                            this.addItemListener(this);
                        }
                        return;
                    }
                    Object n = v.getValue();
                    if (n instanceof Node) {
                        n = ((Node)n).getValue();
                    }
                    if (!o.equals(n)) continue;
                    this.setSelectedItem(v);
                    if (o != null) {
                        this.addItemListener(this);
                    }
                    return;
                }
            }
            catch (Exception e) {
                log.error("Unable to calculate", (Throwable)e);
            }
            if (o != null) {
                Node n = null;
                if (this.possibleValues.getChildCount() > 0) {
                    try {
                        n = this.possibleValues.getChildAt(0);
                        this.setSelectedItem(n);
                        this.node.setValueSilent(n.getValue(), false, 0L, new NodeListener[]{this});
                    }
                    catch (Exception e) {
                        log.error("Unable to calculate amounts", (Throwable)e);
                    }
                } else {
                    this.setSelectedItem(null);
                }
                this.addItemListener(this);
                return;
            }
            this.writeSelection2Node(this.getSelectedItem());
        } else if (o != null) {
            this.addItemListener(this);
        }
    }

    public void setPossibleValues(Node newValues) {
        this.refreshPossibleValues(newValues);
    }

    public void refreshPossibleValues(Node newValues) {
        this.removeItemListener(this);
        this.removeAllItems();
        this.addItemListener(this);
        if (this.possibleValues != null) {
            this.possibleValues.removeNodeListener((NodeListener)this);
        }
        this.possibleValues = newValues;
        if (this.possibleValues != null) {
            this.removeItemListener(this);
            if (this.isNullable) {
                this.addItem("");
            }
            if (this.defaultSelection != null) {
                this.addItem(this.defaultSelection);
            }
            this.getAllChildAddEvents();
            this.possibleValues.addNodeListener((NodeListener)this);
            this.addItemListener(this);
        }
        this.initNode();
        if (this.getSelectedItem() != null) {
            this.fireItemStateChanged(new ItemEvent(this, 0, this.getSelectedItem(), 1));
        } else {
            this.fireItemStateChanged(new ItemEvent(this, 0, null, 2));
        }
    }

    private void writeSelection2Node(Object selectedItem) {
        if (selectedItem == null || this.node == null) {
            return;
        }
        if (this.possibleValues != null) {
            boolean isUnDoIdSet = true;
            if (this.currentUnDoId == 0L) {
                isUnDoIdSet = false;
                this.currentUnDoId = System.currentTimeMillis();
            }
            if (selectedItem.equals("") || selectedItem.equals(Words.ALL)) {
                boolean isProxy = false;
                if (this.node instanceof ProxyNode) {
                    isProxy = true;
                    ((ProxyNode)this.node).setRefNode(null);
                    this.node.setValue(null, this.currentUnDoId);
                } else {
                    this.node.setValueSilent(null, false, this.currentUnDoId, new NodeListener[]{this});
                    this.node.updateNode();
                }
            } else {
                Node n = (Node)selectedItem;
                Object o = this.possibleValue2Node.convert(n.getValue(), n, new Object[0]);
                boolean isProxy = false;
                if (this.node instanceof ProxyNode) {
                    isProxy = true;
                }
                if (isProxy) {
                    ((ProxyNode)this.node).setValue(n.getValue(), 0L);
                    for (Node aNode : this.affectedNodes) {
                        if (aNode instanceof ProxyNode) {
                            ((ProxyNode)aNode).setRefNodeSilent(n, false, new NodeListener[]{this});
                            continue;
                        }
                        aNode.setValue(o, this.currentUnDoId);
                        aNode.updateNode();
                    }
                } else {
                    if (this.node instanceof Node) {
                        this.node.removeExistingValues();
                        this.node.setValueSilent(o, false, this.currentUnDoId, new NodeListener[]{this});
                        this.node.updateNode();
                    }
                    for (Node aNode : this.affectedNodes) {
                        if (!(aNode instanceof Node)) continue;
                        this.node.removeExistingValues();
                        aNode.setValue(o, this.currentUnDoId);
                        aNode.updateNode();
                    }
                }
                if (!isUnDoIdSet) {
                    this.currentUnDoId = 0L;
                }
            }
        }
    }

    public void setIgnoreMinimalWidth(boolean isIgnore) {
        this.isIgnoreMinimalWidth = isIgnore;
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.deregisterKey();
        this.fader.kill();
        this.fader = null;
        this.mover.deregister();
        this.mover = null;
        if (this.currentPopUp != null) {
            this.currentPopUp = null;
        }
        this.itemListeners.clear();
        this.itemListeners = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = null;
        this.converterIReadableNodePossibleValue = null;
        this.possibleValue2Node = null;
        this.viewConverter = null;
        this.possibleValues = null;
        this.affectedNodes.clear();
        this.affectedNodes = null;
        this.listCellRenderer = null;
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }

    public AlphaFader<ComboBox> getFader() {
        return this.fader;
    }

    private void init(boolean sorted) {
        if (sorted) {
            this.setModel((ComboBoxModel)new SortedComboBoxModel());
        }
        this.setRenderer(new ComboBoxCellRenderer());
        this.addFocusListener(this);
        if (!isInit) {
            isInit = true;
            this.lafAttributeChanged("All attribues changed");
        } else {
            this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("comboBox_font_size"), LafLoader.getLafLoader().getAttribute("comboBox_font_type")));
        }
        this.addItemListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.fader);
        super.paint(g2);
    }

    protected void repaintComboBox() {
        this.repaint(32L);
    }

    public Node getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, image_disabled_1.getHeight());
    }

    public Node getNode() {
        return this.node;
    }

    public Object getDefaultObject() {
        return this.defaultSelection;
    }

    public void setDefaultIndex(Object defaultIndex) {
        this.defaultSelection = defaultIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("comboBox_font_size"), LafLoader.getLafLoader().getAttribute("comboBox_font_type")));
    }

    public Object getNodeValue() {
        if (this.node == null) {
            return null;
        }
        return this.node.getValue();
    }

    public Object getFormattedNodeValue() {
        if (this.node == null) {
            return "";
        }
        return this.node.getFormattedValue();
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.possibleValues) {
            child.setConverter(this.viewConverter);
            for (int i = 0; i < this.getItemCount(); ++i) {
                Node n;
                if (!(this.getItemAt(i) instanceof Node) || !(n = (Node)this.getItemAt(i)).toString().equals(child.toString())) continue;
                return;
            }
            this.addItem(child);
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (source == this.possibleValues) {
            this.removeItem(child);
            if (this.getItemCount() == 0 && this.node != null) {
                this.node.setValue(null, System.currentTimeMillis());
            }
        }
    }

    public void valueChanged(Node<?> node) {
        if (node == this.node) {
            this.selectValueInList();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension s = super.getPreferredSize();
        if (this.isIgnoreMinimalWidth) {
            return s;
        }
        if (s.getWidth() < (double)minimalWidth) {
            s.setSize((double)minimalWidth, s.getHeight());
        }
        return s;
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean isDestroy) {
        this.fader.fadeOut(isDestroy);
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    public Class<?> getNodeCommittingClass() {
        return this.nodeCommittingClass;
    }

    public void setNodeCommittingClass(Class<?> nodeCommittingClass) {
        this.nodeCommittingClass = nodeCommittingClass;
    }

    private void registerKey() {
        if (this.keyListener == null) {
            this.keyListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    KeyEvent ke;
                    if (!(!(event instanceof KeyEvent) || (ke = (KeyEvent)event).getID() != 401 || ke.isConsumed() || ke.getKeyCode() != 10 || ComboBox.this.currentPopUp != null && ComboBox.this.currentPopUp.isVisible())) {
                        ke.consume();
                        ComboBox.this.enterPressed();
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void deregisterKey() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
        this.keyListener = null;
    }

    public Mover<ComboBox> getMover() {
        return this.mover;
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType t) {
        return this.fader.isAnimating(t);
    }

    @Override
    public void attributeChanged(String attributeName) {
        String tee = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_unittext");
        minimalWidth = this.getFontMetrics(this.getFont()).stringWidth(tee);
        minimalWidth += image_disabled_1.getWidth() + image_disabled_3.getWidth();
        defaultInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("combobox_default_inset"));
        this.repaint(32L);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            boolean hasToReselect = false;
            if (e.getItem() != this.getSelectedItem()) {
                hasToReselect = true;
            }
            this.writeSelection2Node(e.getItem());
            if (hasToReselect) {
                this.setSelectedItem(e.getItem());
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this);
        return a;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void loadImages() {
        image_up_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.up"));
        image_up_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.up"));
        image_up_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.up"));
        image_down_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.down"));
        image_down_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.down"));
        image_down_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.down"));
        image_over_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.over"));
        image_over_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.over"));
        image_over_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.over"));
        image_focus_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.focus"));
        image_focus_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.focus"));
        image_focus_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.focus"));
        image_disabled_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.disabled"));
        image_disabled_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.disabled"));
        image_disabled_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.disabled"));
        image_error_1 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.11.error"));
        image_error_2 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.12.error"));
        image_error_3 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("texture.combobox.image.13.error"));
        defaultForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("comboBox_foreground_color"));
        disabledForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        popUpBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.color"));
        popUpForegroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.ok.color"));
        popUpSelectedBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.selected.ok.color"));
        popUpSelectedForegroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.selected.ok.color"));
        popUpItemFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("comboBox_popUpList_font_size"), LafLoader.getLafLoader().getAttribute("comboBox_popUpList_font_type"));
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public void focusGained(FocusEvent e) {
        SelectionManager.getSelectionManager().focusGained(this);
        this.registerKey();
        if (!(this.currentButton == null || this.currentButton.getModel() == null || this.currentButton.getModel().isRollover() || this.visibleContainer == null || this.fader != null && this.fader.isAnimating(AlphaFader.FadeType.FadeOut))) {
            this.visibleContainer.scrollTo(this);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.deregisterKey();
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setInvalid() {
        this.isContentValid = false;
        this.repaint(32L);
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void setValid() {
        this.isContentValid = true;
        this.repaint(32L);
    }

    @Override
    public void clearImages() {
        image_up_1 = null;
        this.loadImages();
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    private void enterPressed() {
        for (EnterListener l : this.enterListener) {
            l.enterPressed(this);
        }
    }

    @Override
    public void addEnterListener(EnterListener listener) {
        this.enterListener.add(listener);
    }

    @Override
    public void removeEnterListener(EnterListener listener) {
        this.enterListener.remove(listener);
    }

    public boolean isSwingOnly() {
        return true;
    }

    public String getDefaultComboChooseText() {
        return this.defaultComboChooseText;
    }

    public void setDefaultComboChooseText(String defaultComboChooseText) {
        this.defaultComboChooseText = defaultComboChooseText;
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    static {
        isInit = false;
    }

    class ScrollComboPopup
    extends BasicComboPopup {
        private JScrollPane currentScrollPanel;

        public ScrollComboPopup(JComboBox combo) {
            super(combo);
            if (ComboBox.this.listCellRenderer != null) {
                this.list.setCellRenderer(ComboBox.this.listCellRenderer);
            }
            this.list.setSelectionBackground(popUpSelectedBackgroundColor);
            this.list.setSelectionForeground(popUpSelectedForegroundColor);
        }

        protected JList createList() {
            return new JList(this.comboBox.getModel()){

                @Override
                public void processMouseEvent(MouseEvent e) {
                    int index = this.locationToIndex(new Point(e.getX(), e.getY()));
                    Object currentItem = ComboBox.this.getItemAt(index);
                    if (((ComboBoxCellRenderer)ComboBox.this.getRenderer()).isInList(currentItem)) {
                        e.consume();
                    } else {
                        super.processMouseEvent(e);
                    }
                }
            };
        }

        @Override
        protected JScrollPane createScroller() {
            JScrollPane pane = new JScrollPane(this.list, 20, 30);
            pane.setBackground(popUpBackgroundColor);
            pane.setBorder(BorderFactory.createEmptyBorder());
            pane.getHorizontalScrollBar().setUI(new CustomScrollBarUI(0));
            pane.getVerticalScrollBar().setUI(new CustomScrollBarUI(1));
            pane.getHorizontalScrollBar().setOpaque(false);
            pane.getVerticalScrollBar().setOpaque(false);
            this.currentScrollPanel = pane;
            return pane;
        }
    }

    private class ComboBoxButton
    extends JButton
    implements MouseListener {
        public ComboBoxButton() {
            this.addMouseListener(this);
            this.setFocusable(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComboBox.this.repaintComboBox();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ComboBox.this.repaintComboBox();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ComboBox.this.repaintComboBox();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    protected class ComboBoxUI
    extends BasicComboBoxUI {
        protected ComboBoxUI() {
        }

        @Override
        protected JButton createArrowButton() {
            ComboBoxButton button = new ComboBoxButton(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(image_up_3.getWidth(), image_up_3.getHeight());
                }

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    BufferedImage currentImage = null;
                    if (ComboBox.this.isContentValid) {
                        if (this.getModel().isEnabled()) {
                            currentImage = image_up_3;
                            if (ComboBoxUI.this.comboBox.hasFocus()) {
                                currentImage = image_focus_3;
                            } else if (this.getModel().isPressed()) {
                                currentImage = image_down_3;
                            } else if (this.getModel().isRollover()) {
                                currentImage = image_over_3;
                            }
                        } else {
                            currentImage = image_disabled_3;
                        }
                    } else {
                        currentImage = image_error_3;
                    }
                    g2.drawImage(currentImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
                }
            };
            button.setOpaque(false);
            button.setFocusable(false);
            ComboBox.this.currentButton = button;
            return button;
        }

        @Override
        protected ComboPopup createPopup() {
            ScrollComboPopup cpp = new ScrollComboPopup(this.comboBox);
            cpp.getList().setBackground(popUpBackgroundColor);
            cpp.getList().setFont(popUpItemFont);
            cpp.getList().setForeground(popUpForegroundColor);
            ComboBox.this.currentPopUp = cpp;
            return cpp;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(0, image_up_3.getHeight());
        }

        @Override
        public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.clip(bounds);
            if (ComboBox.this.isEnabled()) {
                g2.setColor(defaultForeground);
            } else {
                g2.setColor(disabledForeground);
            }
            g2.setFont(ComboBox.this.getFont());
            String t = "";
            t = ComboBox.this.node != null && ComboBox.this.node.getValue() == null ? (ComboBox.this.getSelectedItem() != null ? ComboBox.this.getSelectedItem().toString() : TextUtils.cutString(ComboBox.this.getDefaultComboChooseText(), (int)(bounds.getWidth() - (double)(2 * defaultInset + image_up_1.getWidth())), ComboBox.this.getFont(), ComboBox.this)) : (this.comboBox.getSelectedItem() != null ? (this.comboBox.getSelectedItem() instanceof String && this.comboBox.getSelectedItem().equals("") ? TextUtils.cutString(ComboBox.this.getDefaultComboChooseText(), (int)(bounds.getWidth() - (double)(2 * defaultInset + image_up_1.getWidth())), ComboBox.this.getFont(), ComboBox.this) : TextUtils.cutString(this.comboBox.getSelectedItem().toString(), (int)(bounds.getWidth() - (double)(2 * defaultInset + image_up_1.getWidth())), ComboBox.this.getFont(), ComboBox.this)) : TextUtils.cutString(ComboBox.this.getDefaultComboChooseText(), (int)(bounds.getWidth() - (double)(2 * defaultInset + image_up_1.getWidth())), ComboBox.this.getFont(), ComboBox.this));
            g2.drawString(t, (int)bounds.getX() + image_up_1.getWidth() + defaultInset, (int)(bounds.getHeight() + (double)g2.getFont().getSize()) / 2 - 2);
        }

        @Override
        public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BufferedImage image_1 = image_up_1;
            BufferedImage image_2 = image_up_2;
            if (ComboBox.this.isContentValid) {
                if (this.arrowButton.getModel().isEnabled()) {
                    if (hasFocus) {
                        image_1 = image_focus_1;
                        image_2 = image_focus_2;
                    } else if (this.arrowButton.getModel().isRollover()) {
                        image_1 = image_over_1;
                        image_2 = image_over_2;
                    } else if (this.arrowButton.getModel().isPressed()) {
                        image_1 = image_down_1;
                        image_2 = image_down_2;
                    }
                } else {
                    image_1 = image_disabled_1;
                    image_2 = image_disabled_2;
                }
            } else {
                image_1 = image_error_1;
                image_2 = image_error_2;
            }
            g2.drawImage(image_1, new AffineTransform(1.0, 0.0, 0.0, 1.0, bounds.getX(), bounds.getY()), null);
            Rectangle rect = new Rectangle(0, 0, image_2.getWidth(), image_2.getHeight());
            g2.setPaint(new TexturePaint(image_2, rect));
            g2.fillRect((int)(bounds.getX() + (double)image_1.getWidth()), (int)bounds.getY(), (int)(bounds.getWidth() - (double)image_1.getWidth()), (int)bounds.getHeight());
        }
    }
}

