/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda;

import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.awt.Point;
import java.sql.Time;
import java.util.Date;

public class TimedComponentUtil {
    private final WeeklyPlanSettingsComplete settings;
    private final int dayStartY = 30;
    private final double minRasterMinutes = 5.0;

    public TimedComponentUtil(WeeklyPlanSettingsComplete settings) {
        this.settings = settings;
    }

    public int calculateYPositionForTime(Time time, int totalHeight) {
        if (time.before(this.settings.getDayStart()) || time.after(this.settings.getDayEnd())) {
            throw new IllegalStateException("Timed Component outside of window => may be shift it => also have to change scheduled time than");
        }
        int startY = 30;
        int endY = totalHeight;
        int heightDif = endY - startY;
        Time dayStartTime = this.settings.getDayStart();
        Time dayEndTime = new Time(this.settings.getDayEnd().getTime() + 3600000L);
        long dayDuration = dayEndTime.getTime() - dayStartTime.getTime();
        long taskTimeSinceDayStart = time.getTime() - dayStartTime.getTime();
        double dayFractionSinceStart = (double)taskTimeSinceDayStart / (double)dayDuration;
        int newY = (int)((double)heightDif * dayFractionSinceStart);
        return newY + startY;
    }

    public int calculateHeightForDuration(long duration, int totalHeight) {
        int startY = 30;
        int endY = totalHeight;
        int heightDif = endY - startY;
        Time dayStartTime = this.settings.getDayStart();
        Time dayEndTime = new Time(this.settings.getDayEnd().getTime() + 3600000L);
        long dayDuration = dayEndTime.getTime() - dayStartTime.getTime();
        int newHeight = (int)((double)heightDif / (double)dayDuration * (double)duration);
        return newHeight;
    }

    public Point snapPosition(int x, int y, int totalHeight) {
        Time newTime = this.calculateTimeForYPosition(y, totalHeight);
        long oneHour = 3600000L;
        int minuteOfHour = DateUtil.getMinuteOfHour((Date)newTime);
        int quarter = (int)Math.round((double)minuteOfHour / 5.0);
        if ((double)quarter == (double)oneHour / 5.0) {
            int hourOfDay = DateUtil.getHourOfDay((Date)newTime);
            newTime = DateUtil.getSQLTime((int)(++hourOfDay), (int)0, (int)0);
        }
        int newMinute = (int)((double)(quarter %= (int)((double)oneHour / 5.0)) * 5.0);
        newTime = DateUtil.getSQLTime((int)DateUtil.getHourOfDay((Date)newTime), (int)newMinute, (int)0);
        int newY = this.calculateYPositionForTime(newTime, totalHeight);
        return new Point(x, newY);
    }

    public Time calculateTimeForYPosition(int y, int totalHeight) {
        if (y < 30 || y > totalHeight) {
            return null;
        }
        int startY = 30;
        int endY = totalHeight;
        int heightDif = endY - startY;
        Time dayStartTime = this.settings.getDayStart();
        Time dayEndTime = new Time(this.settings.getDayEnd().getTime() + 3600000L);
        long dayDuration = dayEndTime.getTime() - dayStartTime.getTime();
        double factor = (double)(y - 30) / (double)heightDif;
        long taskTimeSinceDayStart = (long)((double)dayDuration * factor);
        return new Time(dayStartTime.getTime() + taskTimeSinceDayStart);
    }
}

