/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda;

import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.CalendarView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.ConsumeProduceCalculator;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.HighLightMatcher;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.StockPrediction;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TaskFilter;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimedComponentUtil;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.VerticalTimeContainer;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.stock.StockController;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.StockInfoTimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.TaskTimeComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.util.Tuple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class DayView {
    private final int stockWidth = 75;
    private final CalendarView container;
    private final RDProvider provider;
    private final StockController stockController;
    private final Date date;
    private final TextLabel header;
    private final HorizontalTextureSkin headerSkin;
    private final VerticalTimeContainer stockColumn;
    private final VerticalTimeContainer taskColumn;
    private final WeeklyPlanSettingsComplete setting;
    private final TimedComponentUtil timedComponentUtil;
    private final int headerHeight;
    private int x;
    private int y;

    public DayView(CalendarView container, RDProvider provider, StockController stockController, Date date) {
        this.container = container;
        this.provider = provider;
        this.stockController = stockController;
        this.date = date;
        this.setting = (WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue();
        this.header = new TextLabel(DayOfWeekE.getForDateUtilDayOfWeek((int)DateUtil.getDayOfWeek((java.util.Date)date)).toString().toUpperCase());
        this.headerSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.stockColumn = new VerticalTimeContainer(container, "Stock", this.setting, date);
        this.taskColumn = new VerticalTimeContainer(container, "", this.setting, date);
        this.stockColumn.setInlineColor(new Color(255, 255, 255, 20));
        this.timedComponentUtil = new TimedComponentUtil(this.setting);
        this.headerHeight = this.headerSkin.getImage(11).getHeight();
        container.add(this.header);
    }

    public void addStock(TimeComponent component) {
        this.stockColumn.addTimeItem(component);
    }

    public void addTask(TimeComponent component) {
        component.setCoordinateSpaceOffset(this.headerHeight);
        this.taskColumn.addTimeItem(component);
    }

    public Date getDate() {
        return this.date;
    }

    public void paint(Graphics g, int boxX, int boxY, int boxWidth, int boxHeight) {
        Graphics2D g2 = (Graphics2D)g;
        Time time = new Time(this.setting.getDayStart().getTime());
        Color rasterColor = new Color(255, 255, 255, 80);
        g2.setColor(rasterColor);
        while (time.getTime() <= this.setting.getDayEnd().getTime()) {
            int y = this.timedComponentUtil.calculateYPositionForTime(time, boxHeight - this.headerHeight) + this.headerHeight;
            g2.drawLine(boxX, y + boxY, boxX + boxWidth - 1, y + boxY);
            time = new Time(time.getTime() + 3600000L);
        }
        this.stockColumn.paint(g2, boxX, this.headerHeight + boxY, 75, boxHeight - this.headerHeight);
        this.taskColumn.paint(g2, boxX + 75, boxY + this.headerHeight, boxWidth - boxX, boxHeight - (this.headerHeight + boxY));
        this.headerSkin.paint(g2, boxX, boxY, boxWidth, 11);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getTaskX() {
        return this.getX() + 75;
    }

    public void layoutContainer(int boxX, int boxY, int boxWidth, int boxHeight) {
        this.x = boxX;
        this.y = boxY;
        this.header.setLocation((int)(((double)boxWidth - this.header.getPreferredSize().getWidth()) / 2.0) + boxX, (int)(((double)this.headerHeight - this.header.getPreferredSize().getHeight()) / 2.0) + boxY);
        this.header.setSize(this.header.getPreferredSize());
        this.stockColumn.layoutContainer(boxX, this.headerHeight + boxY, 75, boxHeight - this.headerHeight);
        this.taskColumn.layoutContainer(boxX + 75, boxY + this.headerHeight, boxWidth - 75, boxHeight - (this.headerHeight + boxY));
    }

    public boolean containsTask(TaskTimeComponent taskTimeComponent) {
        return this.taskColumn.containsTask(taskTimeComponent);
    }

    public void switchComponentOut(TimeComponent taskTimeComponent) {
        this.taskColumn.switchComponentOut(taskTimeComponent);
    }

    public void switchComponentIn(TimeComponent taskTimeComponent) {
        this.taskColumn.switchComponentIn(taskTimeComponent);
    }

    public void highLightTasks(HighLightMatcher matcher) {
        this.taskColumn.highLightTasks(matcher);
    }

    public void updateStockEvent(StockPrediction stockPrediction) {
        List<ConsumeProduceCalculator> stockCalculators = this.taskColumn.getStockEvents(stockPrediction);
        this.stockColumn.clearItems();
        for (final ConsumeProduceCalculator stockCalculator : stockCalculators) {
            if (stockCalculator.isRemote()) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        Tuple<Timestamp, QuantityComplete> value = stockCalculator.generate();
                        ViewNode node = new ViewNode("ret");
                        node.setValue(value, 0L);
                        return node;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                Tuple value = (Tuple)node.getValue();
                                DayView.this.addStockEvent((Timestamp)value.getS(), (QuantityComplete)value.getT());
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)DayView.this.container);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
                continue;
            }
            Tuple<Timestamp, QuantityComplete> stockEvent = stockCalculator.generate();
            this.addStockEvent((Timestamp)stockEvent.getS(), (QuantityComplete)stockEvent.getT());
        }
    }

    private void addStockEvent(Timestamp time, QuantityComplete quantity) {
        TimeDurationComplete duration = new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(15.0));
        List<TimeComponent> itemsForTime = this.stockColumn.getItemsForTime(time);
        if (itemsForTime.isEmpty()) {
            StockInfoTimeComponent component = new StockInfoTimeComponent(time, quantity, duration);
            this.stockController.registerStockUsage(component);
            this.stockColumn.addTimeItem(component);
        } else {
            StockInfoTimeComponent timeComponent = (StockInfoTimeComponent)itemsForTime.get(0);
            timeComponent.addQuantity(quantity);
        }
    }

    public void updateFiltering(TaskFilter taskFilter) {
        this.taskColumn.updateFiltering(taskFilter);
    }

    public void removeStock() {
        this.stockColumn.clearItems();
    }
}

