/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class RefreshButton
extends SkinButton_NEW
implements ImageConsumer,
LafListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static BufferedImage[] imageArray;
    private int currentIndex = 0;
    private boolean stopRequested = false;
    private boolean isAnimating = false;
    private int c = 0;

    public RefreshButton() {
        super(DefaultSkins.RefreshIcon, false);
        this.setOpaque(false);
        this.lafAttributeChanged(null);
    }

    public static int getPreferredWidth() {
        RefreshButton.ensureImages();
        return imageArray[0].getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.isAnimating) {
            BufferedImage i = imageArray[this.currentIndex];
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
        } else {
            ((Skin1Field)this.getSkin()).paint(g2, 0, 0, this.state);
        }
        this.paintChildren(g2);
    }

    public void startAnimation() {
        if (this.stopRequested) {
            this.stopRequested = false;
        } else {
            AnimationProvider.registerAnimater(this);
            this.fadeIn();
        }
    }

    public void stopAnimation() {
        this.stopRequested = true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(imageArray[0].getWidth(), imageArray[0].getHeight());
    }

    private static void ensureImages() {
        if (imageArray != null) {
            return;
        }
        String path = LafLoader.getLafLoader().getAttribute("titlebar_icon_refresh_folder");
        Integer lastImg = AttributesConverter.getInteger4String(LafLoader.getLafLoader().getAttribute("titlebar_icon_refresh_image_end"));
        String preFix = LafLoader.getLafLoader().getAttribute("titlebar_icon_refresh_prefix");
        String postFix = LafLoader.getLafLoader().getAttribute("titlebar_icon_refresh_postfix");
        imageArray = new BufferedImage[lastImg.intValue()];
        String maxLength = "" + lastImg;
        for (int i = 1; i <= lastImg; ++i) {
            String nr = "" + i;
            while (nr.length() != maxLength.length()) {
                nr = "0" + nr;
            }
            String f2load = path + preFix + nr + postFix;
            RefreshButton.imageArray[i - 1] = AttributesConverter.getBufferedImage4String(f2load);
        }
    }

    @Override
    public void loadImages() {
        RefreshButton.ensureImages();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.stopRequested) {
            ++this.c;
            if (this.c == 40) {
                this.stopRequested = false;
                AnimationProvider.deregisterAnimater(this);
                this.fadeOut(false);
                this.c = 0;
            }
        }
        ++this.currentIndex;
        if (this.currentIndex > imageArray.length - 1) {
            this.currentIndex = 1;
        }
        this.repaint(32L);
    }

    @Override
    public void clearImages() {
        imageArray = null;
        this.loadImages();
    }
}

