/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.ToggleSkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class ExpandIcon
extends ToggleSkinButton_NEW
implements ButtonListener,
LafListener,
AttributeListener {
    private static final long serialVersionUID = 1L;
    private boolean isExpanded;
    private static Color arrowColorEnabled;
    private static Color arrowColorDisabled;
    private SizedSkin1Field.SkinSize typeSize;

    public ExpandIcon() {
        this(SizedSkin1Field.SkinSize.SMALL);
    }

    public ExpandIcon(SizedSkin1Field.SkinSize size) {
        super(DefaultSkins.ExpandIcon, false);
        this.typeSize = size;
        this.setToolTipText(Words.EXPAND_COLLAPSE);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.addButtonListener(this);
        this.setSize(this.getPreferredSize());
    }

    public static int getPreferredWidth(SizedSkin1Field.SkinSize size) {
        if (size == SizedSkin1Field.SkinSize.BIG) {
            ToggleSkin1Field s = (ToggleSkin1Field)DefaultSkins.ExpandIcon.createDynamicSkin();
            return s.getImage(Button.ButtonState.UP, true).getWidth();
        }
        return AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("mealplan_expand_arrow_size"));
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
        this.repaint(32L);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setExpanded(!this.isExpanded);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.typeSize == SizedSkin1Field.SkinSize.BIG) {
            return new Dimension(((ToggleSkin1Field)this.getSkin()).getImage(this.state, this.isExpanded).getWidth(), ((ToggleSkin1Field)this.getSkin()).getImage(this.state, this.isExpanded).getHeight());
        }
        return new Dimension(this.size, this.size);
    }

    @Override
    public void kill() {
        super.kill();
        this.removeButtonListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        switch (this.typeSize) {
            case SMALL: 
            case MEDIUM: {
                int[] xCoord = new int[3];
                int[] yCoord = new int[3];
                if (this.isExpanded) {
                    xCoord[0] = 0;
                    xCoord[1] = this.getWidth();
                    xCoord[2] = this.getWidth() / 2;
                    yCoord[0] = 0;
                    yCoord[1] = 0;
                    yCoord[2] = this.getHeight();
                } else {
                    xCoord[0] = 0;
                    xCoord[1] = this.getWidth();
                    xCoord[2] = 0;
                    yCoord[0] = 0;
                    yCoord[1] = this.getHeight() / 2;
                    yCoord[2] = this.getHeight();
                }
                if (this.state == Button.ButtonState.DISABLED) {
                    g2.setColor(arrowColorDisabled);
                } else {
                    g2.setColor(arrowColorEnabled);
                }
                g2.fillPolygon(xCoord, yCoord, 3);
                break;
            }
            case BIG: {
                ((ToggleSkin1Field)this.getSkin()).paint(g2, 0, 0, this.state, this.isExpanded);
            }
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        arrowColorEnabled = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        arrowColorDisabled = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("expand_arrow_disabled_color"));
    }

    @Override
    public void attributeChanged(String attributeName) {
        this.size = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("mealplan_expand_arrow_size"));
    }
}

