/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.IPDFViewer;
import ch.icit.pegasus.client.gui.utils.PageChooser;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.laf.LafLoader;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PDFViewer
extends DefaultPanel
implements ButtonListener,
IPDFViewer {
    private static final long serialVersionUID = 1L;
    private PagePanel panel;
    private PageChooser pageChooser;
    private TextButton openFile;
    private File originFile;
    private PDFFile currentFile;

    public PDFViewer() {
        this(false);
    }

    public PDFViewer(boolean withOpenFile) {
        this.setLayout(new Layout());
        this.panel = new PagePanel();
        this.pageChooser = new PageChooser(this);
        if (withOpenFile) {
            this.openFile = new TextButton("Open File");
            this.openFile.addButtonListener(this);
        }
        this.setInnerBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        this.add((Component)this.panel);
        this.add(this.pageChooser);
        if (this.openFile != null) {
            this.add(this.openFile);
        }
    }

    public void setInnerBackground(Color c) {
        this.panel.setBackground(c);
    }

    public void showPDF(File file) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray((File)file);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.showPDF(file, new PDFFile(buffer));
    }

    public void showPDF(File originFile, PDFFile file) {
        this.originFile = originFile;
        this.currentFile = file;
        this.pageChooser.setPDF(this.currentFile);
        PDFPage page = this.currentFile.getPage(1);
        this.panel.setSize(new Dimension((int)page.getWidth(), (int)page.getHeight()));
        this.panel.showPage(page);
        this.pageChooser.setSelectedPage(1);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.panel.setEnabled(isEnabled);
        this.pageChooser.setEnabled(isEnabled);
        if (this.openFile != null) {
            this.openFile.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.remove((Component)this.panel);
        this.panel = null;
        this.pageChooser.kill();
        this.pageChooser = null;
        if (this.openFile != null) {
            this.openFile.kill();
            this.openFile = null;
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.pageChooser);
        CheckedListAdder.addToList(a, this.openFile);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.pageChooser.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.pageChooser.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.openFile && this.originFile != null) {
            try {
                Desktop.getDesktop().open(this.originFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void pageChange(int pageNo) {
        PDFPage page = this.currentFile.getPage(pageNo);
        this.panel.showPage(page);
        this.pageChooser.setSelectedPage(pageNo);
        this.revalidate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(150, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            PDFViewer.this.panel.setLocation(0, 0);
            PDFViewer.this.panel.setSize(parent.getWidth(), (int)((double)parent.getHeight() - (PDFViewer.this.pageChooser.getPreferredSize().getHeight() + 5.0)));
            PDFViewer.this.pageChooser.setLocation((int)(((double)parent.getWidth() - PDFViewer.this.pageChooser.getPreferredSize().getWidth()) / 2.0), PDFViewer.this.panel.getHeight() + 5);
            PDFViewer.this.pageChooser.setSize(parent.getWidth(), (int)PDFViewer.this.pageChooser.getPreferredSize().getHeight());
            if (PDFViewer.this.openFile != null) {
                PDFViewer.this.openFile.setLocation((int)((double)parent.getWidth() - (5.0 + PDFViewer.this.openFile.getPreferredSize().getWidth())), PDFViewer.this.panel.getHeight() + 5);
                PDFViewer.this.openFile.setSize(PDFViewer.this.openFile.getPreferredSize());
            }
        }
    }
}

