/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.table2.Table2ViewFactory;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.util.ArrayList;
import java.util.List;

public class Table2Model
implements NodeListener,
MutableFocusContainer {
    ArrayList<Table2RowModel> models = new ArrayList();
    private Table2 table;
    private Node rootNode;
    private int[] currentColumnWidth;
    private List<TableColumnInfo> columns;
    private Table2RowModel headerModel;
    private Table2ViewFactory viewFactory;
    private boolean showHeader;
    private boolean hasDefaultHorizontalLine = true;
    private String secondChildName;
    private String firstChildName;
    private boolean isTransposed;
    private boolean ignoreFirstChild;
    private List<MutableFocusContainerListener> focusCycleCreatorListener = new ArrayList<MutableFocusContainerListener>();
    private List<Table2Model> otherModels = new ArrayList<Table2Model>();
    private List<Table2RowSelectionListener> selectionListener = new ArrayList<Table2RowSelectionListener>();
    private Table2RowPanel selectedRow;
    private boolean isInit = true;
    private String name2Search;
    private List<ArrayList<Node>> matrix;
    private boolean isReseting;
    private boolean isNodeInit;
    private boolean isAddable;
    private boolean isDeletable;
    private boolean isOrderChangable;
    private boolean isKilled;

    public Table2Model(List<TableColumnInfo> columns) {
        this(columns, true);
    }

    public Table2Model(List<TableColumnInfo> columns, boolean showHeader) {
        this(columns, showHeader, null);
    }

    public Table2Model(List<TableColumnInfo> columns, Table2ViewFactory viewFactory) {
        this(columns, true, viewFactory);
    }

    public Table2Model(List<TableColumnInfo> columns, boolean showHeader, Table2ViewFactory viewFactory) {
        this.columns = columns;
        this.showHeader = showHeader;
        if (viewFactory != null) {
            this.setViewFactory(viewFactory);
        }
        this.updateColumnWiths();
    }

    public void refreshColumns(List<TableColumnInfo> columns) {
        this.columns = columns;
        this.updateColumnWiths();
    }

    public void updateColumnWiths() {
        if (this.columns == null) {
            return;
        }
        this.currentColumnWidth = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            this.currentColumnWidth[i] = this.columns.get(i).getPreferredWidth();
        }
        if (this.headerModel != null && this.headerModel.getView() instanceof Table2HeaderPanel) {
            ((Table2HeaderPanel)this.headerModel.getView()).updateHeaderValues(2);
        }
    }

    public boolean isSelected(Table2RowPanel p) {
        return p != null && p == this.selectedRow;
    }

    public void addModel(Table2Model m) {
        if (!this.otherModels.contains(m)) {
            this.otherModels.add(m);
        }
    }

    public boolean isIgnoreFirstChild() {
        return this.ignoreFirstChild;
    }

    public void setIgnoreFirstChild(boolean ignoreFirstChild) {
        this.ignoreFirstChild = ignoreFirstChild;
    }

    private void fireSelectionEvent(Table2RowPanel selectedRow2) {
        ArrayList<Table2RowSelectionListener> ll = new ArrayList<Table2RowSelectionListener>();
        ll.addAll(this.selectionListener);
        for (Table2RowSelectionListener l : ll) {
            l.tableRowSelected(this.table, selectedRow2);
        }
    }

    protected void fireFocusCycleCreatorEvent(Table2RowPanel p, boolean add) {
        if (this.focusCycleCreatorListener != null) {
            for (MutableFocusContainerListener l : this.focusCycleCreatorListener) {
                if (l == null) continue;
                l.focusCycleChanged(this);
            }
        }
    }

    public void recreateFocusCycle() {
        if (this.isNodeInit) {
            return;
        }
        this.fireFocusCycleCreatorEvent(null, true);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleCreatorListener.add(listener);
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleCreatorListener.remove(listener);
    }

    public void allInitiated() {
        this.isInit = false;
    }

    public void rowAddedFromOutside(Table2RowPanel p) {
        this.fireFocusCycleCreatorEvent(p, true);
    }

    public void rowRemovedFromOutside(Table2RowPanel p) {
        this.fireFocusCycleCreatorEvent(p, false);
    }

    public void selectRow(Table2RowPanel panel, boolean recursive, boolean wasClick, int type) {
        if (recursive && this.otherModels != null) {
            for (Table2Model m : this.otherModels) {
                m.selectRow(null, false, wasClick, 7);
            }
        }
        if (type == 3) {
            if (this.selectedRow != null && this.selectedRow.isSelected() == 3) {
                this.selectedRow.setSelected(7, wasClick);
            }
            this.selectedRow = panel;
        }
        if (panel != null) {
            panel.setSelected(type, wasClick);
            if (type == 3) {
                this.fireSelectionEvent(panel);
            }
        } else {
            this.fireSelectionEvent(null);
        }
    }

    public Node getSelectedNode() {
        if (this.selectedRow != null) {
            return this.selectedRow.getModel().getNode();
        }
        return null;
    }

    public void addTableSelectionListener(Table2RowSelectionListener l) {
        this.selectionListener.add(l);
    }

    public void removeTableSelectionListener(Table2RowSelectionListener l) {
        this.selectionListener.remove(l);
    }

    public boolean isInit() {
        return this.isInit;
    }

    public boolean isTransposed() {
        return this.isTransposed;
    }

    public void setTransposed(boolean isTransposed) {
        this.isTransposed = isTransposed;
    }

    public void setMatrix(ArrayList<ArrayList<Node>> matrix) {
        this.matrix = matrix;
    }

    public boolean isHasDefaultHorizontalLine() {
        return this.hasDefaultHorizontalLine;
    }

    public void setHasDefaultHorizontalLine(boolean hasDefaultHorizontalLine) {
        this.hasDefaultHorizontalLine = hasDefaultHorizontalLine;
    }

    public Node getNodeAt(int row, int column) {
        return this.matrix.get(column).get(row);
    }

    protected boolean isLastEntry(Table2RowModel m) {
        return this.models.indexOf(m) == this.models.size() - 1;
    }

    public Table2RowModel getModelAt(int i) {
        return this.models.get(i);
    }

    private void propagteColumnWidth(boolean immediateUpdate) {
        if (this.headerModel != null) {
            this.headerModel.getView().updateWidth();
        }
        for (Table2RowModel m : (ArrayList)this.models.clone()) {
            m.getView().updateWidth();
        }
    }

    public int getRowNumber(Table2RowModel model) {
        return this.models.indexOf(model);
    }

    public Table2 getTable() {
        return this.table;
    }

    public Node getNode() {
        return this.rootNode;
    }

    public int ensureColumnWidths(int columnIndex, int newWidth, boolean dontUseViewPort, boolean imediateUpdate) {
        if (columnIndex == -1) {
            int viewPortSpace = this.table.getViewableWidth();
            if (dontUseViewPort) {
                viewPortSpace = newWidth;
            }
            int currentWidth = 0;
            for (int i = 0; i < this.currentColumnWidth.length; ++i) {
                currentWidth += this.currentColumnWidth[i];
            }
            int diff = viewPortSpace - currentWidth;
            int i = 0;
            while (i < this.currentColumnWidth.length) {
                double xExpand = this.columns.get(i).getxExpand();
                int add = (int)((double)diff * xExpand);
                int n = i++;
                this.currentColumnWidth[n] = this.currentColumnWidth[n] + add;
            }
            this.propagteColumnWidth(imediateUpdate);
        }
        return 0;
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getColumnName();
    }

    public int getColumnCount() {
        return this.columns != null ? this.columns.size() : 0;
    }

    public int getColumnWidth(int index) {
        if (index == -1) {
            int all = 0;
            for (int i = 0; i < this.currentColumnWidth.length; ++i) {
                all += this.currentColumnWidth[i];
            }
            return all;
        }
        if (index > this.currentColumnWidth.length - 1) {
            return 0;
        }
        return this.currentColumnWidth[index];
    }

    public TableColumnInfo getColumn(int index) {
        return this.columns.get(index);
    }

    public void generateNewHeader() {
        if (this.headerModel != null) {
            this.headerModel.kill();
        }
        this.headerModel = new Table2RowModel(null, this, true);
        if (this.table != null) {
            this.table.setHeaderRow(this.headerModel.getView());
        }
    }

    public void setViewFactory(Table2ViewFactory f) {
        this.viewFactory = f;
        if (this.showHeader) {
            this.generateNewHeader();
        }
    }

    public Table2ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public void setTable(Table2 t) {
        this.table = t;
        if (this.headerModel != null) {
            this.table.setHeaderRow(this.headerModel.getView());
        }
    }

    public void setNode(String nameToSearch, Node nodeList) {
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
            this.resetModel();
        }
        this.rootNode = nodeList;
        this.name2Search = nameToSearch;
        this.rootNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
    }

    public void setNode(String childName, boolean useFirst, Node ... r) {
        this.setNode(childName, null, useFirst, r);
    }

    public boolean shouldAddRow(Node node) {
        if (this.models != null) {
            for (Table2RowModel m : this.models) {
                if (!m.getNode().equals(node)) continue;
                return false;
            }
        }
        return true;
    }

    public void setNode(String childName, String secondChildName, boolean useFirst, Node ... r) {
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
            this.resetModel();
            this.rootNode = null;
        }
        this.firstChildName = childName;
        this.secondChildName = secondChildName;
        if (r == null || r != null && r.length == 0) {
            return;
        }
        if (useFirst) {
            this.addRow(r[0]).getView().setHasHorizontalLine(true);
            if (r.length == 1) {
                this.rootNode = r[0].getChildNamed(new String[]{childName});
            }
        } else if (r.length == 1 && r[0] != null) {
            this.rootNode = childName == null ? r[0] : r[0].getChildNamed(new String[]{childName});
        } else if (r[0] == null) {
            return;
        }
        for (int i = 1; i < r.length; ++i) {
            if (i == r.length - 1) {
                this.addRow(r[i]).getView().setHasHorizontalLine(false);
                this.rootNode = r[i].getChildNamed(new String[]{childName});
                continue;
            }
            this.addRow(r[i]).getView().setHasHorizontalLine(false);
        }
        if (this.rootNode != null) {
            this.rootNode.addNodeListener((NodeListener)this);
            this.rootNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
        }
    }

    public void setNode(Node r) {
        this.isNodeInit = true;
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
        }
        this.resetModel();
        this.rootNode = r;
        if (this.rootNode != null) {
            this.ensureRights();
            this.rootNode.addNodeListener((NodeListener)this);
            this.rootNode.getAllChildAddEvents((NodeListener)this);
            this.table.ensureRowCount(this.table.isEnabled());
        }
        this.isNodeInit = false;
    }

    public void ensureRights() {
        if (this.table.getProvider() != null) {
            String sName = this.rootNode.getName();
            if (this.table.getOverrideName() != null) {
                sName = this.table.getOverrideName();
            }
            if (this.table.useWrite()) {
                this.isAddable = this.table.getProvider().isWritable(sName);
                this.isDeletable = this.table.getProvider().isWritable(sName);
                this.isOrderChangable = this.table.getProvider().isWritable(sName);
            } else if (this.table.isUseAccessRight()) {
                this.isOrderChangable = this.table.getProvider().hasSubRight(sName);
                this.isDeletable = this.table.getProvider().hasSubRight(sName);
                this.isAddable = this.table.getProvider().hasSubRight(sName);
            } else {
                this.isAddable = this.table.getProvider().isAddable(sName);
                this.isDeletable = this.table.getProvider().isDeletable(sName);
                this.isOrderChangable = this.table.getProvider().isOrderChangable(sName);
            }
            this.table.ensureAddButton(this.table.getButtonText(), this.isAddable);
        }
    }

    public boolean isAddable() {
        return this.isAddable;
    }

    public boolean isDeletable() {
        return this.isDeletable;
    }

    public boolean isOrderChangable() {
        return this.isOrderChangable;
    }

    public void resetModel() {
        this.isReseting = true;
        if (this.rootNode != null) {
            this.rootNode.removeNodeListenerRecursively((NodeListener)this);
        }
        for (Table2RowModel m : (ArrayList)this.models.clone()) {
            this.removeRow(m.getNode());
        }
        this.models.clear();
        this.isReseting = false;
    }

    protected boolean isReseting() {
        return this.isReseting;
    }

    public boolean checkIfIsToAdd(Node node) {
        return true;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (child != null && child.getName() != null && child.getName().equals("deleted")) {
            this.removeRow(child);
        } else if (this.firstChildName != null) {
            if (source.getName().equals(this.firstChildName)) {
                Table2RowPanel p = this.table.getRowPanel4Node(source.getParent());
                if (!this.checkIfIsToAdd(child)) {
                    return;
                }
                if (this.shouldAddRow(child) && this.checkIfIsToAdd(child)) {
                    if (!this.ignoreFirstChild) {
                        if (p == null) {
                            this.addRow(child);
                        } else {
                            p.addRow(child).getView().setHasHorizontalLine(this.hasDefaultHorizontalLine);
                        }
                        if (child instanceof Node) {
                            child.addNodeListener((NodeListener)this);
                        }
                    }
                    if (this.secondChildName != null && child instanceof Node) {
                        Node n = child.getChildNamed(new String[]{this.secondChildName});
                        n.addNodeListener((NodeListener)this);
                        n.getAllChildAddEventsFor((NodeListener)this, new String[0]);
                    }
                }
            } else if (source.getName().equals(this.secondChildName) && this.shouldAddRow(child) && this.checkIfIsToAdd(child)) {
                Table2RowPanel p = this.table.getRowPanel4Node(child);
                if (p == null) {
                    this.addRow(child).getView().setHasHorizontalLine(this.hasDefaultHorizontalLine);
                } else {
                    p.addRow(child).getView().setHasHorizontalLine(this.hasDefaultHorizontalLine);
                }
                if (child instanceof Node) {
                    child.addNodeListener((NodeListener)this);
                }
            }
        } else if (this.name2Search != null && source == this.rootNode) {
            if (child instanceof Node) {
                Node n = child.getChildNamed(new String[]{this.name2Search});
                n.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        } else if (this.isTransposed) {
            if (this.needsNewRow(child)) {
                this.addRow(child);
            } else {
                Table2RowPanel p = this.getEffectedRow(child);
                if (p != null) {
                    p.updateRow(child);
                }
            }
        } else if (this.shouldAddRow(child) && this.checkIfIsToAdd(child)) {
            this.addRow(child);
        }
    }

    public boolean needsNewRow(Node IReadableNodeAdd) {
        return true;
    }

    public Table2RowPanel getEffectedRow(Node IReadableNodeAdd) {
        return null;
    }

    protected void addTableRowModel(Table2RowModel m) {
        this.models.add(m);
    }

    protected void removeTableRowModel(Table2RowModel m) {
        this.models.remove(m);
    }

    public Table2RowModel addRow(Node child) {
        if (this.models != null) {
            Table2RowModel m = new Table2RowModel(child, this, false);
            this.models.add(m);
            this.table.addRow(m.getView());
            if (!this.isNodeInit) {
                this.fireFocusCycleCreatorEvent(m.getView(), true);
            }
            return m;
        }
        return null;
    }

    private void removeRow(Node child) {
        for (Table2RowModel m : this.models) {
            if (m.getNode() != child) continue;
            if (m.getView().isSelected == 3) {
                this.fireSelectionEvent(null);
            }
            if (m.getView().getChildren() != null) {
                for (Table2RowPanel m2 : m.getView().getChildren()) {
                    this.table.removeRow(m2, true);
                    this.models.remove(m2.getModel());
                }
            }
            this.table.removeRow(m.getView(), true);
            this.models.remove(m);
            return;
        }
        this.fireFocusCycleCreatorEvent(null, false);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (this.rootNode == source) {
            if (child instanceof Node) {
                child.removeNodeListener((NodeListener)this);
            }
            this.removeRow(child);
        } else if (child.getName().equals("deleted")) {
            this.addRow(source);
        } else {
            if (this.models == null) {
                return;
            }
            for (Table2RowModel m : (ArrayList)this.models.clone()) {
                Table2RowPanel p = m.getView().getChild4Node(child);
                if (p == null) continue;
                m.getView().removeRow(p);
                this.removeRow(child);
            }
        }
    }

    public void valueChanged(Node<?> node) {
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.isReseting = true;
        for (Table2RowModel m : (ArrayList)this.models.clone()) {
            m.kill();
        }
        this.models.clear();
        this.models = null;
        this.isReseting = false;
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
        }
        this.rootNode = null;
        this.currentColumnWidth = null;
        this.columns.clear();
        this.columns = null;
        if (this.headerModel != null) {
            this.headerModel.kill();
        }
        this.headerModel = null;
        this.viewFactory = null;
        this.focusCycleCreatorListener.clear();
        this.focusCycleCreatorListener = null;
        this.otherModels.clear();
        this.otherModels = null;
        this.selectionListener.clear();
        this.selectionListener = null;
        this.selectedRow = null;
        if (this.matrix != null) {
            this.matrix.clear();
            this.matrix = null;
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public List<TableColumnInfo> getColumns() {
        return this.columns;
    }

    public boolean isSwingOnly() {
        return true;
    }

    protected void setReseting(boolean b) {
        this.isReseting = b;
    }
}

