/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.gui.table2.Table2RowLayoutConstrain;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DefaultTable2RowImpl
extends Table2RowPanel {
    private static final long serialVersionUID = 1L;
    private List<Table2RowLayoutConstrain> comps = new ArrayList<Table2RowLayoutConstrain>();
    private Object userObject;
    private boolean shouldRequestFocus;

    public DefaultTable2RowImpl(Table2RowModel m, boolean focusRequest, Table2RowLayoutConstrain ... constrains) {
        this(m, focusRequest, true, constrains);
    }

    public DefaultTable2RowImpl(Table2RowModel m, boolean focusRequest, boolean isSelected, Table2RowLayoutConstrain ... constrains) {
        super(m);
        this.shouldRequestFocus = focusRequest;
        if (isSelected) {
            this.setSelectable(true);
        }
        if (focusRequest) {
            this.addFocusListener(this);
        }
        this.setLayout(new Layout());
        for (int i = 0; i < constrains.length; ++i) {
            this.comps.add(constrains[i]);
            this.add(constrains[i].getView());
            if (!(constrains[i].getView() instanceof Fadable)) continue;
            ((Fadable)((Object)constrains[i].getView())).setProgress(1.0f);
        }
    }

    public DefaultTable2RowImpl(Table2RowModel m, boolean focusRequest, boolean isSelected, List<Table2RowLayoutConstrain> constraints) {
        super(m);
        this.shouldRequestFocus = focusRequest;
        if (isSelected) {
            this.setSelectable(true);
        }
        if (focusRequest) {
            this.addFocusListener(this);
        }
        this.setLayout(new Layout());
        for (Table2RowLayoutConstrain con : constraints) {
            this.comps.add(con);
            this.add(con.getView());
            if (!(con.getView() instanceof Fadable)) continue;
            ((Fadable)((Object)con.getView())).setProgress(1.0f);
        }
    }

    @Override
    public Object getObject4Column(int column) {
        return null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    protected void selectCurrentRow(Table2RowPanel p, boolean wasClick, int type) {
        super.selectCurrentRow(p, wasClick, type);
        if (this.shouldRequestFocus) {
            this.requestFocusInWindow();
        }
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.shouldRequestFocus) {
            this.requestFocusInWindow();
        } else {
            for (Table2RowLayoutConstrain trlc : this.comps) {
                if (!(trlc.getView() instanceof Focusable)) continue;
                ((Focusable)((Object)trlc.getView())).requestFocusInWindowNow();
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (Table2RowLayoutConstrain trls : this.comps) {
            trls.getView().setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.shouldRequestFocus) {
            a.add(this);
        }
        for (Table2RowLayoutConstrain trlc : this.comps) {
            if (!(trlc.getView() instanceof Focusable)) continue;
            CheckedListAdder.addToList(a, (Focusable)((Object)trlc.getView()));
        }
        if (this.isSelected == 3 && this.model.getParentModel().getTable().getDetailsFocusView() != null) {
            CheckedListAdder.addToList(a, this.model.getParentModel().getTable().getDetailsFocusView());
        }
        return a;
    }

    public Component getComponentViewAt(int index) {
        return this.comps.get(index).getView();
    }

    public Table2RowLayoutConstrain getComponentAt(int index) {
        return this.comps.get(index);
    }

    private int getCurrentX(int column) {
        int currentX = 0;
        for (int c = 0; c < column; ++c) {
            currentX += this.model.getParentModel().getColumnWidth(c);
        }
        return currentX;
    }

    @Override
    public void delegateSelection2Childs(int isSelected) {
        for (Table2RowLayoutConstrain c : this.comps) {
            if (!(c.getView() instanceof Selectable)) continue;
            ((Selectable)((Object)c.getView())).setSelected(isSelected);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            for (Table2RowLayoutConstrain c : DefaultTable2RowImpl.this.comps) {
                int x = DefaultTable2RowImpl.this.getCurrentX(c.getCol()) + c.getHeadInset();
                int y = (int)(((double)parent.getHeight() - c.getView().getPreferredSize().getHeight()) / 2.0);
                int w = (int)c.getView().getPreferredSize().getWidth();
                if (c.getStrategy() == 5) {
                    w = DefaultTable2RowImpl.this.model.getParentModel().getColumnWidth(c.getCol()) - (c.getHeadInset() + c.getTailInset());
                } else if (c.getStrategy() == 13) {
                    x = DefaultTable2RowImpl.this.getCurrentX(c.getCol());
                    int cw = DefaultTable2RowImpl.this.model.getParentModel().getColumnWidth(c.getCol());
                    x += (cw - w) / 2;
                }
                int h = (int)c.getView().getPreferredSize().getHeight();
                c.getView().setLocation(x, y);
                c.getView().setSize(w, h);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, DefaultTable2RowImpl.this.getDefaultRowHeight());
        }
    }
}

