/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Component;

public class CellViewStringRenderer
extends CellRenderer
implements AttributeListener,
LafListener {
    private TextLabel label;
    private boolean isHeader;

    public CellViewStringRenderer(String text, boolean isHeader, Component mouseDelegate) {
        this.isHeader = isHeader;
        this.label = new TextLabel(text);
        this.label.setProgress(1.0f);
        this.label.setDelegateComponent(mouseDelegate);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
    }

    @Override
    public String getStringValue() {
        return this.label.getText();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    public String getText() {
        return this.label.getText();
    }

    @Override
    protected void layoutCell() {
        if (this.isFirstColumn) {
            this.label.setLocation(this.firstColumnInset, 0);
        } else {
            this.label.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), 0);
        }
    }

    @Override
    public void setSize(int w, int h) {
        if (this.label != null) {
            this.label.setSize(w - 2 * this.label.getX(), h);
        }
        super.setSize(w, h);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.setSize(this.getWidth(), this.getHeight());
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.layoutCell();
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            if (!this.isHeader) {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
            } else {
                this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_table_header_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
                this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground")));
            }
        }
    }
}

