/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.tab.AlternativeTabView;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;

public class RowContentPanelLayout
extends DefaultLayout
implements AttributeListener {
    private int vertical_border = 15;
    private int horizontal_border = 15;
    private int startVBorder = 15;
    private int startHBorder = 15;
    private AlternativeTabView altenativeTabView;
    private ArrayList<ArrayList<Component>> components = new ArrayList();
    private ArrayList<ArrayList<TableLayoutConstraint>> constrains = new ArrayList();

    public RowContentPanelLayout(String name) {
    }

    public RowContentPanelLayout() {
    }

    public void setAlternativeTabView(AlternativeTabView tab) {
        this.altenativeTabView = tab;
    }

    public ArrayList<ArrayList<Component>> getComponents() {
        return this.components;
    }

    public void setVerticalStartBorder(int b) {
        this.startVBorder = b;
    }

    public void setHorizontalStartBorder(int b) {
        this.startHBorder = b;
    }

    public void setVerticalBorder(int b) {
        this.vertical_border = b;
    }

    public void setHorizontalBorder(int b) {
        this.horizontal_border = b;
    }

    public int getVerticalBorder() {
        return this.vertical_border;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            return;
        }
        TableLayoutConstraint cons = (TableLayoutConstraint)constraints;
        while (cons.getColumn() >= this.components.size()) {
            this.components.add(new ArrayList());
            this.constrains.add(new ArrayList());
        }
        ArrayList<Component> col = this.components.get(cons.getColumn());
        ArrayList<TableLayoutConstraint> col2 = this.constrains.get(cons.getColumn());
        int count = 0;
        while (cons.getRow() >= col.size()) {
            ++count;
            col.add(null);
            col2.add(null);
        }
        col.set(cons.getRow(), comp);
        col2.set(cons.getRow(), cons);
    }

    @Override
    public void layoutContainer(Container parent) {
        int startY;
        int currentY;
        int w = parent.getWidth();
        int h = parent.getHeight();
        int prefW = (int)this.preferredLayoutSize(parent).getWidth();
        int prefH = (int)this.preferredLayoutSize(parent).getHeight();
        int dif = w - prefW;
        int difH = h - prefH;
        if (dif < 0) {
            dif = 0;
        }
        int currentX = this.startHBorder;
        int maxY = currentY = (startY = this.startVBorder);
        int col = 0;
        for (ArrayList<Component> columns : this.components) {
            Dimension prefColumn = this.preferredLayoutColumnSize(parent, col);
            prefH = (int)prefColumn.getHeight();
            difH = h - prefH;
            int rowC = 0;
            for (Component row : columns) {
                if (row != null) {
                    Component altComponent;
                    int add;
                    double factor;
                    currentX = this.getCurrentX(rowC, col);
                    TableLayoutConstraint cons = this.constrains.get(col).get(rowC);
                    row.setLocation(currentX, currentY);
                    int tw = (int)row.getPreferredSize().getWidth();
                    int th = (int)row.getPreferredSize().getHeight();
                    Dimension prefRow = this.preferredLayoutRowSize(parent, rowC);
                    prefW = (int)prefRow.getWidth() + this.startHBorder * 2;
                    dif = w - prefW;
                    if (dif != 0 && cons.getxExpand() != -1.0) {
                        factor = cons.getxExpand();
                        add = (int)((double)dif * factor);
                        tw += add;
                    }
                    if (difH != 0 && cons.getyExpand() != -1.0) {
                        factor = cons.getyExpand();
                        add = (int)((double)difH * factor);
                        th += add;
                        int spanH = this.getSpanHeight(rowC + 1, col);
                        th -= spanH;
                    }
                    if (tw > w) {
                        tw = w;
                    }
                    row.setSize(tw, th);
                    if (this.altenativeTabView != null && (altComponent = this.altenativeTabView.getAlternativeComponent(rowC, col)) != null) {
                        altComponent.setLocation(currentX, currentY);
                        altComponent.setSize(tw, th);
                    }
                    currentY += row.getHeight() + this.vertical_border;
                }
                ++rowC;
            }
            ++col;
            if (maxY < currentY) {
                maxY = currentY;
            }
            currentY = startY;
        }
    }

    public int getCurrentX(int currentRow, int currentColumn) {
        if (currentColumn == 0) {
            return this.startHBorder;
        }
        int column = 0;
        for (ArrayList<Component> columns : this.components) {
            int rowC = 0;
            for (Component row : columns) {
                if (rowC == currentRow && column == currentColumn - 1) {
                    return row.getX() + row.getWidth() + this.horizontal_border;
                }
                ++rowC;
            }
            ++column;
        }
        return 0;
    }

    private int getSpanHeight(int row, int startingColumn) {
        for (int currentColumn = startingColumn - 1; currentColumn < this.components.size() && currentColumn >= 0; --currentColumn) {
            TableLayoutConstraint currentConstrain;
            ArrayList<Component> l = this.components.get(currentColumn);
            if (row >= l.size() || row < 0 || (currentConstrain = this.constrains.get(currentColumn).get(row)).getxSpan() <= startingColumn - currentColumn) continue;
            return (int)this.components.get(currentColumn).get(row).getPreferredSize().getHeight() + this.vertical_border;
        }
        return 0;
    }

    public Dimension preferredLayoutColumnSize(Container parent, int effectedColumn) {
        int prefH = this.startVBorder;
        int colC = 0;
        for (ArrayList<Component> columns : this.components) {
            int rowC = 0;
            for (Component row : columns) {
                if (row != null && colC == effectedColumn) {
                    prefH = (int)((double)prefH + row.getPreferredSize().getHeight());
                    prefH += this.vertical_border;
                }
                ++rowC;
            }
            ++colC;
        }
        prefH -= this.vertical_border;
        return new Dimension(0, prefH += this.startVBorder);
    }

    public Dimension preferredLayoutRowSize(Container parent, int effectedRow) {
        int prefW = 0;
        int colC = 0;
        for (ArrayList<Component> columns : this.components) {
            int rowC = 0;
            for (Component row : columns) {
                if (row != null && rowC == effectedRow) {
                    prefW = (int)((double)prefW + row.getPreferredSize().getWidth());
                    prefW += this.horizontal_border;
                }
                ++rowC;
            }
            ++colC;
        }
        return new Dimension(prefW -= this.horizontal_border, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int startY;
        int currentX = this.startHBorder;
        int currentY = startY = this.startVBorder;
        int maxY = 0;
        for (ArrayList<Component> columns : this.components) {
            int maxWidth = 0;
            for (Component row : columns) {
                if (row == null) continue;
                if ((double)maxWidth < row.getPreferredSize().getWidth()) {
                    maxWidth = (int)row.getPreferredSize().getWidth();
                }
                currentY = (int)((double)currentY + (row.getPreferredSize().getHeight() + (double)this.vertical_border));
            }
            currentY -= this.vertical_border;
            if (maxY < (currentY += this.startVBorder)) {
                maxY = currentY;
            }
            currentX += maxWidth + this.horizontal_border;
            currentY = startY;
        }
        currentX -= this.horizontal_border;
        return new Dimension(currentX += this.startHBorder, ++maxY);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (ArrayList<Component> column : this.components) {
            if (!column.contains(comp)) continue;
            column.remove(comp);
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.vertical_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_vertical_gap"));
            this.horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_horizontal_gap"));
            this.startVBorder = this.vertical_border;
            this.startHBorder = this.horizontal_border;
        }
    }
}

