/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.gui.table.CellFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.general.IUniversal;

public class HiddenRowPanel<T extends IUniversal>
extends RowPanel<T> {
    protected RowPanel<T> hiddenEditor;
    private boolean shouldDelegateMouseEvents = true;

    public HiddenRowPanel(boolean shouldDelegateMouseEvents) {
        super(false);
        this.shouldDelegateMouseEvents = shouldDelegateMouseEvents;
    }

    public HiddenRowPanel() {
        this(true);
    }

    @Override
    public void setModel(RowModel<T> m) {
        super.setModel(m);
        this.installEditorPanel();
    }

    protected void installEditorPanel() {
        if (this.shouldDelegateMouseEvents) {
            RowModel aModel = this.model.getParentModel().getRowFactory().getRowModel(this.model.getParentModel(), false, this.model.getNode());
            this.hiddenEditor = this.model.getParentModel().getRowFactory().getRowPanel(aModel, false, false);
            this.hiddenEditor.setIsHidden(true);
            aModel.setAddRow(true);
            this.hiddenEditor.setModel(aModel);
            this.mouseDispatcher = this.hiddenEditor;
            aModel.setView(this.hiddenEditor);
            aModel.setParentModel(this.model.getParentModel());
            aModel.setCellFactory(new CellFactory());
            this.hiddenEditor.setProgress(1.0f);
            this.addMouseListener(this.mouseDispatcher);
            if (this.mouseDispatcher != this) {
                this.addMouseListener(this);
            }
        } else {
            this.addMouseListener(this);
        }
    }

    @Override
    protected void delegateNodeReset(Node node) {
        if (this.hiddenEditor != null) {
            this.hiddenEditor.getModel().setNode(node);
        }
    }

    public RowPanel<T> getHiddenEditor() {
        return this.hiddenEditor;
    }
}

