/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.gui.table.CellEditor;
import ch.icit.pegasus.client.gui.table.CellModel;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CellPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int STATE_EDITOR = 3;
    public static final int STATE_RENDERER = 4;
    private CellModel model;
    private CellRenderer currentView;
    private CellEditor currentEditor;
    private int currentState = -1;
    private boolean isKilled;

    public CellPanel() {
        this.setLayout(null);
        this.setOpaque(false);
    }

    public CellModel getModel() {
        return this.model;
    }

    public String getStringValue() {
        return this.currentView.getStringValue();
    }

    public void willExpand(boolean isExpand) {
        if (this.currentView != null) {
            this.currentView.willExpand(isExpand);
        }
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.currentView != null) {
            this.currentView.kill();
            this.currentView = null;
        }
        if (this.currentEditor != null) {
            this.currentEditor.kill();
            this.currentEditor = null;
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (this.currentState == 4) {
            if (this.currentView != null) {
                this.currentView.setSize(width, height);
            }
        } else if (this.currentEditor != null) {
            this.currentEditor.setSize(width, height);
        }
        super.setSize(width, height);
    }

    public CellRenderer getRenderer() {
        return this.currentView;
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
    }

    protected void updateView() {
        this.setSize(this.model.getCellWidth(), this.model.getCellHeight());
    }

    public void setState(int state, boolean withReset) {
        if (state == this.currentState && !withReset) {
            return;
        }
        if (this.currentView != null) {
            this.currentView.setVisible(false);
            this.remove(this.currentView);
        }
        if (this.currentEditor != null) {
            this.currentEditor.setVisible(false);
            this.remove(this.currentEditor);
        }
        if (state == 4) {
            this.currentView = this.model.getParentModel().isHeader() ? (CellRenderer)this.model.getCellFactory().getCellView(state, String.class, this.model.getColumnInfo().getColumnName(), this.model, this.model.getParentModel().getView()) : (CellRenderer)this.model.getCellFactory().getCellView(state, this.model.getCellClass(), this.model.getData(), this.model, this.model.getParentModel().getView());
            if (this.model.getParentModel().getColumnIndex(this.model) == 0) {
                this.currentView.setIsFirstColumn(true);
            } else {
                this.currentView.setIsFirstColumn(false);
            }
            this.currentView.setLocation(0, 0);
            this.setSize(this.model.getCellWidth(), this.model.getCellHeight());
            this.add(this.currentView);
            this.currentView.setVisible(this.isVisible());
        } else if (state == 3) {
            this.currentEditor = (CellEditor)this.model.getCellFactory().getCellView(state, this.model.getCellClass(), this.model.getData(), this.model, this.model.getParentModel().getView());
            if (this.model.getParentModel().getColumnIndex(this.model) == 0) {
                this.currentEditor.setIsFristColumn(true);
            } else {
                this.currentEditor.setIsFristColumn(false);
            }
            this.currentEditor.setLocation(0, 0);
            this.setSize(this.model.getCellWidth(), this.model.getCellHeight());
            this.add(this.currentEditor);
            this.currentEditor.setVisible(this.isVisible());
        }
        this.currentState = state;
    }

    public void setModel(CellModel m) {
        this.model = m;
    }

    private MouseEvent transformMouseEvent(MouseEvent e, Component target) {
        Point np = SwingUtilities.convertPoint(this, new Point(e.getX(), e.getY()), target);
        MouseEvent ne = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), (int)np.getX(), (int)np.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return ne;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.getParent() instanceof MouseListener) {
            ((MouseListener)((Object)this.getParent())).mouseClicked(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.getParent() instanceof MouseListener) {
            ((MouseListener)((Object)this.getParent())).mouseEntered(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.getParent() instanceof MouseListener) {
            ((MouseListener)((Object)this.getParent())).mouseExited(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.getParent() instanceof MouseListener) {
            ((MouseListener)((Object)this.getParent())).mousePressed(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.getParent() instanceof MouseListener) {
            ((MouseListener)((Object)this.getParent())).mouseReleased(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getParent() instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.getParent())).mouseDragged(this.transformMouseEvent(e, this.getParent()));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getParent() instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.getParent())).mouseMoved(this.transformMouseEvent(e, this.getParent()));
        }
    }

    public int getState() {
        return this.currentState;
    }
}

