/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.labelprint.utils;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.AlaCarteMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ILabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ItemLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.SpecialMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintingPopup<D extends FlightLight>
extends DefaultScrollablePrintPopup2<D> {
    private static final long serialVersionUID = 1L;
    private final Node<D> flightNode;
    private final List<ILabelComplete> idsToPrint;
    private final boolean isSPML;

    public PrintingPopup(Node<D> flightNode, List<ILabelComplete> idsToPrint, boolean isSPML, boolean withPrintDialog) {
        super(true, true, withPrintDialog, false, null);
        this.flightNode = flightNode;
        this.idsToPrint = idsToPrint;
        this.isSPML = isSPML;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.popup.enableOKButton(true);
        this.popup.setOkButtonText(Words.CLOSE);
        this.popup.enableCancelButton(false);
        this.popup.disablePreviewButton();
        this.popup.setCancelButtonText(Words.CANCEL);
        super.errorOccurred(exception);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        if (this.isError) {
            o[0] = false;
            return o;
        }
        o[0] = true;
        o[1] = this.idsToPrint;
        return o;
    }

    @Override
    protected String getNumberOfSavedCopies() {
        return "1";
    }

    @Override
    public String getTitleString() {
        return Words.PRINT_LABEL;
    }

    @Override
    public String getTitleValue() {
        return (String)this.flightNode.getChildNamed(FlightLight_.outboundCode).getValue();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (PrintingPopup.this.isSPML) {
                    ArrayList<SpecialMealLabelComplete> a = new ArrayList<SpecialMealLabelComplete>();
                    ArrayList<AlaCarteMealLabelComplete> b = new ArrayList<AlaCarteMealLabelComplete>();
                    for (ILabelComplete l : PrintingPopup.this.idsToPrint) {
                        if (l instanceof SpecialMealLabelComplete) {
                            a.add((SpecialMealLabelComplete)l);
                            continue;
                        }
                        if (!(l instanceof AlaCarteMealLabelComplete)) continue;
                        b.add((AlaCarteMealLabelComplete)l);
                    }
                    List o = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createSpecialMealLabels((FlightReference)PrintingPopup.this.flightNode.getValue(), new ListWrapper(a), ReportingOutputFormatE.PDF).getList();
                    List o2 = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createAlaCarteMealLabels((FlightReference)PrintingPopup.this.flightNode.getValue(), new ListWrapper(b), ReportingOutputFormatE.PDF).getList();
                    ArrayList merged = new ArrayList(o);
                    merged.addAll(o2);
                    for (PegasusFileComplete t : merged) {
                        PrintingPopup.this.processFile(t);
                    }
                    Node node = new Node();
                    node.setValue((Object)true, 0L);
                    return node;
                }
                ArrayList<ItemLabelComplete> a = new ArrayList<ItemLabelComplete>();
                for (Object l : PrintingPopup.this.idsToPrint) {
                    if (!(l instanceof ItemLabelComplete)) continue;
                    a.add((ItemLabelComplete)l);
                }
                List o = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createItemLabels((FlightReference)PrintingPopup.this.flightNode.getValue(), new ListWrapper(a), ReportingOutputFormatE.PDF).getList();
                for (PegasusFileComplete t : o) {
                    PrintingPopup.this.processFile(t);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintingPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<D> getCurrentNode() {
        return this.flightNode;
    }

    @Override
    public BatchJob<D> createBatchJob(Node<D> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintingPopup.this.layoutInheritedComponents(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 10;
            int h = PrintingPopup.this.getInheritedComponentsHeight() + border;
            return new Dimension(0, h);
        }
    }
}

