/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.equipmentconf;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.AbstractGalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.BoxInfoButton;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.ToggleBoxButton;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class EquipmentGalleyBoxEditor
extends AbstractGalleyBoxEditor
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    public static final int STATE_NONE = 3;
    public static final int STATE_TOGGLE = 5;
    private int currentState = -1;
    private BoxInfoButton info;
    private ToggleBoxButton toggle;
    private boolean toogleIsVisible = false;
    private PegasusSubModule pegasus;

    public EquipmentGalleyBoxEditor(PegasusSubModule peg) {
        this.pegasus = peg;
        this.getFader().setPermanent(true);
        this.mover = new Mover<EquipmentGalleyBoxEditor>(this);
        this.resizer = new Resizer<EquipmentGalleyBoxEditor>(this);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.info = new BoxInfoButton();
        this.info.setVisible(false);
        this.info.getFader().setPermanent(true);
        this.info.addButtonListener(this);
        this.toggle = new ToggleBoxButton();
        this.toggle.setVisible(false);
        this.toggle.getFader().setPermanent(true);
        this.toggle.addButtonListener(this);
        this.currentIcon = this.toggle;
        this.setProgress(0.0f);
        this.add(this.info);
        this.add(this.toggle);
        this.info.fadeIn();
        this.setState(5);
    }

    @Override
    public int getHalfIconWidth() {
        if (this.info != null) {
            return this.info.getWidth() / 2;
        }
        if (this.toggle != null) {
            return this.toggle.getWidth() / 2;
        }
        return 0;
    }

    @Override
    public int getXOffset() {
        return this.currentIcon.getWidth() / 2;
    }

    @Override
    public int getYOffset() {
        return this.currentIcon.getHeight() / 2;
    }

    public void showIcon(boolean isShowIcon) {
        if (isShowIcon) {
            this.setState(5);
        } else {
            this.setState(3);
        }
    }

    @Override
    public void setState(int state) {
        this.currentIcon.removeButtonListener(this);
        this.currentIcon.setVisible(false);
        switch (state) {
            case 5: {
                this.currentIcon = this.toggle;
                break;
            }
            case 3: {
                this.toogleIsVisible = false;
                this.currentIcon.fadeOut(false);
            }
        }
        this.currentState = state;
        if (this.currentState != 3) {
            if (this.currentIcon == this.toggle && !this.toogleIsVisible) {
                this.toogleIsVisible = true;
                this.currentIcon.fadeIn();
            }
            this.currentIcon.setVisible(true);
            this.currentIcon.addButtonListener(this);
        }
        this.repaint(32L);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.info.kill();
        this.toggle.kill();
        this.info.removeButtonListener(this);
        this.toggle.removeButtonListener(this);
        this.info = null;
        this.toggle = null;
    }

    @Override
    public Mover<?> getMover() {
        return this.mover;
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    @Override
    public Resizer<?> getResizer() {
        return this.resizer;
    }

    @Override
    public void setSizeSmooth(int w, int h) {
        this.resizer.setSizeSmooth(w, h);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.info) {
            Point screenPoint = SwingUtilities.convertPoint(this.info, new Point(x, y), this.pegasus);
            this.pegasus.showEquipmentConfigurationPopUp(source, (int)screenPoint.getX(), (int)screenPoint.getY());
        } else {
            switch (this.currentState) {
                case 5: {
                    Point screenPoint = SwingUtilities.convertPoint(this.currentIcon, new Point(x, y), this.pegasus);
                    this.pegasus.useAlternative((int)screenPoint.getX(), (int)screenPoint.getY());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (EquipmentGalleyBoxEditor.this.pegasus.isLocked()) {
                EquipmentGalleyBoxEditor.this.currentIcon.setVisible(false);
            } else {
                EquipmentGalleyBoxEditor.this.currentIcon.setVisible(true);
            }
            if (EquipmentGalleyBoxEditor.this.currentState != 3) {
                EquipmentGalleyBoxEditor.this.currentIcon.setLocation((int)((double)parent.getWidth() - EquipmentGalleyBoxEditor.this.currentIcon.getPreferredSize().getWidth()), 0);
                EquipmentGalleyBoxEditor.this.currentIcon.setSize(EquipmentGalleyBoxEditor.this.currentIcon.getPreferredSize());
            }
            if (EquipmentGalleyBoxEditor.this.isSplitUse) {
                if (EquipmentGalleyBoxEditor.this.isUpperSelect) {
                    EquipmentGalleyBoxEditor.this.info.setLocation(0, 0);
                    EquipmentGalleyBoxEditor.this.info.setSize(EquipmentGalleyBoxEditor.this.info.getPreferredSize());
                } else {
                    EquipmentGalleyBoxEditor.this.info.setLocation((int)((double)parent.getWidth() - EquipmentGalleyBoxEditor.this.info.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - EquipmentGalleyBoxEditor.this.info.getPreferredSize().getHeight()));
                    EquipmentGalleyBoxEditor.this.info.setSize(EquipmentGalleyBoxEditor.this.info.getPreferredSize());
                }
            } else {
                EquipmentGalleyBoxEditor.this.info.setLocation(0, (int)((double)parent.getHeight() - EquipmentGalleyBoxEditor.this.info.getPreferredSize().getHeight()));
                EquipmentGalleyBoxEditor.this.info.setSize(EquipmentGalleyBoxEditor.this.info.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

