/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.truck;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.TrackingReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.TruckBarcodeReportConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class PrintTruckBarcodeComponent
extends DefaultScrollablePrintPopup2<TruckComplete> {
    private static final long serialVersionUID = 1L;
    private final Node<TruckComplete> truck;

    public PrintTruckBarcodeComponent(Node<TruckComplete> node) {
        super(false, false, ReportTypeE.TRUCK);
        this.truck = node;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public String getTitleString() {
        return "Truck Barcode";
    }

    @Override
    public String getTitleValue() {
        return ((TruckComplete)this.truck.getValue()).getMatriculation();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintTruckBarcodeComponent.this.getSelectedReport();
                TruckBarcodeReportConfiguration config = new TruckBarcodeReportConfiguration();
                config.setFormat(ReportingOutputFormatE.PDF);
                config.setTruck((TruckComplete)PrintTruckBarcodeComponent.this.truck.getValue());
                config.setStylesheet(file);
                config.setReportType(ReportTypeE.TRUCK);
                PegasusFileComplete t = (PegasusFileComplete)((TrackingReportServiceManager)ServiceManagerRegistry.getService(TrackingReportServiceManager.class)).createTruckBarcodeReport(config).getValue();
                PrintTruckBarcodeComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintTruckBarcodeComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<TruckComplete> getCurrentNode() {
        return this.truck;
    }

    @Override
    public BatchJob<TruckComplete> createBatchJob(Node<TruckComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintTruckBarcodeComponent.this.layoutInheritedComponents(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintTruckBarcodeComponent.this.getInheritedComponentsHeight();
            int w = 0;
            return new Dimension(w, h);
        }
    }
}

