/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.catalog;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductCatalogReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;

class PrintProductCatalogComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight> {
    private static final long serialVersionUID = 1L;
    private ProductCatalogLight currentProductCatalog;
    private ProductCatalogComplete currentCatalogComplete;
    private TitledItem<CheckBox> showIngredients;
    private TitledItem<CheckBox> showPricing;
    private RadioButtonBox nameBox;
    private TitledItem<RadioButton> useEnglishNames;
    private TitledItem<RadioButton> useProductCatalogName;
    private TitledItem<RadioButton> useArticleName;
    private TitledItem<CheckBox> showDescription;
    private TitledItem<CheckBox> showItemNumbers;
    private TitledItem<CheckBox> showArticlesFromRecipeInsteadOfRecipe;
    private TitledItem<CheckBox> skipFirstRecipeIfThereIsOnlyOne;
    private TitledItem<CheckBox> showQuantity;
    private TitledItem<CheckBox> showTraces;
    private TitledItem<CheckBox> showAdditives;
    private TitledItem<CheckBox> showOtherDeclarations;
    private TitledItem<CheckBox> showComponentComments;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> sortByMealPlan;
    private TitledItem<RadioButtonBox> sortDirection;
    private TitledItem<RadioButton> sortByNumber;
    private TitledItem<RadioButton> sortByName;
    private TitledItem<RadioButton> sortByQuantity;
    private TitledItem<RadioButton> sortBySequence;
    private TitledItem<CheckBox> useHighDefImages;

    PrintProductCatalogComponent(ProductCatalogLight currentDTO) {
        super(false, false, ReportTypeE.PRODUCT_CATALOG);
        this.currentProductCatalog = currentDTO;
        this.loadBeforeShowing(() -> {
            try {
                this.currentCatalogComplete = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductCatalog(new ProductCatalogReference(this.currentProductCatalog.getId())).getValue();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        });
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals("dueDate")) {
                try {
                    long l = Long.valueOf(v);
                    this.dueDate.getElement().getNode().setValue((Object)new Date(l), 0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n.equals("showPrice") && this.showPricing != null) {
                this.showPricing.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("showProductDescription")) {
                this.showDescription.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("showItemNumber")) {
                this.showItemNumbers.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("showQuantity")) {
                this.showQuantity.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("showComponentComments")) {
                this.showComponentComments.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("showArticlesInsteadOfRecipe")) {
                this.showArticlesFromRecipeInsteadOfRecipe.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("skipFirstRecipeIfThereIsOnlyOne")) {
                this.skipFirstRecipeIfThereIsOnlyOne.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("sortByNumber")) {
                this.sortByNumber.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("sortByName")) {
                this.sortByName.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("sortByQuantity")) {
                this.sortByQuantity.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("sortBySequence")) {
                this.sortBySequence.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("useEnglishName")) {
                this.useEnglishNames.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("useCatalogName")) {
                this.useProductCatalogName.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("useArticleName")) {
                this.useArticleName.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("useHighDefImagse")) {
                this.useHighDefImages.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("traces")) {
                this.showTraces.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("additives")) {
                this.showAdditives.getElement().setChecked(Boolean.valueOf(v));
            }
            if (n.equals("others")) {
                this.showOtherDeclarations.getElement().setChecked(Boolean.valueOf(v));
            }
            if (!n.equals("showIngredients")) continue;
            this.showIngredients.getElement().setChecked(Boolean.valueOf(v));
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("dueDate", "" + this.dueDate.getElement().getNode().getValue());
        if (this.showPricing != null) {
            conf.addProperty("showPrice", "" + this.showPricing.getElement().isChecked());
        }
        conf.addProperty("showProductDescription", "" + this.showDescription.getElement().isChecked());
        conf.addProperty("showItemNumber", "" + this.showItemNumbers.getElement().isChecked());
        conf.addProperty("showQuantity", "" + this.showQuantity.getElement().isChecked());
        conf.addProperty("showComponentComments", "" + this.showComponentComments.getElement().isChecked());
        conf.addProperty("showArticlesInsteadOfRecipe", "" + this.showArticlesFromRecipeInsteadOfRecipe.getElement().isChecked());
        conf.addProperty("skipFirstRecipeIfThereIsOnlyOne", "" + this.skipFirstRecipeIfThereIsOnlyOne.getElement().isChecked());
        conf.addProperty("sortByNumber", "" + this.sortByNumber.getElement().isChecked());
        conf.addProperty("sortByName", "" + this.sortByName.getElement().isChecked());
        conf.addProperty("sortByQuantity", "" + this.sortByQuantity.getElement().isChecked());
        conf.addProperty("sortBySequence", "" + this.sortBySequence.getElement().isChecked());
        conf.addProperty("useEnglishName", "" + this.useEnglishNames.getElement().isChecked());
        conf.addProperty("useArticleName", "" + this.useArticleName.getElement().isChecked());
        conf.addProperty("useCatalogName", "" + this.useProductCatalogName.getElement().isChecked());
        conf.addProperty("useHighDefImagse", "" + this.useHighDefImages.getElement().isChecked());
        conf.addProperty("traces", "" + this.showTraces.getElement().isChecked());
        conf.addProperty("additives", "" + this.showAdditives.getElement().isChecked());
        conf.addProperty("others", "" + this.showOtherDeclarations.getElement().isChecked());
        conf.addProperty("showIngredients", "" + this.showIngredients.getElement().isChecked());
        return conf;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.getViewContainer().setLayout(new Layout());
        Calendar cal = TimeUtil.createCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        Date today = new Date(cal.getTimeInMillis());
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)today, false, false)), "Due Date", TitledItem.TitledItemOrientation.NORTH);
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
        boolean sp = false;
        for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
            if (!a.getField().getName().equals(ProductCatalogAccess.SHOW_PRODUCT_SALES.getFieldName())) continue;
            sp = true;
        }
        if (sp) {
            this.showPricing = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.getViewContainer().add(this.showPricing);
        }
        this.nameBox = new RadioButtonBox();
        this.nameBox.setBorder(this.border / 4);
        this.useEnglishNames = new TitledItem<RadioButton>(new RadioButton(), Words.USE_ENGLISH_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductCatalogName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_CATALOG_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useArticleName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_ARTICLE_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductCatalogName.getElement().setChecked(true);
        this.nameBox.addBox(this.useArticleName, this.useArticleName.getElement());
        this.nameBox.addBox(this.useProductCatalogName, this.useProductCatalogName.getElement());
        this.nameBox.addBox(this.useEnglishNames, this.useEnglishNames.getElement());
        this.showDescription = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCT_DESCRIPTION, TitledItem.TitledItemOrientation.EAST);
        this.showQuantity = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_QUANTITY, TitledItem.TitledItemOrientation.EAST);
        this.showQuantity.getElement().setChecked(true);
        this.showTraces = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_TRACES, TitledItem.TitledItemOrientation.EAST);
        this.showAdditives = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ADDITIVES, TitledItem.TitledItemOrientation.EAST);
        this.showOtherDeclarations = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_OTHER_DECLARATION, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.showAdditives);
        this.getViewContainer().add(this.showOtherDeclarations);
        if (this.currentCatalogComplete != null && this.currentCatalogComplete.getMealPlan() != null) {
            this.sortByMealPlan = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_PRODUCTS_BY_MEALPLAN, TitledItem.TitledItemOrientation.EAST);
        }
        this.showComponentComments = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_COMPONENTS_COMMENTS, TitledItem.TitledItemOrientation.EAST);
        this.useHighDefImages = new TitledItem<CheckBox>(new CheckBox(), Words.USE_HIGH_DEF_IMAGES, TitledItem.TitledItemOrientation.EAST);
        this.showItemNumbers = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ITEM_NO, TitledItem.TitledItemOrientation.EAST);
        this.showItemNumbers.getElement().setChecked(true);
        this.showArticlesFromRecipeInsteadOfRecipe = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ARTICLES_INSTAED_OF_RECIPE, TitledItem.TitledItemOrientation.EAST);
        this.showArticlesFromRecipeInsteadOfRecipe.getElement().addButtonListener(this);
        this.skipFirstRecipeIfThereIsOnlyOne = new TitledItem<CheckBox>(new CheckBox(), "Show Recipe Content", TitledItem.TitledItemOrientation.EAST);
        this.skipFirstRecipeIfThereIsOnlyOne.getElement().addButtonListener(this);
        this.sortDirection = new TitledItem<RadioButtonBox>(new RadioButtonBox(), Words.INGREDIENT_SORT_DIRECTION, TitledItem.TitledItemOrientation.NORTH);
        this.sortDirection.getElement().setBorder(this.border / 4);
        this.sortByNumber = new TitledItem<RadioButton>(new RadioButton(), Words.SORT_BY_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.sortByName = new TitledItem<RadioButton>(new RadioButton(), Words.SORT_BY_NAME, TitledItem.TitledItemOrientation.EAST);
        this.sortByQuantity = new TitledItem<RadioButton>(new RadioButton(), Words.SORT_BY_QUANTITY, TitledItem.TitledItemOrientation.EAST);
        this.sortBySequence = new TitledItem<RadioButton>(new RadioButton(), Words.SORT_BY_SEQUENCE, TitledItem.TitledItemOrientation.EAST);
        this.sortByQuantity.getElement().setChecked(true);
        this.sortDirection.getElement().addBox(this.sortByNumber, this.sortByNumber.getElement());
        this.sortDirection.getElement().addBox(this.sortByName, this.sortByName.getElement());
        this.sortDirection.getElement().addBox(this.sortByQuantity, this.sortByQuantity.getElement());
        this.sortDirection.getElement().addBox(this.sortBySequence, this.sortBySequence.getElement());
        this.showIngredients = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_INGREDIENTS, TitledItem.TitledItemOrientation.EAST);
        this.showIngredients.getElement().setChecked(true);
        this.getViewContainer().add(this.showTraces);
        this.getViewContainer().add(this.showQuantity);
        this.getViewContainer().add(this.nameBox);
        this.getViewContainer().add(this.showDescription);
        this.getViewContainer().add(this.showComponentComments);
        this.getViewContainer().add(this.useHighDefImages);
        this.getViewContainer().add(this.showItemNumbers);
        this.getViewContainer().add(this.showArticlesFromRecipeInsteadOfRecipe);
        this.getViewContainer().add(this.skipFirstRecipeIfThereIsOnlyOne);
        this.getViewContainer().add(this.sortDirection);
        this.getViewContainer().add(this.dueDate);
        if (this.sortByMealPlan != null) {
            this.getViewContainer().add(this.sortByMealPlan);
        }
        this.getViewContainer().add(this.showIngredients);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_CATALOG;
    }

    @Override
    public String getTitleValue() {
        return this.currentProductCatalog.getTitle();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.showIngredients != null) {
            this.showIngredients.setVisible(true);
        }
        if (this.showPricing != null) {
            this.showPricing.setVisible(true);
        }
        if (this.useEnglishNames != null) {
            this.useEnglishNames.setVisible(true);
        }
        if (this.useProductCatalogName != null) {
            this.useProductCatalogName.setVisible(true);
        }
        if (this.useArticleName != null) {
            this.useArticleName.setVisible(true);
        }
        if (this.showDescription != null) {
            this.showDescription.setVisible(true);
        }
        if (this.showItemNumbers != null) {
            this.showItemNumbers.setVisible(true);
        }
        if (this.showQuantity != null) {
            this.showQuantity.setVisible(true);
        }
        if (this.showTraces != null) {
            this.showTraces.setVisible(true);
        }
        if (this.showAdditives != null) {
            this.showAdditives.setVisible(true);
        }
        if (this.showOtherDeclarations != null) {
            this.showOtherDeclarations.setVisible(true);
        }
        if (this.sortByMealPlan != null) {
            this.sortByMealPlan.setVisible(true);
        }
        if (this.showComponentComments != null) {
            this.showComponentComments.setVisible(true);
        }
        if (this.useHighDefImages != null) {
            this.useHighDefImages.setVisible(true);
        }
        if (this.showArticlesFromRecipeInsteadOfRecipe != null) {
            this.showArticlesFromRecipeInsteadOfRecipe.setVisible(true);
        }
        if (this.skipFirstRecipeIfThereIsOnlyOne != null) {
            this.skipFirstRecipeIfThereIsOnlyOne.setVisible(true);
        }
        if (this.sortDirection != null) {
            this.sortDirection.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.showIngredients != null) {
            this.showIngredients.setVisible(false);
        }
        if (this.showPricing != null) {
            this.showPricing.setVisible(false);
        }
        if (this.useEnglishNames != null) {
            this.useEnglishNames.setVisible(false);
        }
        if (this.useProductCatalogName != null) {
            this.useProductCatalogName.setVisible(false);
        }
        if (this.useArticleName != null) {
            this.useArticleName.setVisible(false);
        }
        if (this.showItemNumbers != null) {
            this.showItemNumbers.setVisible(false);
        }
        if (this.showQuantity != null) {
            this.showQuantity.setVisible(false);
        }
        if (this.showDescription != null) {
            this.showDescription.setVisible(false);
        }
        if (this.showTraces != null) {
            this.showTraces.setVisible(false);
        }
        if (this.showAdditives != null) {
            this.showAdditives.setVisible(false);
        }
        if (this.showOtherDeclarations != null) {
            this.showOtherDeclarations.setVisible(false);
        }
        if (this.sortByMealPlan != null) {
            this.sortByMealPlan.setVisible(false);
        }
        if (this.showComponentComments != null) {
            this.showComponentComments.setVisible(false);
        }
        if (this.useHighDefImages != null) {
            this.useHighDefImages.setVisible(false);
        }
        if (this.showArticlesFromRecipeInsteadOfRecipe != null) {
            this.showArticlesFromRecipeInsteadOfRecipe.setVisible(false);
        }
        if (this.skipFirstRecipeIfThereIsOnlyOne != null) {
            this.skipFirstRecipeIfThereIsOnlyOne.setVisible(false);
        }
        if (this.sortDirection != null) {
            this.sortDirection.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogReportConfiguration pcc = new ProductCatalogReportConfiguration(ReportTypeE.PRODUCT_CATALOG, ReportingOutputFormatE.PDF, PrintProductCatalogComponent.this.getSelectedReport());
                pcc.setDto((IDTO)new ProductCatalogReference(PrintProductCatalogComponent.this.currentProductCatalog.getId()));
                if (((DateChooser)PrintProductCatalogComponent.this.dueDate.getElement()).getNode().getValue() instanceof Date) {
                    pcc.setDueDate((Date)((DateChooser)PrintProductCatalogComponent.this.dueDate.getElement()).getNode().getValue());
                } else {
                    Timestamp timestamp = (Timestamp)((DateChooser)PrintProductCatalogComponent.this.dueDate.getElement()).getNode().getValue();
                    pcc.setDueDate(new Date(timestamp.getTime()));
                }
                if (PrintProductCatalogComponent.this.showIngredients != null) {
                    pcc.setShowIngredients(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showIngredients.getElement()).isChecked()));
                } else {
                    pcc.setShowIngredients(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showPricing != null) {
                    pcc.setIncludePrices(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showPricing.getElement()).isChecked()));
                } else {
                    pcc.setIncludePrices(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.useEnglishNames != null) {
                    pcc.setUseEnglishName(Boolean.valueOf(((RadioButton)PrintProductCatalogComponent.this.useEnglishNames.getElement()).isChecked()));
                } else {
                    pcc.setUseEnglishName(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.useArticleName != null) {
                    pcc.useArticleName(((RadioButton)PrintProductCatalogComponent.this.useArticleName.getElement()).isChecked());
                } else {
                    pcc.useArticleName(false);
                }
                if (PrintProductCatalogComponent.this.useProductCatalogName != null) {
                    pcc.useProductCatalogName(Boolean.valueOf(((RadioButton)PrintProductCatalogComponent.this.useProductCatalogName.getElement()).isChecked()));
                } else {
                    pcc.useProductCatalogName(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showDescription != null) {
                    pcc.setShowProductDescrption(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showDescription.getElement()).isChecked()));
                } else {
                    pcc.setShowProductDescrption(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showTraces != null) {
                    pcc.setShowTraces(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showTraces.getElement()).isChecked()));
                } else {
                    pcc.setShowTraces(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showAdditives != null) {
                    pcc.setShowAdditive(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showAdditives.getElement()).isChecked()));
                } else {
                    pcc.setShowAdditive(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showOtherDeclarations != null) {
                    pcc.setShowOthers(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showOtherDeclarations.getElement()).isChecked()));
                } else {
                    pcc.setShowOthers(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.sortByMealPlan != null) {
                    pcc.setSortByMealPlan(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.sortByMealPlan.getElement()).isChecked()));
                } else {
                    pcc.setSortByMealPlan(Boolean.valueOf(false));
                }
                if (PrintProductCatalogComponent.this.showComponentComments != null) {
                    pcc.setShowComponentComments(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showComponentComments.getElement()).isChecked()));
                }
                if (PrintProductCatalogComponent.this.useHighDefImages != null) {
                    pcc.setUseHighDefImage(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.useHighDefImages.getElement()).isChecked()));
                }
                if (PrintProductCatalogComponent.this.showItemNumbers != null) {
                    pcc.setShowItemNumbers(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showItemNumbers.getElement()).isChecked()));
                }
                if (PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe != null) {
                    pcc.setShowRecipeDetails(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.getElement()).isChecked()));
                }
                if (PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne != null) {
                    pcc.setShowRecipeContent(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.getElement()).isChecked()));
                }
                if (PrintProductCatalogComponent.this.showQuantity != null) {
                    pcc.setShowQuantity(Boolean.valueOf(((CheckBox)PrintProductCatalogComponent.this.showQuantity.getElement()).isChecked()));
                }
                if (((RadioButton)PrintProductCatalogComponent.this.sortByQuantity.getElement()).isChecked()) {
                    pcc.setSortIngredientByQuantity(Boolean.valueOf(true));
                }
                if (((RadioButton)PrintProductCatalogComponent.this.sortByName.getElement()).isChecked()) {
                    pcc.setSortIngredientByName(Boolean.valueOf(true));
                }
                if (((RadioButton)PrintProductCatalogComponent.this.sortByNumber.getElement()).isChecked()) {
                    pcc.setSortIngredientByNumber(Boolean.valueOf(true));
                }
                if (((RadioButton)PrintProductCatalogComponent.this.sortBySequence.getElement()).isChecked()) {
                    pcc.setSortIngredientBySequence(Boolean.valueOf(true));
                }
                pcc.setRebuildCatalog(PrintProductCatalogComponent.this.currentCatalogComplete.getAutoGenerated());
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductCatalogReport(pcc).getValue();
                PrintProductCatalogComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.showArticlesFromRecipeInsteadOfRecipe != null) {
            if (this.showArticlesFromRecipeInsteadOfRecipe.getElement().isChecked()) {
                this.sortBySequence.setEnabled(false);
                if (this.sortBySequence.getElement().isChecked()) {
                    this.sortByNumber.getElement().setChecked(true);
                }
            } else {
                this.sortBySequence.setEnabled(isEnabled);
            }
        }
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)this.currentProductCatalog, false, false);
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductCatalogComponent.this.layoutInheritedComponents(parent) + PrintProductCatalogComponent.this.border;
            PrintProductCatalogComponent.this.dueDate.setLocation(PrintProductCatalogComponent.this.border, y + PrintProductCatalogComponent.this.border);
            PrintProductCatalogComponent.this.dueDate.setSize(PrintProductCatalogComponent.this.dueDate.getPreferredSize());
            y = PrintProductCatalogComponent.this.dueDate.getY() + PrintProductCatalogComponent.this.dueDate.getHeight() + PrintProductCatalogComponent.this.border;
            if (PrintProductCatalogComponent.this.showIngredients != null) {
                PrintProductCatalogComponent.this.showIngredients.setLocation(PrintProductCatalogComponent.this.border, y + PrintProductCatalogComponent.this.border);
                PrintProductCatalogComponent.this.showIngredients.setSize(PrintProductCatalogComponent.this.showIngredients.getPreferredSize());
                y = PrintProductCatalogComponent.this.showIngredients.getY() + PrintProductCatalogComponent.this.showIngredients.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showPricing != null) {
                PrintProductCatalogComponent.this.showPricing.setLocation(PrintProductCatalogComponent.this.border, y + PrintProductCatalogComponent.this.border);
                PrintProductCatalogComponent.this.showPricing.setSize(PrintProductCatalogComponent.this.showPricing.getPreferredSize());
                y = PrintProductCatalogComponent.this.showPricing.getY() + PrintProductCatalogComponent.this.showPricing.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showDescription != null) {
                PrintProductCatalogComponent.this.showDescription.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showDescription.setSize(PrintProductCatalogComponent.this.showDescription.getPreferredSize());
                y = PrintProductCatalogComponent.this.showDescription.getY() + PrintProductCatalogComponent.this.showDescription.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showItemNumbers != null) {
                PrintProductCatalogComponent.this.showItemNumbers.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showItemNumbers.setSize(PrintProductCatalogComponent.this.showItemNumbers.getPreferredSize());
                y = PrintProductCatalogComponent.this.showItemNumbers.getY() + PrintProductCatalogComponent.this.showItemNumbers.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showQuantity != null) {
                PrintProductCatalogComponent.this.showQuantity.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showQuantity.setSize(PrintProductCatalogComponent.this.showQuantity.getPreferredSize());
                y = PrintProductCatalogComponent.this.showQuantity.getY() + PrintProductCatalogComponent.this.showQuantity.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showComponentComments != null) {
                PrintProductCatalogComponent.this.showComponentComments.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showComponentComments.setSize(PrintProductCatalogComponent.this.showComponentComments.getPreferredSize());
                y = PrintProductCatalogComponent.this.showComponentComments.getY() + PrintProductCatalogComponent.this.showComponentComments.getHeight() + PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe != null) {
                PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.setSize(PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.getPreferredSize());
                y = PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.getY() + PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne != null) {
                PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.setSize(PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.getPreferredSize());
                y = PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.getY() + PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.sortDirection != null) {
                PrintProductCatalogComponent.this.sortDirection.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.sortDirection.setSize(PrintProductCatalogComponent.this.sortDirection.getPreferredSize());
                y = PrintProductCatalogComponent.this.sortDirection.getY() + PrintProductCatalogComponent.this.sortDirection.getHeight() + PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.nameBox != null) {
                PrintProductCatalogComponent.this.nameBox.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.nameBox.setSize(PrintProductCatalogComponent.this.nameBox.getPreferredSize());
                y = PrintProductCatalogComponent.this.nameBox.getY() + PrintProductCatalogComponent.this.nameBox.getHeight() + PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.useHighDefImages != null) {
                PrintProductCatalogComponent.this.useHighDefImages.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.useHighDefImages.setSize(PrintProductCatalogComponent.this.useHighDefImages.getPreferredSize());
                y = PrintProductCatalogComponent.this.useHighDefImages.getY() + PrintProductCatalogComponent.this.useHighDefImages.getHeight() + PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.showTraces != null) {
                PrintProductCatalogComponent.this.showTraces.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showTraces.setSize(PrintProductCatalogComponent.this.showTraces.getPreferredSize());
                y = PrintProductCatalogComponent.this.showTraces.getY() + PrintProductCatalogComponent.this.showTraces.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showAdditives != null) {
                PrintProductCatalogComponent.this.showAdditives.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showAdditives.setSize(PrintProductCatalogComponent.this.showAdditives.getPreferredSize());
                y = PrintProductCatalogComponent.this.showAdditives.getY() + PrintProductCatalogComponent.this.showAdditives.getHeight() + PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showOtherDeclarations != null) {
                PrintProductCatalogComponent.this.showOtherDeclarations.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.showOtherDeclarations.setSize(PrintProductCatalogComponent.this.showOtherDeclarations.getPreferredSize());
                y = PrintProductCatalogComponent.this.showOtherDeclarations.getY() + PrintProductCatalogComponent.this.showOtherDeclarations.getHeight() + PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.sortByMealPlan != null) {
                PrintProductCatalogComponent.this.sortByMealPlan.setLocation(PrintProductCatalogComponent.this.border, y);
                PrintProductCatalogComponent.this.sortByMealPlan.setSize(PrintProductCatalogComponent.this.sortByMealPlan.getPreferredSize());
                y = PrintProductCatalogComponent.this.sortByMealPlan.getY() + PrintProductCatalogComponent.this.sortByMealPlan.getHeight() + PrintProductCatalogComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogComponent.this.getInheritedComponentsHeight() + PrintProductCatalogComponent.this.border;
            h = (int)((double)h + PrintProductCatalogComponent.this.dueDate.getPreferredSize().getHeight());
            h += PrintProductCatalogComponent.this.border;
            if (PrintProductCatalogComponent.this.showIngredients != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showIngredients.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.showPricing != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showPricing.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showDescription != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showDescription.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showItemNumbers != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showItemNumbers.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showQuantity != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showQuantity.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showComponentComments != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showComponentComments.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showArticlesFromRecipeInsteadOfRecipe.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.skipFirstRecipeIfThereIsOnlyOne.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.sortDirection != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.sortDirection.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.nameBox != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.nameBox.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.useHighDefImages != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.useHighDefImages.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.showTraces != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showTraces.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showAdditives != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showAdditives.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border / 4;
            }
            if (PrintProductCatalogComponent.this.showOtherDeclarations != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.showOtherDeclarations.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            if (PrintProductCatalogComponent.this.sortByMealPlan != null) {
                h = (int)((double)h + PrintProductCatalogComponent.this.sortByMealPlan.getPreferredSize().getHeight());
                h += PrintProductCatalogComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

