/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.storeinfosheet;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.BasicArticleReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;

public class PrintArticleInfoSheetComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BasicArticleLight dto;
    private TitledItem<SearchTextField2<StoreLight>> storeSearchField;
    private TitledItem<DateChooser> dueDate;

    public PrintArticleInfoSheetComponent(BasicArticleLight dto) {
        super(false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
        this.dto = dto;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        SearchTextField2<StoreLight> searchField = SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode());
        searchField.setName("Store");
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.storeSearchField = new TitledItem<SearchTextField2<StoreLight>>(searchField, Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(false);
        this.getViewContainer().add(this.storeSearchField);
        this.getViewContainer().add(this.dueDate);
        this.createComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.storeSearchField.setVisible(false);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return this.dto.getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintArticleInfoSheetComponent.this.getSelectedReport();
                BasicArticleReportConfiguration config = new BasicArticleReportConfiguration();
                config.setArticle(new BasicArticleReference(PrintArticleInfoSheetComponent.this.dto.getId()));
                config.setStore((StoreReference)((SearchTextField2)PrintArticleInfoSheetComponent.this.storeSearchField.getElement()).getNode().getValue());
                config.setStylesheet(file);
                config.setDueDate((Date)((DateChooser)PrintArticleInfoSheetComponent.this.dueDate.getElement()).getNode().getValue());
                if (PrintArticleInfoSheetComponent.this.asXLS != null && ((RadioButton)PrintArticleInfoSheetComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createArticleInfoSheet(config).getValue();
                PrintArticleInfoSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleInfoSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleInfoSheetComponent.this.layoutInheritedComponents(parent) + PrintArticleInfoSheetComponent.this.border;
            PrintArticleInfoSheetComponent.this.dueDate.setLocation(PrintArticleInfoSheetComponent.this.border, y);
            PrintArticleInfoSheetComponent.this.dueDate.setSize(PrintArticleInfoSheetComponent.this.dueDate.getPreferredSize());
            y = PrintArticleInfoSheetComponent.this.dueDate.getY() + PrintArticleInfoSheetComponent.this.dueDate.getHeight() + PrintArticleInfoSheetComponent.this.border;
            PrintArticleInfoSheetComponent.this.storeSearchField.setLocation(PrintArticleInfoSheetComponent.this.border, y);
            PrintArticleInfoSheetComponent.this.storeSearchField.setSize(parent.getWidth() - 2 * PrintArticleInfoSheetComponent.this.border, ((PrintArticleInfoSheetComponent)PrintArticleInfoSheetComponent.this).storeSearchField.getPreferredSize().height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleInfoSheetComponent.this.getInheritedComponentsHeight();
            h += PrintArticleInfoSheetComponent.this.border;
            h = (int)((double)h + PrintArticleInfoSheetComponent.this.storeSearchField.getPreferredSize().getHeight());
            h += PrintArticleInfoSheetComponent.this.border;
            h = (int)((double)h + PrintArticleInfoSheetComponent.this.dueDate.getPreferredSize().getHeight());
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

