/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.article.forecast;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PrintArticleForecastComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> node;
    private TitledItem<DateTimeChooser> dateTimeChooser;
    private TitledItem<CheckBox> includeInventoryData;
    private TitledItem<CheckBox> includeStockData;

    public PrintArticleForecastComponent(Node<BasicArticleLight> node) {
        super(false, false, false, false, null);
        this.node = node;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.dateTimeChooser);
        CheckedListAdder.addToList(focusList, this.includeInventoryData);
        CheckedListAdder.addToList(focusList, this.includeStockData);
        return focusList;
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return ((BasicArticleLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[12];
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.dateTimeChooser = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateTimeChooser.getElement().getNode().addNodeListener((NodeListener)this);
        this.includeInventoryData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_INVENTORY_DATA, TitledItem.TitledItemOrientation.EAST);
        this.includeStockData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOCK_DATA, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.dateTimeChooser);
        this.getViewContainer().add(this.includeInventoryData);
        this.getViewContainer().add(this.includeStockData);
        this.createComponents();
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<BasicArticleReference> articles = new ArrayList<BasicArticleReference>();
                articles.add(new BasicArticleReference(((BasicArticleLight)PrintArticleForecastComponent.this.node.getValue()).getId()));
                boolean iInventory = PrintArticleForecastComponent.this.includeInventoryData != null ? ((CheckBox)PrintArticleForecastComponent.this.includeInventoryData.getElement()).isChecked() : false;
                boolean iStock = PrintArticleForecastComponent.this.includeStockData != null ? ((CheckBox)PrintArticleForecastComponent.this.includeStockData.getElement()).isChecked() : false;
                Timestamp ts = ((DateTimeChooser)PrintArticleForecastComponent.this.dateTimeChooser.getElement()).getTimestamp();
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createArticleForecast(new ListWrapper(articles), new TimestampWrapper(ts), iInventory, iStock).getValue();
                PrintArticleForecastComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleForecastComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleForecastComponent.this.layoutInheritedComponents(parent);
            y += PrintArticleForecastComponent.this.border;
            if (PrintArticleForecastComponent.this.dateTimeChooser != null) {
                PrintArticleForecastComponent.this.dateTimeChooser.setLocation(PrintArticleForecastComponent.this.border, y);
                PrintArticleForecastComponent.this.dateTimeChooser.setSize(parent.getWidth() - 2 * PrintArticleForecastComponent.this.border, (int)PrintArticleForecastComponent.this.dateTimeChooser.getPreferredSize().getHeight());
                y = PrintArticleForecastComponent.this.dateTimeChooser.getY() + PrintArticleForecastComponent.this.dateTimeChooser.getHeight() + PrintArticleForecastComponent.this.border * 2;
            }
            PrintArticleForecastComponent.this.includeInventoryData.setLocation(PrintArticleForecastComponent.this.border, y);
            PrintArticleForecastComponent.this.includeInventoryData.setSize(PrintArticleForecastComponent.this.includeInventoryData.getPreferredSize());
            PrintArticleForecastComponent.this.includeStockData.setLocation(PrintArticleForecastComponent.this.border, PrintArticleForecastComponent.this.includeInventoryData.getY() + PrintArticleForecastComponent.this.includeInventoryData.getHeight() + PrintArticleForecastComponent.this.border);
            PrintArticleForecastComponent.this.includeStockData.setSize(PrintArticleForecastComponent.this.includeStockData.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleForecastComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintArticleForecastComponent.this.border;
            h = (int)((double)h + PrintArticleForecastComponent.this.dateTimeChooser.getPreferredSize().getHeight());
            h += PrintArticleForecastComponent.this.border;
            h = (int)((double)h + PrintArticleForecastComponent.this.includeInventoryData.getPreferredSize().getHeight());
            h += PrintArticleForecastComponent.this.border;
            h = (int)((double)h + PrintArticleForecastComponent.this.includeStockData.getPreferredSize().getHeight());
            return new Dimension(w, h += PrintArticleForecastComponent.this.border);
        }
    }
}

