/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.supplier.purchasedetails;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.SupplierPurchaseDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.SupplierSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class PurchaseAnalysisDetailedComponent
extends DefaultServerSideAnalysisComponent<SupplierLight, SupplierReference> {
    private static final long serialVersionUID = 1L;
    private Node<SupplierPurchaseDetailsReportConfiguration> configNode;
    private TitledPeriodEditor periodEditor;

    public PurchaseAnalysisDetailedComponent(AnalysisSmartExternalOpenTool<SupplierLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        SupplierPurchaseDetailsReportConfiguration config = new SupplierPurchaseDetailsReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)n, null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.periodEditor, "period"));
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE_SUMMARY;
    }

    @Override
    public String getTitleValue() {
        return Words.SUPPLIERS;
    }

    @Override
    public SupplierReference createReference(SupplierLight item) {
        return new SupplierReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        SupplierSearchConfiguration supplierSearch = (SupplierSearchConfiguration)this.getSearchConfiguration();
        this.configNode.commit();
        SupplierPurchaseDetailsReportConfiguration config = (SupplierPurchaseDetailsReportConfiguration)this.configNode.getValue();
        config.setConfig(supplierSearch);
        config.setPeriod(this.periodEditor.getPeriod());
        PegasusFileComplete file = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderDetailsAnalysis(config).getValue();
        return file;
    }
}

