/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.ais;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.submodules.print.flight.allergeninfosheet.PrintAllergenInfoSheetComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.RadioButtonBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AnalysisProductAllergenInfoSheetComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<RadioButton> grouped;
    private TitledItem<RadioButton> detailed;
    private TitledItem<CheckBox> includeAllergenCodeIndex;

    public AnalysisProductAllergenInfoSheetComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        TitledItem<RadioButtonBox> box = new TitledItem<RadioButtonBox>(new RadioButtonBox(), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.grouped = new TitledItem<RadioButton>(new RadioButton(), Words.GROUPED, TitledItem.TitledItemOrientation.EAST);
        this.detailed = new TitledItem<RadioButton>(new RadioButton(), Words.DETAILED_VIEW, TitledItem.TitledItemOrientation.EAST);
        box.getElement().setBorder(0);
        this.grouped.getElement().setChecked(true);
        box.getElement().addBox(this.grouped, this.grouped.getElement());
        box.getElement().addBox(this.detailed, this.detailed.getElement());
        this.includeAllergenCodeIndex = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALLERGEN_CODE_INDEX, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.addOptionsItem(new RadioButtonBoxAnalysisItem(box, "box"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllergenCodeIndex, "allergenCodeIndex"));
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public String getTitleString() {
        return Words.ALLERGEN_INFO_SHEET;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        boolean b = PrintAllergenInfoSheetComponent.showImage((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue());
        ReportTypeE e = b ? ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHIMAGE : ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHOUTIMAGE;
        ReportFileComplete selectedSheet = null;
        List sheets = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportStylesheets(e).getList();
        for (ReportFileComplete ss : sheets) {
            if (this.grouped.getElement().isChecked()) {
                if (!ss.getDescription().contains("grouped")) continue;
                selectedSheet = ss;
                continue;
            }
            if (ss.getDescription().contains("grouped")) continue;
            selectedSheet = ss;
        }
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductAllergenInfoSheet(new ListWrapper(references), new DateWrapper(date), this.includeAllergenCodeIndex.getElement().isChecked(), selectedSheet).getValue();
        return file;
    }
}

