/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.job.produced;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionJobProducedComponent
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<JobComplete> node;
    private RowModel<JobComplete> model;
    private TitledItem<ComboBox> jobProduced;
    private boolean jobDone = false;

    public ActionJobProducedComponent(Node<JobComplete> node, RowModel<JobComplete> model) {
        this.node = node;
        this.model = model;
        this.setLayout(new Layout());
        this.jobProduced = new TitledItem<ComboBox>(ComboBoxFactory.getYesNoComboBox(false), "Produced", TitledItem.TitledItemOrientation.NORTH);
        this.jobProduced.getElement().addItem("-");
        this.jobProduced.getElement().setSelectedItem("-");
        this.jobProduced.fadeIn();
        this.add(this.jobProduced);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.jobProduced != null) {
            this.jobProduced.kill();
        }
        this.jobProduced = null;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            if (this.jobDone) {
                this.popup.hidePopUp(new Object[0]);
            } else {
                this.jobProduced.setVisible(false);
                this.showAnimation(Words.SAVE_DATA);
                ThreadSafeLoader.run(this.getJob());
                this.popup.enableCancelButton(false);
                this.popup.enableOKButton(false);
            }
        } else {
            super.enterPressed(isOK);
        }
    }

    public ThreadSafeExecutable getJob() {
        this.jobDone = true;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).jobProduced(new JobReference(((JobComplete)ActionJobProducedComponent.this.node.getValue()).getId()));
                JobComplete job = (JobComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getJob(new JobReference(((JobComplete)ActionJobProducedComponent.this.node.getValue()).getId())).getValue();
                ActionJobProducedComponent.this.node.removeExistingValues();
                ActionJobProducedComponent.this.node.setValue((Object)job, 0L);
                ActionJobProducedComponent.this.node.updateNode();
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionJobProducedComponent.this.model.updateView();
                        ActionJobProducedComponent.this.popup.hideCancelButton();
                        ActionJobProducedComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionJobProducedComponent.this.popup.hideScheduled(300, Words.SUCCESSFUL);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ActionJobProducedComponent.this);
                        ActionJobProducedComponent.this.hideAnimation();
                        ActionJobProducedComponent.this.showMessage("Error occurred");
                        ActionJobProducedComponent.this.popup.hideCancelButton();
                        ActionJobProducedComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionJobProducedComponent.this.popup.enableOKButton(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.jobProduced != null ? this.jobProduced.getElement().isInnerComponent(c) : false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ActionJobProducedComponent.this.border;
            if (ActionJobProducedComponent.this.jobProduced != null) {
                currentY = (int)((double)currentY + (ActionJobProducedComponent.this.jobProduced.getPreferredSize().getHeight() + (double)ActionJobProducedComponent.this.border));
            }
            return new Dimension(0, currentY);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionJobProducedComponent.this.layoutAnimation(parent);
            int currentY = ActionJobProducedComponent.this.border;
            if (ActionJobProducedComponent.this.jobProduced != null) {
                ActionJobProducedComponent.this.jobProduced.setLocation(ActionJobProducedComponent.this.border, currentY);
                ActionJobProducedComponent.this.jobProduced.setSize(parent.getWidth() - 2 * ActionJobProducedComponent.this.border, (int)ActionJobProducedComponent.this.jobProduced.getPreferredSize().getHeight());
            }
        }
    }
}

