/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sob.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SOBDetailsPanel
extends DefaultDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private TitledItem<RDTextField> barSetNumber;
    private TitledItem<RDTextField> touchPCNumbers;
    private TitledItem<RDCheckBox> loadToHandheld;
    private final FlightEditableChecker checker = new FlightEditableChecker();

    public SOBDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_DATA);
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.barSetNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.BAR_SET_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.touchPCNumbers = new TitledItem<RDTextField>(new RDTextField(provider), Words.TOUCH_PC, TitledItem.TitledItemOrientation.NORTH);
        if (s.getAutoUploadSoBDataOnStateChangeEnRoute().booleanValue()) {
            this.loadToHandheld = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.LOAD_FLIGHT_TO_HANDHELD, TitledItem.TitledItemOrientation.EAST);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.barSetNumber);
        this.addToView(this.touchPCNumbers);
        if (this.loadToHandheld != null) {
            this.addToView(this.loadToHandheld);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.barSetNumber.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        this.barSetNumber.setEnabled(b);
        this.touchPCNumbers.setEnabled(b);
        if (this.loadToHandheld != null) {
            this.loadToHandheld.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.barSetNumber.kill();
        this.touchPCNumbers.kill();
        if (this.loadToHandheld != null) {
            this.loadToHandheld.kill();
        }
        this.barSetNumber = null;
        this.loadToHandheld = null;
        this.touchPCNumbers = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.barSetNumber);
        CheckedListAdder.addToList(focusList, this.touchPCNumbers);
        CheckedListAdder.addToList(focusList, this.loadToHandheld);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.root = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.barSetNumber.getElement().setNode(node.getChildNamed(FlightLight_.sobBarSetNumber));
        if (this.loadToHandheld != null) {
            this.loadToHandheld.getElement().setNode(node.getChildNamed(FlightLight_.sobLoadFlightToHandheld));
        }
        this.touchPCNumbers.getElement().setNode(node.getChildNamed(FlightComplete_.sobTouchPcIds));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SOBDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SOBDetailsPanel.this.barSetNumber.getPreferredSize().getHeight());
            h += SOBDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SOBDetailsPanel.this.touchPCNumbers.getPreferredSize().getHeight());
            if (SOBDetailsPanel.this.loadToHandheld != null) {
                h += SOBDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + SOBDetailsPanel.this.loadToHandheld.getPreferredSize().getHeight());
            }
            return new Dimension((int)((double)SOBDetailsPanel.this.horizontalBorder + SOBDetailsPanel.this.barSetNumber.getPreferredSize().getWidth() + (double)SOBDetailsPanel.this.horizontalBorder), h += SOBDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            SOBDetailsPanel.this.barSetNumber.setLocation(SOBDetailsPanel.this.horizontalBorder, SOBDetailsPanel.this.verticalBorder);
            SOBDetailsPanel.this.barSetNumber.setSize(SOBDetailsPanel.this.barSetNumber.getPreferredSize());
            SOBDetailsPanel.this.touchPCNumbers.setLocation(SOBDetailsPanel.this.horizontalBorder, SOBDetailsPanel.this.barSetNumber.getY() + SOBDetailsPanel.this.barSetNumber.getHeight() + SOBDetailsPanel.this.verticalBorder);
            SOBDetailsPanel.this.touchPCNumbers.setSize(SOBDetailsPanel.this.touchPCNumbers.getPreferredSize());
            if (SOBDetailsPanel.this.loadToHandheld != null) {
                SOBDetailsPanel.this.loadToHandheld.setLocation(SOBDetailsPanel.this.horizontalBorder, SOBDetailsPanel.this.touchPCNumbers.getY() + SOBDetailsPanel.this.touchPCNumbers.getHeight() + SOBDetailsPanel.this.inner_verticalBorder);
                SOBDetailsPanel.this.loadToHandheld.setSize(SOBDetailsPanel.this.loadToHandheld.getPreferredSize());
            }
        }
    }
}

