/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sob;

import ch.icit.pegasus.client.ClientIDToolkit;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Coordinate3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SalesOnBoardModuleDataHandler
extends DefaultDataHandler<FlightReference, FlightComplete> {
    public SalesOnBoardModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<FlightReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node writeNode = node;
                Node retNode = null;
                writeNode.commit(FlightComplete.class);
                Node id = writeNode.getChildNamed(ADTO_.id);
                FlightComplete newDTO = null;
                ArrayList errorCallback = new ArrayList();
                if (id.getValue() == null) {
                    FlightComplete oldDTO = (FlightComplete)node.getValue(FlightComplete.class);
                    switch (oldDTO.getFlightState()) {
                        case CANCELLED: 
                        case OPEN: {
                            List spmlOrders = oldDTO.getSpmlOrders();
                            List additionalOrders = oldDTO.getAdditionalOrders();
                            oldDTO.setSpmlOrders(new ArrayList());
                            oldDTO.setAdditionalOrders(new ArrayList());
                            FlightComplete o = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(oldDTO, errorCallback);
                            if (errorCallback.isEmpty()) {
                                Coordinate3dComplete c2;
                                Coordinate3dComplete c1;
                                GalleyEquipmentSetLight es2;
                                GalleyEquipmentLight eq2;
                                Object es;
                                GalleyEquipmentLight eq;
                                newDTO = o;
                                if (additionalOrders.isEmpty() && spmlOrders.isEmpty()) break;
                                Node addSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                Node smplSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                for (SpecialMealOrderComplete order : spmlOrders) {
                                    DeliverySpaceComplete s2;
                                    if (!order.getMenuType().getAdditional().booleanValue() || order.getStowingPosition().getId() == null) {
                                        order.setStowingPosition(null);
                                    }
                                    if (order.getStowingPosition() != null) {
                                        for (DeliverySpaceComplete s2 : (List)smplSpaces.getValue()) {
                                            eq = s2.getContainingEquipment();
                                            es = eq.getContainingGalley();
                                            eq2 = order.getStowingPosition().getContainingEquipment();
                                            es2 = eq2.getContainingGalley();
                                            if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                            c1 = s2.getCoordinates();
                                            c2 = order.getStowingPosition().getCoordinates();
                                            if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                            order.setStowingPosition(s2);
                                        }
                                    }
                                    ArrayList<FlightLegComplete> newLegs = new ArrayList<FlightLegComplete>();
                                    s2 = order.getLegs().iterator();
                                    while (s2.hasNext()) {
                                        FlightLegComplete oldLeg = (FlightLegComplete)s2.next();
                                        for (FlightLegComplete l : newDTO.getLegs()) {
                                            if (!oldLeg.getNumber().equals(l.getNumber())) continue;
                                            newLegs.add(l);
                                        }
                                    }
                                    order.setLegs(newLegs);
                                }
                                for (SpecialMealOrderComplete order : additionalOrders) {
                                    if (order.getStowingPosition() != null) {
                                        if (order.getStowingPosition().getId() == null) {
                                            order.setStowingPosition(null);
                                        }
                                        for (DeliverySpaceComplete s2 : (List)addSpaces.getValue()) {
                                            eq = s2.getContainingEquipment();
                                            es = eq.getContainingGalley();
                                            eq2 = order.getStowingPosition().getContainingEquipment();
                                            es2 = eq2.getContainingGalley();
                                            if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                            c1 = s2.getCoordinates();
                                            c2 = order.getStowingPosition().getCoordinates();
                                            if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                            order.setStowingPosition(s2);
                                        }
                                    }
                                    for (FlightLegComplete l : newDTO.getLegs()) {
                                        if (!order.getLeg().getNumber().equals(l.getNumber())) continue;
                                        order.setLeg((ILegComplete)l);
                                    }
                                }
                                newDTO.setAdditionalOrders(additionalOrders);
                                newDTO.setSpmlOrders(spmlOrders);
                                o = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(newDTO, new ListWrapper(errorCallback), false, false, false, false).getObject();
                                if (!errorCallback.isEmpty()) {
                                    retNode = new Node();
                                    retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                                    break;
                                }
                                newDTO = o;
                                break;
                            }
                            retNode = new Node();
                            retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                            break;
                        }
                        case CLOSED: {
                            break;
                        }
                        case EN_ROUTE: {
                            break;
                        }
                        case PLANNED: {
                            break;
                        }
                    }
                } else {
                    FlightSealsComplete fsc;
                    FlightComplete dto;
                    FlightComplete oDto = dto = (FlightComplete)node.getValue(FlightComplete.class);
                    StowingListLight oldList = null;
                    if (node.getChildNamed(DtoFieldConstants.oldStw) != null) {
                        oldList = (StowingListLight)node.getChildNamed(DtoFieldConstants.oldStw).getValue();
                    }
                    StowingListLight newList = dto.getActiveStowingList();
                    FlightComplete o = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(dto, new ListWrapper(errorCallback), false, false, false, false).getObject();
                    Node seals = NodeToolkit.getAffixNamed((String)"SealedEQs");
                    if (seals != null && (fsc = (FlightSealsComplete)seals.getValue()) != null) {
                        StowingToolkit.ensureSealState((FlightLight)o, (FlightSealsComplete)fsc);
                        ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateSeals(fsc);
                    }
                    if (errorCallback.isEmpty()) {
                        newDTO = o;
                    } else {
                        retNode = new Node();
                        retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                    }
                }
                if (retNode != null) {
                    return retNode;
                }
                if (newDTO != null) {
                    node.removeExistingValues();
                    node.setValue(newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<FlightComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightComplete fc = (FlightComplete)node.getValue(FlightComplete.class);
                ArrayList errorCallback = new ArrayList();
                fc.setActiveStowingList(null);
                FlightComplete o = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(fc, errorCallback);
                if (errorCallback.isEmpty()) {
                    node.removeExistingValues();
                    node.setValue((Object)o, 0L);
                    node.updateNode();
                    return node;
                }
                Node retNode = new Node();
                retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SalesOnBoardModuleDataHandler.this.setCurrentLoadMaximum(13);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightStateE();
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllTruckTourTypes();
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealChecks();
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealTypes();
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                SalesOnBoardModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SalesOnBoardModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<FlightComplete> resetData(Node<FlightComplete> node) {
        return null;
    }

    @Override
    public Node<FlightComplete> createEmptyNode() {
        FlightComplete f = new FlightComplete();
        f.setClientOId(Long.valueOf(ADTO.getNextId()));
        f.setFlightState(FlightStateE.OPEN);
        f.setFlightType(FlightTypeE.RETURN);
        f.setSta(new Timestamp(System.currentTimeMillis()));
        f.setStd(new Timestamp(System.currentTimeMillis()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, false);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, "Refresh Flight");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node dtoNode = null;
                Long id = (Long)node.getValueForNamed("id");
                FlightComplete nflight = null;
                boolean isOpen = false;
                if (id != null) {
                    isOpen = true;
                    nflight = SalesOnBoardModuleDataHandler.this.loadCompleteFlight((FlightReference)node.getValue());
                    GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
                    g.setContainsSalesOnBoardProducts(Boolean.valueOf(true));
                    g.setFlight(new FlightReference(nflight.getId()));
                    FlightSealsComplete eqs = (FlightSealsComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue();
                    NodeToolkit.removeAffixNamed((String)"SealedEQs");
                    Node sealedEqs = INodeCreator.getDefaultImpl().getNode4DTO((Object)eqs, false, false);
                    sealedEqs.setName("SealedEQs");
                    NodeToolkit.addAffix((Node)sealedEqs);
                } else {
                    FlightLight f = (FlightLight)node.getValue(FlightLight.class);
                    f.setFlightState(FlightStateE.PLANNED);
                    nflight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(f).getValue();
                    ClientIDToolkit.initClientIds((ADTO)nflight, new ArrayList());
                }
                dtoNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)nflight, false, false);
                if (id != null && nflight != null) {
                    boolean isDeleteable = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).isFlightDeleteable(nflight);
                    Node delete = dtoNode.getChildNamed(DtoFieldConstants.deletable);
                    if (delete == null) {
                        delete = new Node();
                        delete.setName(DtoFieldConstants.deletable);
                        dtoNode.addChild(delete, 0L);
                    }
                    delete.setValue((Object)isDeleteable, 0L);
                }
                SalesOnBoardModuleDataHandler.revalidateMasterData(nflight, isOpen, (Node<FlightReference>)dtoNode);
                return dtoNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public static void revalidateMasterData(FlightComplete nflight, boolean isOpen, Node<FlightReference> node) throws ClientServerCallException {
        NodeToolkit.removeAffixNamed((String)"plegs");
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
        Node adSPMLPos = null;
        if (nflight != null && nflight.getActiveStowingList() != null) {
            adSPMLPos = isOpen ? INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces((FlightReference)nflight).getList(), false) : INodeCreator.getDefaultImpl().createNodes(((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalSPMLOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList(), false);
            if (adSPMLPos != null) {
                adSPMLPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
                NodeToolkit.addAffix((Node)adSPMLPos);
            }
            Node addPos = null;
            addPos = isOpen ? INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces((FlightReference)nflight).getList(), false) : INodeCreator.getDefaultImpl().createNodes(((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList(), false);
            if (addPos != null) {
                NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                addPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                NodeToolkit.addAffix((Node)addPos);
            }
        }
        if (node != null) {
            Node stw = node.getChildNamed(DtoFieldConstants.oldStw);
            if (stw == null) {
                stw = new DTONode();
                stw.setName(DtoFieldConstants.oldStw);
                node.addChild(stw, 0L);
            }
            if (nflight != null) {
                stw.setValue((Object)nflight.getActiveStowingList(), 0L);
            }
            Node legs = node.getChildNamed(FlightLight_.legs);
            ViewNode n = new ViewNode("plegs");
            Iterator it = legs.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node leg = (Node)it.next();
                n.addChild(leg, 0L);
            }
            n.setName("plegs");
            n.setValue(legs.getValue(), 0L);
            NodeToolkit.addAffix((Node)n);
        }
    }

    public FlightComplete loadCompleteFlight(FlightReference l) throws ClientServerCallException {
        return (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(l.getId())).getValue();
    }

    @Override
    public Class<FlightComplete> getCommittingClass() {
        return FlightComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<FlightReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

