/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.utils.CopyServiceProductVariantPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ServiceProductAccess;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class VariantDetailsPanel
extends AVariantDetailsPanel<ServiceProductComplete> {
    private static final long serialVersionUID = 1L;

    public VariantDetailsPanel(RowEditor<ServiceProductComplete> editor, RDProvider provider) {
        super((RowEditor)editor, provider);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        int tw2 = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 30, 30, 30));
        tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        this.table.updateOrder();
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Date t = new PeriodComplete((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductComplete_.period, PeriodComplete_.startDate}).getValue(), null).getStartDate();
        long lastDate = t.getTime();
        --lastDate;
        boolean invalid = false;
        for (Table2RowPanel p : this.table.getRows()) {
            validationObjects.addAll(((TableRowImpl)p).validateRow());
            Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
            PeriodComplete pc = new PeriodComplete(s, e);
            Date d = pc.getStartDate();
            if (lastDate + 1L != d.getTime()) {
                invalid = true;
            }
            d = pc.getEndDate();
            lastDate = d.getTime();
        }
        Date d = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductComplete_.period, PeriodComplete_.endDate}).getValue();
        long endDate = new PeriodComplete(null, d).getEndDate().getTime();
        if (lastDate != endDate) {
            invalid = true;
        }
        if (invalid) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
        return validationObjects;
    }

    @Override
    public Table2RowPanel getTableRow(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public boolean isVariantParent(Node<?> node) {
        return node.getValue() instanceof ServiceProductComplete;
    }

    @Override
    public void reloadVariant(final Node n, final Table2RowPanel p) {
        this.editor.showCommittingAnimation(Words.RELOAD_VARIANT);
        this.editor.setEnabled(false);
        ServiceProductVariantComplete c = (ServiceProductVariantComplete)n.getValue(ServiceProductVariantComplete.class);
        if (c == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SystemSettingsComplete s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached().getValue();
                    ServiceProductVariantComplete cc = (ServiceProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getServiceProductVariant((ServiceProductVariantReference)n.getValue(ServiceProductVariantReference.class)).getValue();
                    n.removeExistingValues();
                    n.setValue((Object)cc, 0L);
                    n.updateNode();
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            VariantDetailsPanel.this.updatePanels(node, p);
                            VariantDetailsPanel.this.editor.createFocusCycle();
                        }

                        public void errorOccurred(ClientException exception) {
                            VariantDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            ServiceProductVariantComplete variant = (ServiceProductVariantComplete)n.getValue(ServiceProductVariantComplete.class);
            n.removeExistingValues();
            n.setValue((Object)variant, 0L);
            n.updateNode();
            this.updatePanels(n, p);
        }
    }

    @Override
    public Class getCommittingClass(Node<?> node) {
        return ServiceProductVariantComplete.class;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private TextLabel price;
        private TextLabel state;
        private AddButton cloneButton;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            boolean isAccepted = m.getNode().getChildNamed(ServiceProductVariantComplete_.state).getValue() == ModificationStateE.ACCEPTED;
            this.startDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.startDate.setOverrideName(ServiceProductAccess.EDIT_VARIANT);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.endDate.setOverrideName(ServiceProductAccess.EDIT_VARIANT);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
            this.price = new TextLabel(m.getNode().getChildNamed(ServiceProductVariantComplete_.salesPrice), ConverterRegistry.getConverter(PriceConverter2.class));
            this.state = new TextLabel(m.getNode().getChildNamed(ServiceProductVariantComplete_.state), ConverterRegistry.getConverter(ModificationStateEConverter.class));
            boolean isDeletable = VariantDetailsPanel.this.provider.isWritable(ServiceProductAccess.REMOVE_VARIANT) && m.getNode().getChildNamed(ServiceProductVariantComplete_.state).getValue() != ModificationStateE.ACCEPTED;
            boolean isAddable = VariantDetailsPanel.this.provider.isWritable(ServiceProductAccess.ADD_VARIANT);
            if (isDeletable && !isAccepted) {
                this.delete = new DeleteButton();
            }
            if (isAddable && m.getNode().getChildNamed(ServiceProductVariantComplete.ID_).getValue() != null) {
                this.cloneButton = new AddButton();
            }
            if (this.delete != null) {
                this.delete.addButtonListener(this);
            }
            if (this.cloneButton != null) {
                this.cloneButton.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.price);
            this.add(this.state);
            if (this.cloneButton != null) {
                this.add(this.cloneButton);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Color getRowColor(Table2RowPanel p) {
            boolean isNew;
            boolean bl = isNew = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_ONE) != null;
            if (isNew) {
                Color background = new Color(100, 100, 100);
                return background;
            }
            return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
        }

        protected List<ScreenValidationObject> validateRow() {
            return ValidationUtil.validatePeriod((Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.startDate}), (Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductVariantComplete_.validityPeriod, PeriodComplete_.endDate}), this.startDate, this.endDate);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.price.kill();
            this.state.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.cloneButton != null) {
                this.cloneButton.kill();
            }
            this.startDate = null;
            this.endDate = null;
            this.price = null;
            this.state = null;
            this.delete = null;
            this.cloneButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.startDate);
            CheckedListAdder.addToList(focusList, this.endDate);
            CheckedListAdder.addToList(focusList, this.cloneButton);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(isEnabled);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.cloneButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.cloneButton, true, true, Words.COPY_VARIANT);
                popUp.setView(new CopyServiceProductVariantPopup(this.model.getNode()));
                popUp.showPopUp(x, y, -1, -1, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        Node nNode = (Node)xargs[0];
                        TableRowImpl.this.model.getNode().getParent().addChild(nNode, System.currentTimeMillis());
                    }
                }, this.cloneButton);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(parent.getWidth() - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                int ax = currentX + TableRowImpl.this.getCellPadding();
                if (TableRowImpl.this.cloneButton != null) {
                    TableRowImpl.this.cloneButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cloneButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cloneButton.setSize(TableRowImpl.this.cloneButton.getPreferredSize());
                    ax = TableRowImpl.this.cloneButton.getX() + TableRowImpl.this.cloneButton.getWidth() + TableRowImpl.this.getCellPadding();
                }
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(ax, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

